/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import rice.pastry.NodeId;
import rice.pastry.messaging.Address;
import rice.pastry.security.Credentials;

public abstract class Message
implements Serializable {
    private Address destination;
    private NodeId senderId;
    private boolean priority;
    private transient Credentials credentials;
    private transient Date theStamp;
    private transient ObjectInputStream stream;

    public Address getDestination() {
        return this.destination;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Date getDate() {
        return this.theStamp;
    }

    public NodeId getSenderId() {
        return this.senderId;
    }

    public void setSenderId(NodeId nodeId) {
        this.senderId = nodeId;
    }

    public boolean hasPriority() {
        return this.priority;
    }

    protected void setPriority(boolean bl) {
        this.priority = bl;
    }

    public ObjectInputStream getStream() {
        return this.stream;
    }

    public boolean stamp(Date date) {
        if (this.theStamp.equals(null)) {
            this.theStamp = date;
            return true;
        }
        return false;
    }

    public Message(Address address) {
        this.destination = address;
        this.senderId = null;
        this.credentials = null;
        this.theStamp = null;
        this.priority = false;
    }

    public Message(Address address, Credentials credentials) {
        this.destination = address;
        this.senderId = null;
        this.credentials = credentials;
        this.theStamp = null;
        this.priority = false;
    }

    public Message(Address address, Credentials credentials, Date date) {
        this.destination = address;
        this.senderId = null;
        this.credentials = credentials;
        this.theStamp = date;
        this.priority = false;
    }

    public Message(Address address, Date date) {
        this.destination = address;
        this.theStamp = date;
        this.senderId = null;
        this.priority = false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stream = objectInputStream;
    }
}

