/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.messaging;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;

public class MessageDispatch {
    public static int BUFFER_SIZE = 32;
    private HashMap addressBook = new HashMap();
    private Hashtable buffer = new Hashtable();
    private int bufferCount = 0;

    public void registerReceiver(Address address, MessageReceiver messageReceiver) {
        if (this.addressBook.get(address) != null) {
            System.out.println("ERROR - Registering receiver for already-registered address " + address);
        }
        this.addressBook.put(address, messageReceiver);
    }

    public boolean dispatchMessage(Message message) {
        MessageReceiver messageReceiver = (MessageReceiver)this.addressBook.get(message.getDestination());
        if (messageReceiver != null) {
            Address address = message.getDestination();
            messageReceiver.receiveMessage(message);
            this.deliverBuffered(address);
            return true;
        }
        if (this.bufferCount > BUFFER_SIZE) {
            System.out.println("Could not dispatch message " + message + " because the application address " + message.getDestination() + " was unknown.");
            System.out.println("Message is going to be dropped on the floor.");
        } else {
            Vector<Message> vector = (Vector<Message>)this.buffer.get(message.getDestination());
            if (vector == null) {
                vector = new Vector<Message>();
                this.buffer.put(message.getDestination(), vector);
            }
            vector.add(message);
            ++this.bufferCount;
        }
        return false;
    }

    protected void deliverBuffered(Address address) {
        Vector vector = (Vector)this.buffer.remove(address);
        if (vector != null) {
            MessageReceiver messageReceiver = (MessageReceiver)this.addressBook.get(address);
            for (int i = 0; i < vector.size(); ++i) {
                messageReceiver.receiveMessage((Message)vector.elementAt(i));
                --this.bufferCount;
            }
        }
    }
}

