/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.rmi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.rmi.RemoteException;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistCoalesedNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.rmi.RMIPastryNode;
import rice.pastry.rmi.RMIRemoteNodeI;
import rice.pastry.routing.RouteMessage;

public class RMINodeHandle
extends DistCoalesedNodeHandle {
    private RMIRemoteNodeI remoteNode;
    public static transient int index = 0;
    public transient int id;
    private transient long lastpingtime;
    private static final long pingthrottle = 14L;

    public RMINodeHandle(RMIRemoteNodeI rMIRemoteNodeI, NodeId nodeId, InetSocketAddress inetSocketAddress) {
        super(nodeId, inetSocketAddress);
        if (Log.ifp(6)) {
            System.out.println("creating RMI handle for node: " + nodeId);
        }
        this.init(rMIRemoteNodeI, nodeId);
    }

    public RMINodeHandle(RMIRemoteNodeI rMIRemoteNodeI, NodeId nodeId, PastryNode pastryNode, InetSocketAddress inetSocketAddress) {
        super(nodeId, inetSocketAddress);
        if (Log.ifp(6)) {
            System.out.println("creating RMI handle for node: " + nodeId + ", local = " + pastryNode);
        }
        this.init(rMIRemoteNodeI, nodeId);
        this.setLocalNode(pastryNode);
    }

    private void init(RMIRemoteNodeI rMIRemoteNodeI, NodeId nodeId) {
        this.remoteNode = rMIRemoteNodeI;
        this.nodeId = nodeId;
        this.lastpingtime = 0L;
        this.id = index++;
    }

    public RMIRemoteNodeI getRemote() {
        return this.remoteNode;
    }

    public void setRemoteNode(RMIRemoteNodeI rMIRemoteNodeI) {
        if (this.remoteNode != null) {
            System.out.println("panic");
        }
        this.remoteNode = rMIRemoteNodeI;
    }

    public void receiveMessageImpl(Message message) {
        this.assertLocalNode();
        if (this.isLocal) {
            this.getLocalNode().receiveMessage(message);
            return;
        }
        if (!this.alive && Log.ifp(6)) {
            System.out.println("warning: trying to send msg to dead node " + this.nodeId + ": " + message);
        }
        if (!this.isInPool) {
            System.out.println("panic: sending message to unverified handle " + this + " for " + this.nodeId + ": " + message);
        }
        message.setSenderId(this.getLocalNode().getNodeId());
        if (Log.ifp(6)) {
            System.out.println("sending " + (message instanceof RouteMessage ? "route" : "direct") + " msg to " + this.nodeId + ": " + message);
        }
        RMIPastryNode rMIPastryNode = (RMIPastryNode)this.getLocalNode();
        rMIPastryNode.enqueueSendMsg(message, this);
    }

    public void doSend(Message message) {
        block7: {
            try {
                this.remoteNode.remoteReceiveMessage(message, this.nodeId);
                this.markAlive();
            }
            catch (RemoteException remoteException) {
                if (Log.ifp(6)) {
                    System.out.println("message failed: " + message + remoteException);
                }
                if (this.isLocal) {
                    System.out.println("panic; local message failed: " + message);
                }
                this.markDead();
                if (Log.ifp(6)) {
                    System.out.println("bouncing message back to self at " + this.getLocalNode());
                }
                if (message instanceof RouteMessage) {
                    RouteMessage routeMessage = (RouteMessage)message;
                    routeMessage.nextHop = null;
                    if (Log.ifp(6)) {
                        System.out.println("this msg bounced is " + routeMessage);
                    }
                    this.getLocalNode().receiveMessage(routeMessage);
                }
                if (!Log.ifp(6)) break block7;
                System.out.println("msg dropped on floor due to dead node " + message);
            }
        }
    }

    public boolean pingImpl() {
        if (this.isLocal || this.getLocalNode() == null) {
            return this.alive;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastpingtime < 14000L) {
            return this.alive;
        }
        this.lastpingtime = l;
        RMIPastryNode rMIPastryNode = (RMIPastryNode)this.getLocalNode();
        rMIPastryNode.enqueueSendMsg(null, this);
        return this.alive;
    }

    public void doPing() {
        if (Log.ifp(7)) {
            System.out.println(this.getLocalNode() + " pinging " + this.nodeId);
        }
        try {
            long l = System.currentTimeMillis();
            NodeId nodeId = this.remoteNode.getNodeId();
            long l2 = System.currentTimeMillis();
            if (this.proximity() > (int)(l2 - l)) {
                this.setProximity((int)(l2 - l));
            }
            if (Log.ifp(7)) {
                System.out.println("proximity metric = " + this.proximity());
            }
            if (!nodeId.equals(this.nodeId)) {
                System.out.println("PANIC: remote node has changed its ID from " + this.nodeId + " to " + nodeId);
                this.markDead();
            } else {
                this.markAlive();
            }
        }
        catch (RemoteException remoteException) {
            if (this.alive && Log.ifp(6)) {
                System.out.println("ping failed on live node: " + remoteException);
            }
            this.markDead();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        RMIRemoteNodeI rMIRemoteNodeI = (RMIRemoteNodeI)objectInputStream.readObject();
        NodeId nodeId = (NodeId)objectInputStream.readObject();
        this.init(rMIRemoteNodeI, nodeId);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.isLocal && Log.ifp(7)) {
            this.assertLocalNode();
            System.out.println("writeObject from " + this.getLocalNode().getNodeId() + " to local node " + this.nodeId);
        }
        objectOutputStream.writeObject(this.remoteNode);
        objectOutputStream.writeObject(this.nodeId);
    }

    public String toStringImpl() {
        return (this.isLocal ? "(local " : "") + "handle " + this.nodeId + (this.alive ? "" : ":dead") + ", localnode = " + this.getLocalNode() + ")";
    }
}

