/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.rmi;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.rmi.RMINodeHandle;

class RMINodeHandlePool
extends DistNodeHandlePool {
    private HashMap handles = new HashMap();
    private static int wkrefcount = 0;

    public DistNodeHandle coalesce(DistNodeHandle distNodeHandle) {
        RMINodeHandle rMINodeHandle = (RMINodeHandle)distNodeHandle;
        NodeId nodeId = rMINodeHandle.getNodeId();
        WeakReference weakReference = (WeakReference)this.handles.get(nodeId);
        RMINodeHandle rMINodeHandle2 = null;
        if (weakReference != null && (rMINodeHandle2 = (RMINodeHandle)weakReference.get()) == null) {
            weakReference.clear();
            this.handles.remove(nodeId);
            --wkrefcount;
        }
        if (rMINodeHandle2 == null) {
            WeakReference<RMINodeHandle> weakReference2 = new WeakReference<RMINodeHandle>(rMINodeHandle);
            if (++wkrefcount % 1000 == 0) {
                System.out.println("lots of weak references: wkrefcount = " + wkrefcount);
            }
            this.handles.put(nodeId, weakReference2);
            rMINodeHandle.setIsInPool(true);
            return rMINodeHandle;
        }
        if (rMINodeHandle2 != rMINodeHandle) {
            rMINodeHandle.setIsInPool(false);
        }
        return rMINodeHandle2;
    }

    public void activate(NodeId nodeId) {
        WeakReference weakReference = (WeakReference)this.handles.get(nodeId);
        RMINodeHandle rMINodeHandle = null;
        if (weakReference != null && (rMINodeHandle = (RMINodeHandle)weakReference.get()) == null) {
            weakReference.clear();
            this.handles.remove(nodeId);
            --wkrefcount;
        }
        if (rMINodeHandle != null) {
            rMINodeHandle.markAlive();
        }
    }
}

