/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.rmi;

import java.io.Serializable;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.messaging.Message;
import rice.pastry.rmi.RMINodeHandle;
import rice.pastry.rmi.RMINodeHandlePool;
import rice.pastry.rmi.RMIRemoteNodeI;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;

public class RMIPastryNode
extends DistPastryNode
implements RMIRemoteNodeI {
    private static final int RMISendHandlerPoolSize = 8;
    private static final int RMISendQueueMaxSize = 256;
    private static final int RMIRcvQueueMaxSize = 16;
    private RMIRemoteNodeI remotestub = null;
    private RMINodeHandlePool handlepool = null;
    private int port;
    private LinkedList rcvQueue = new LinkedList();
    private LinkedList sendQueue = new LinkedList();

    public RMIPastryNode(NodeId nodeId) {
        super(nodeId);
    }

    public void setRMIElements(RMINodeHandlePool rMINodeHandlePool, int n, int n2, int n3) {
        this.handlepool = rMINodeHandlePool;
        this.port = n;
        this.leafSetMaintFreq = n2;
        this.routeSetMaintFreq = n3;
    }

    public DistNodeHandlePool getNodeHandlePool() {
        return this.handlepool;
    }

    public RouteSet[] getRouteRow(int n) {
        return this.getRoutingTable().getRow(n);
    }

    public void doneNode(NodeHandle nodeHandle) {
        super.doneNode(nodeHandle);
        new Thread(new RcvMsgHandler()).start();
        for (int i = 0; i < 8; ++i) {
            new Thread(new SendMsgHandler()).start();
        }
        try {
            this.remotestub = (RMIRemoteNodeI)((Object)UnicastRemoteObject.exportObject(this));
        }
        catch (RemoteException remoteException) {
            System.out.println("Unable to acquire stub for Pastry node: " + remoteException.toString());
        }
        ((RMINodeHandle)this.localhandle).setRemoteNode(this.remotestub);
        this.initiateJoin(nodeHandle);
    }

    public final void nodeIsReady() {
        super.nodeIsReady();
        try {
            Naming.rebind("//:" + this.port + "/Pastry", this.remotestub);
        }
        catch (Exception exception) {
            System.out.println("Unable to bind Pastry node in rmiregistry: " + exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remoteReceiveMessage(Message message, NodeId nodeId) throws RemoteException {
        if (!nodeId.equals(this.getNodeId())) {
            throw new RemoteException("RMI: wrong receiver");
        }
        LinkedList linkedList = this.rcvQueue;
        synchronized (linkedList) {
            if (message.hasPriority()) {
                this.rcvQueue.addFirst(message);
            } else {
                this.rcvQueue.add(message);
            }
            if (this.rcvQueue.size() > 16) {
                message = (Message)this.rcvQueue.removeLast();
                System.out.println("RMI: rcv queue at limit, dropping message.." + message);
            } else {
                this.rcvQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueSendMsg(Message message, RMINodeHandle rMINodeHandle) {
        int n;
        LinkedList linkedList = this.sendQueue;
        synchronized (linkedList) {
            if (message != null && message.hasPriority()) {
                this.sendQueue.addFirst(rMINodeHandle);
                this.sendQueue.addFirst(message);
            } else {
                this.sendQueue.add(message);
                this.sendQueue.add(rMINodeHandle);
            }
            n = this.sendQueue.size() / 2;
            if (n > 256) {
                this.sendQueue.removeLast();
                message = (Message)this.sendQueue.removeLast();
                System.out.println("RMI: send queue at limit, dropping message.." + message);
            } else {
                this.sendQueue.notify();
            }
        }
        if (Log.ifp(8)) {
            System.out.println("RMI: sendQueue len=" + n);
        }
    }

    public void kill() {
        super.kill();
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            System.out.println("Unable to unbind Pastry node from rmiregistry: " + noSuchObjectException.toString());
        }
    }

    private class SendMsgHandler
    implements Runnable {
        private SendMsgHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Message message = null;
            RMINodeHandle rMINodeHandle = null;
            while (true) {
                LinkedList linkedList = RMIPastryNode.this.sendQueue;
                synchronized (linkedList) {
                    while (RMIPastryNode.this.sendQueue.size() == 0) {
                        try {
                            RMIPastryNode.this.sendQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        message = (Message)RMIPastryNode.this.sendQueue.removeFirst();
                        rMINodeHandle = (RMINodeHandle)RMIPastryNode.this.sendQueue.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        System.out.println("no msg despite size = " + RMIPastryNode.this.rcvQueue.size());
                        continue;
                    }
                }
                if (message == null) {
                    rMINodeHandle.doPing();
                    continue;
                }
                rMINodeHandle.doSend(message);
            }
        }
    }

    private class RcvMsgHandler
    implements Runnable {
        private RcvMsgHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Message message = null;
                Serializable serializable = RMIPastryNode.this.rcvQueue;
                synchronized (serializable) {
                    while (RMIPastryNode.this.rcvQueue.size() == 0) {
                        try {
                            RMIPastryNode.this.rcvQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        message = (Message)RMIPastryNode.this.rcvQueue.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        System.out.println("no msg despite size = " + RMIPastryNode.this.rcvQueue.size());
                        continue;
                    }
                }
                serializable = message.getSenderId();
                if (Log.ifp(6)) {
                    System.out.println("received " + (message instanceof RouteMessage ? "route" : "direct") + " msg from " + serializable + ": " + message);
                }
                if (serializable != null) {
                    RMIPastryNode.this.handlepool.activate((NodeId)serializable);
                }
                RMIPastryNode.this.receiveMessage(message);
            }
        }
    }
}

