/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.rmi;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistCoalesedNodeHandle;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.rmi.RMINodeHandle;
import rice.pastry.rmi.RMINodeHandlePool;
import rice.pastry.rmi.RMIPastryNode;
import rice.pastry.rmi.RMIPastrySecurityManager;
import rice.pastry.rmi.RMIRemoteNodeI;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;

public class RMIPastryNodeFactory
extends DistPastryNodeFactory {
    public static int NUM_ATTEMPTS = 2;
    public static int DEFAULT_REGISTRY_PORT = 1099;
    private NodeIdFactory nidFactory;
    private int port;
    private static final int rtMax = 1;
    private static final int lSetSize = 24;
    private static final int leafSetMaintFreq = 60;
    private static final int routeSetMaintFreq = 900;
    public static Registry rmiRegistry = null;

    public RMIPastryNodeFactory(NodeIdFactory nodeIdFactory, int n) {
        this.nidFactory = nodeIdFactory;
        this.port = n;
        if (rmiRegistry == null) {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            try {
                rmiRegistry = LocateRegistry.createRegistry(this.port);
            }
            catch (Exception exception) {
                System.out.println("Error starting RMI registry: " + exception);
                System.exit(-1);
            }
        }
    }

    public NodeHandle generateNodeHandle(InetSocketAddress inetSocketAddress) {
        RMIRemoteNodeI rMIRemoteNodeI = null;
        System.out.println("RMI: Attempting to locate bootstrap node " + inetSocketAddress);
        for (int i = 1; rMIRemoteNodeI == null && i <= NUM_ATTEMPTS; ++i) {
            try {
                rMIRemoteNodeI = (RMIRemoteNodeI)Naming.lookup("//" + inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort() + "/Pastry");
            }
            catch (Exception exception) {
                System.out.println("Unable to find bootstrap node on " + inetSocketAddress + " (attempt " + i + "/" + NUM_ATTEMPTS + ")");
            }
            if (rMIRemoteNodeI != null || i == NUM_ATTEMPTS) continue;
            this.pause(1000);
        }
        NodeId nodeId = null;
        if (rMIRemoteNodeI != null) {
            try {
                nodeId = rMIRemoteNodeI.getNodeId();
            }
            catch (RemoteException remoteException) {
                System.out.println("[rmi] Unable to get remote node id: " + remoteException.toString());
                rMIRemoteNodeI = null;
            }
        }
        RMINodeHandle rMINodeHandle = null;
        if (nodeId != null) {
            rMINodeHandle = new RMINodeHandle(rMIRemoteNodeI, nodeId, inetSocketAddress);
        } else {
            System.out.println("Couldn't find a bootstrap node, starting a new ring...");
        }
        return rMINodeHandle;
    }

    public synchronized void pause(int n) {
        System.out.println("waiting for " + n / 1000 + " sec");
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public PastryNode newNode(NodeHandle nodeHandle) {
        return this.newNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    public PastryNode newNode(final NodeHandle nodeHandle, NodeId nodeId) {
        final RMIPastryNode rMIPastryNode = new RMIPastryNode(nodeId);
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost(), DEFAULT_REGISTRY_PORT);
        }
        catch (Exception exception) {
            System.out.println("ERROR (newNode): " + exception);
        }
        final RMINodeHandle rMINodeHandle = new RMINodeHandle(null, nodeId, inetSocketAddress);
        RMINodeHandlePool rMINodeHandlePool = new RMINodeHandlePool();
        RMIPastrySecurityManager rMIPastrySecurityManager = new RMIPastrySecurityManager(rMINodeHandle, rMINodeHandlePool);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable(rMINodeHandle, 1);
        LeafSet leafSet = new LeafSet(rMINodeHandle, 24);
        StandardRouter standardRouter = new StandardRouter(rMINodeHandle, routingTable, leafSet, rMIPastrySecurityManager);
        StandardLeafSetProtocol standardLeafSetProtocol = new StandardLeafSetProtocol(rMIPastryNode, rMINodeHandle, rMIPastrySecurityManager, leafSet, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol(rMINodeHandle, rMIPastrySecurityManager, routingTable);
        StandardJoinProtocol standardJoinProtocol = new StandardJoinProtocol(rMIPastryNode, rMINodeHandle, rMIPastrySecurityManager, routingTable, leafSet);
        messageDispatch.registerReceiver(standardRouter.getAddress(), standardRouter);
        messageDispatch.registerReceiver(standardLeafSetProtocol.getAddress(), standardLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(standardJoinProtocol.getAddress(), standardJoinProtocol);
        rMIPastryNode.setElements(rMINodeHandle, rMIPastrySecurityManager, messageDispatch, leafSet, routingTable);
        rMIPastryNode.setRMIElements(rMINodeHandlePool, this.port, 60, 900);
        rMIPastrySecurityManager.setLocalPastryNode(rMIPastryNode);
        if (nodeHandle != null) {
            nodeHandle.setLocalNode(rMIPastryNode);
        }
        rMINodeHandle.setLocalNode(rMIPastryNode);
        Thread thread = new Thread("Thread for node " + nodeId){

            public void run() {
                rMIPastryNode.doneNode(RMIPastryNodeFactory.this.getNearest(rMINodeHandle, nodeHandle));
            }
        };
        thread.start();
        return rMIPastryNode;
    }

    public LeafSet getLeafSet(NodeHandle nodeHandle) {
        try {
            RMINodeHandle rMINodeHandle = (RMINodeHandle)nodeHandle;
            RMIRemoteNodeI rMIRemoteNodeI = rMINodeHandle.getRemote();
            LeafSet leafSet = rMIRemoteNodeI.getLeafSet();
            return leafSet;
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception " + remoteException + " was thrown while fetching leafset remotely.");
            return null;
        }
    }

    public RouteSet[] getRouteRow(NodeHandle nodeHandle, int n) {
        try {
            RMINodeHandle rMINodeHandle = (RMINodeHandle)nodeHandle;
            RMIRemoteNodeI rMIRemoteNodeI = rMINodeHandle.getRemote();
            return rMIRemoteNodeI.getRouteRow(n);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception " + remoteException + " was thrown while fetching routerow remotely.");
            return new RouteSet[0];
        }
    }

    public int getProximity(NodeHandle nodeHandle, NodeHandle nodeHandle2) {
        try {
            RMINodeHandle rMINodeHandle = (RMINodeHandle)nodeHandle2;
            RMIRemoteNodeI rMIRemoteNodeI = rMINodeHandle.getRemote();
            long l = System.currentTimeMillis();
            rMIRemoteNodeI.getNodeId();
            return (int)(System.currentTimeMillis() - l);
        }
        catch (RemoteException remoteException) {
            System.out.println("Exception " + remoteException + " was thrown while pinging remote node.");
            return DistCoalesedNodeHandle.DEFAULT_DISTANCE;
        }
    }
}

