/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.Serializable;
import rice.p2p.commonapi.Message;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.commonapi.PastryEndpointMessage;
import rice.pastry.messaging.Address;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;

public class RouteMessage
extends rice.pastry.messaging.Message
implements Serializable,
rice.p2p.commonapi.RouteMessage {
    private Id target;
    private rice.pastry.messaging.Message internalMsg;
    private NodeHandle prevNode;
    private transient SendOptions opts;
    private Address auxAddress;
    public transient NodeHandle nextHop;

    public RouteMessage(Id id, rice.pastry.messaging.Message message, Credentials credentials) {
        super(new RouterAddress());
        this.target = id;
        this.internalMsg = message;
        this.opts = new SendOptions();
        this.nextHop = null;
    }

    public RouteMessage(Id id, rice.pastry.messaging.Message message, Credentials credentials, SendOptions sendOptions) {
        super(new RouterAddress());
        this.target = id;
        this.internalMsg = message;
        this.opts = sendOptions;
        this.nextHop = null;
    }

    public RouteMessage(NodeHandle nodeHandle, rice.pastry.messaging.Message message, Credentials credentials, SendOptions sendOptions, Address address) {
        super(new RouterAddress());
        this.target = nodeHandle.getNodeId();
        this.internalMsg = message;
        this.opts = sendOptions;
        this.nextHop = nodeHandle;
        this.auxAddress = address;
    }

    public RouteMessage(Id id, rice.pastry.messaging.Message message, Credentials credentials, Address address) {
        super(new RouterAddress());
        this.target = id;
        this.internalMsg = message;
        this.opts = new SendOptions();
        this.auxAddress = address;
        this.nextHop = null;
    }

    public RouteMessage(Id id, rice.pastry.messaging.Message message, Credentials credentials, SendOptions sendOptions, Address address) {
        super(new RouterAddress());
        this.target = id;
        this.internalMsg = message;
        this.opts = sendOptions;
        this.auxAddress = address;
        this.nextHop = null;
    }

    public RouteMessage(Id id, rice.pastry.messaging.Message message, NodeHandle nodeHandle, Address address) {
        super(new RouterAddress());
        this.target = id;
        this.internalMsg = message;
        this.opts = new SendOptions();
        this.auxAddress = address;
        this.nextHop = nodeHandle;
    }

    public boolean routeMessage(NodeId nodeId) {
        if (this.nextHop == null) {
            return false;
        }
        this.setSenderId(nodeId);
        NodeHandle nodeHandle = this.nextHop;
        this.nextHop = null;
        if (nodeId.equals(nodeHandle.getNodeId())) {
            // empty if block
        }
        if (nodeId.equals(nodeHandle.getNodeId())) {
            nodeHandle.receiveMessage(this.internalMsg);
        } else {
            nodeHandle.receiveMessage(this);
        }
        return true;
    }

    public Id getTarget() {
        return this.target;
    }

    public NodeHandle getPrevNode() {
        return this.prevNode;
    }

    public void setPrevNode(NodeHandle nodeHandle) {
        this.prevNode = nodeHandle;
    }

    public NodeHandle getNextHop() {
        return this.nextHop;
    }

    public void setNextHop(NodeHandle nodeHandle) {
        this.nextHop = nodeHandle;
    }

    public boolean hasPriority() {
        return this.internalMsg.hasPriority();
    }

    public Address getDestination() {
        if (this.nextHop == null || this.auxAddress == null) {
            return super.getDestination();
        }
        return this.auxAddress;
    }

    public rice.pastry.messaging.Message unwrap() {
        return this.internalMsg;
    }

    public SendOptions getOptions() {
        return this.opts;
    }

    public String toString() {
        String string = "";
        if (Log.ifp(7)) {
            string = string + "RouteMessage for target " + this.target;
            if (this.auxAddress != null) {
                string = string + " with aux address " + this.auxAddress;
            }
            string = string + ", wraps ";
            string = string + this.internalMsg;
            if (this.nextHop != null) {
                string = string + ", nexthop = " + this.nextHop.getNodeId();
            }
        } else if (Log.ifp(5)) {
            string = string + "[ " + this.internalMsg + " ]";
        }
        return string;
    }

    public rice.p2p.commonapi.Id getDestinationId() {
        return this.getTarget();
    }

    public rice.p2p.commonapi.NodeHandle getNextHopHandle() {
        return this.nextHop;
    }

    public Message getMessage() {
        return ((PastryEndpointMessage)this.unwrap()).getMessage();
    }

    public void setDestinationId(rice.p2p.commonapi.Id id) {
        this.target = (Id)id;
    }

    public void setNextHopHandle(rice.p2p.commonapi.NodeHandle nodeHandle) {
        nodeHandle = (NodeHandle)nodeHandle;
    }

    public void setMessage(Message message) {
        ((PastryEndpointMessage)this.unwrap()).setMessage(message);
    }
}

