/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import rice.p2p.commonapi.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSetI;
import rice.pastry.NodeSetUpdate;

public class RouteSet
extends Observable
implements NodeSetI,
Serializable,
Observer {
    private NodeHandle[] nodes;
    private int theSize;
    private int closest;

    public RouteSet(int n) {
        this.nodes = new NodeHandle[n];
        this.theSize = 0;
        this.closest = -1;
    }

    public boolean put(NodeHandle nodeHandle) {
        int n = -1;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.theSize; ++i) {
            if (this.nodes[i].getNodeId().equals(nodeHandle.getNodeId())) {
                return false;
            }
            int n3 = this.nodes[i].proximity();
            if (n3 < n2) continue;
            n2 = n3;
            n = i;
        }
        if (this.theSize < this.nodes.length) {
            this.nodes[this.theSize++] = nodeHandle;
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(nodeHandle, true));
            nodeHandle.ping();
            return true;
        }
        if (nodeHandle.proximity() == Integer.MAX_VALUE) {
            nodeHandle.ping();
            nodeHandle.addObserver(this);
            return false;
        }
        if (nodeHandle.proximity() < n2) {
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(this.nodes[n], false));
            this.nodes[n].deleteObserver(this);
            this.nodes[n] = nodeHandle;
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(nodeHandle, true));
            return true;
        }
        return false;
    }

    public void update(Observable observable, Object object) {
        if ((Integer)object == NodeHandle.PROXIMITY_CHANGED) {
            this.put((NodeHandle)observable);
            observable.deleteObserver(this);
        }
        if ((Integer)object == NodeHandle.DECLARED_DEAD) {
            System.out.println("Routeset:update(), removing dead node");
            this.remove(((NodeHandle)observable).getNodeId());
        }
    }

    public NodeHandle remove(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            NodeHandle nodeHandle = this.nodes[i];
            this.nodes[i] = this.nodes[--this.theSize];
            this.setChanged();
            this.notifyObservers(new NodeSetUpdate(nodeHandle, false));
            nodeHandle.deleteObserver(this);
            return nodeHandle;
        }
        return null;
    }

    public boolean member(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.theSize;
    }

    public void pingAllNew() {
        for (int i = 0; i < this.theSize; ++i) {
            if (this.nodes[i].proximity() != Integer.MAX_VALUE) continue;
            this.nodes[i].ping();
        }
    }

    public NodeHandle closestNode() {
        int n = Integer.MAX_VALUE;
        NodeHandle nodeHandle = null;
        for (int i = 0; i < this.theSize; ++i) {
            int n2;
            if (!this.nodes[i].isAlive() || (n2 = this.nodes[i].proximity()) > n) continue;
            n = n2;
            nodeHandle = this.nodes[i];
            this.closest = i;
        }
        if (nodeHandle != null && n == Integer.MAX_VALUE) {
            nodeHandle.ping();
        }
        return nodeHandle;
    }

    public NodeHandle get(int n) {
        if (n < 0 || n >= this.theSize) {
            throw new NoSuchElementException();
        }
        return this.nodes[n];
    }

    public NodeHandle get(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public int getIndex(NodeId nodeId) {
        for (int i = 0; i < this.theSize; ++i) {
            if (!this.nodes[i].getNodeId().equals(nodeId)) continue;
            return i;
        }
        return -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.nodes = (NodeHandle[])objectInputStream.readObject();
        this.theSize = objectInputStream.readInt();
        this.closest = objectInputStream.readInt();
        if (this.closest != -1) {
            this.nodes[this.closest].ping();
        }
        this.closest = -1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.closest == -1) {
            this.closestNode();
        }
        objectOutputStream.writeObject(this.nodes);
        objectOutputStream.writeInt(this.theSize);
        objectOutputStream.writeInt(this.closest);
    }

    public boolean putHandle(rice.p2p.commonapi.NodeHandle nodeHandle) {
        return this.put((NodeHandle)nodeHandle);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(Id id) {
        return this.getHandle((NodeId)id);
    }

    public rice.p2p.commonapi.NodeHandle getHandle(int n) {
        return this.get(n);
    }

    public boolean memberHandle(Id id) {
        return this.member((NodeId)id);
    }

    public rice.p2p.commonapi.NodeHandle removeHandle(Id id) {
        return this.remove((NodeId)id);
    }

    public int getIndexHandle(Id id) throws NoSuchElementException {
        return this.getIndex((NodeId)id);
    }
}

