/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.routing;

import java.util.Observable;
import java.util.Observer;
import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSet;
import rice.pastry.routing.RouteSet;

public class RoutingTable
extends Observable
implements Observer {
    public static int idBaseBitLength = 4;
    private NodeId myNodeId;
    public NodeHandle myNodeHandle;
    private RouteSet[][] routingTable;
    private int maxEntries;

    public RoutingTable(NodeHandle nodeHandle, int n) {
        this.myNodeId = nodeHandle.getNodeId();
        this.myNodeHandle = nodeHandle;
        this.maxEntries = n;
        int n2 = 1 << idBaseBitLength;
        int n3 = 160 / idBaseBitLength;
        this.routingTable = new RouteSet[n3][n2];
        for (int i = 0; i < n3; ++i) {
            int n4 = this.myNodeId.getDigit(i, idBaseBitLength);
            this.routingTable[i][n4] = new RouteSet(this.maxEntries);
            this.routingTable[i][n4].put(this.myNodeHandle);
            this.routingTable[i][n4].addObserver(this);
        }
    }

    public int numColumns() {
        return this.routingTable[0].length;
    }

    public int numRows() {
        return this.routingTable.length;
    }

    public static int baseBitLength() {
        return idBaseBitLength;
    }

    public NodeHandle bestAlternateRoute(Id id) {
        int n = 1 << idBaseBitLength;
        int n2 = this.myNodeId.indexOfMSDD(id, idBaseBitLength);
        if (n2 < 0) {
            return null;
        }
        int n3 = id.getDigit(n2, idBaseBitLength);
        int n4 = this.myNodeId.getDigit(n2, idBaseBitLength);
        Id.Distance distance = this.myNodeId.distance(id);
        NodeHandle nodeHandle = null;
        boolean bl = false;
        int n5 = 1;
        while (!bl) {
            for (int i = 0; i < 2; ++i) {
                int n6 = i == 0 ? n3 + n5 & n - 1 : n3 + n - n5 & n - 1;
                RouteSet routeSet = this.getRouteSet(n2, n6);
                for (int j = 0; routeSet != null && j < routeSet.size(); ++j) {
                    Id.Distance distance2;
                    NodeHandle nodeHandle2 = routeSet.get(j);
                    if (!nodeHandle2.isAlive() || distance.compareTo(distance2 = nodeHandle2.getNodeId().distance(id)) <= 0) continue;
                    distance = distance2;
                    nodeHandle = nodeHandle2;
                }
                if (n6 != n4) continue;
                bl = true;
            }
            ++n5;
        }
        return nodeHandle;
    }

    public NodeSet alternateRoutes(Id id, int n) {
        NodeSet nodeSet = new NodeSet();
        int n2 = 1 << idBaseBitLength;
        int n3 = this.myNodeId.indexOfMSDD(id, idBaseBitLength);
        if (n3 < 0) {
            return nodeSet;
        }
        int n4 = id.getDigit(n3, idBaseBitLength);
        int n5 = this.myNodeId.getDigit(n3, idBaseBitLength);
        Id.Distance distance = this.myNodeId.distance(id);
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        while (!bl) {
            for (int i = 0; i < 2; ++i) {
                int n8 = i == 0 ? n4 + n7 & n2 - 1 : n4 + n2 - n7 & n2 - 1;
                RouteSet routeSet = this.getRouteSet(n3, n8);
                for (int j = 0; routeSet != null && j < routeSet.size(); ++j) {
                    NodeHandle nodeHandle = routeSet.get(j);
                    if (!nodeHandle.isAlive()) continue;
                    Id.Distance distance2 = nodeHandle.getNodeId().distance(id);
                    if (nodeSet == null || n6 >= n || distance.compareTo(distance2) <= 0) continue;
                    nodeSet.put(nodeHandle);
                    ++n6;
                }
                if (n8 != n5) continue;
                bl = true;
            }
            ++n7;
        }
        return nodeSet;
    }

    public RouteSet getRouteSet(int n, int n2) {
        RouteSet routeSet = this.routingTable[n][n2];
        return routeSet;
    }

    public RouteSet getBestEntry(Id id) {
        int n = this.myNodeId.indexOfMSDD(id, idBaseBitLength);
        if (n < 0) {
            return null;
        }
        int n2 = id.getDigit(n, idBaseBitLength);
        return this.routingTable[n][n2];
    }

    private RouteSet makeBestEntry(Id id) {
        int n = this.myNodeId.indexOfMSDD(id, idBaseBitLength);
        if (n < 0) {
            return null;
        }
        int n2 = id.getDigit(n, idBaseBitLength);
        if (this.routingTable[n][n2] == null) {
            this.routingTable[n][n2] = new RouteSet(this.maxEntries);
            this.routingTable[n][n2].addObserver(this);
        }
        return this.routingTable[n][n2];
    }

    public void put(NodeHandle nodeHandle) {
        NodeId nodeId = nodeHandle.getNodeId();
        RouteSet routeSet = this.makeBestEntry(nodeId);
        if (routeSet != null) {
            routeSet.put(nodeHandle);
        }
    }

    public NodeHandle get(NodeId nodeId) {
        RouteSet routeSet = this.getBestEntry(nodeId);
        if (routeSet == null) {
            return null;
        }
        return routeSet.get(nodeId);
    }

    public RouteSet[] getRow(int n) {
        return this.routingTable[n];
    }

    public NodeHandle remove(NodeId nodeId) {
        RouteSet routeSet = this.getBestEntry(nodeId);
        if (routeSet == null) {
            return null;
        }
        return routeSet.remove(nodeId);
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public String toString() {
        String string = "routing table: \n";
        for (int i = this.routingTable.length - 1; i >= 0; --i) {
            for (int j = 0; j < this.routingTable[i].length; ++j) {
                string = this.routingTable[i][j] != null ? string + "" + this.routingTable[i][j].size() + "\t" : string + "0\t";
            }
            string = string + "\n";
        }
        return string;
    }
}

