/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastrySeed;

public class IPNodeIdFactory
implements NodeIdFactory {
    private static int nextInstance = 0;
    private InetAddress localIP;
    private int port;
    private Random rng;

    public IPNodeIdFactory(int n) {
        this.port = n;
        try {
            this.localIP = InetAddress.getLocalHost();
            if (this.localIP.isLoopbackAddress()) {
                throw new Exception("got loopback address: nodeIds will not be unique across computers!");
            }
        }
        catch (Exception exception) {
            System.out.println("ALERT: IPNodeIdFactory cannot determine local IP address: " + exception);
        }
        this.rng = new Random(PastrySeed.getSeed());
    }

    public NodeId generateNodeId() {
        byte[] byArray = this.localIP.getAddress();
        byte[] byArray2 = new byte[2];
        int n = this.port;
        for (int i = 0; i < 2; ++i) {
            byArray2[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        byte[] byArray3 = new byte[4];
        n = ++nextInstance;
        for (int i = 0; i < 4; ++i) {
            byArray3[i] = (byte)(n & 0xFF);
            n >>= 8;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("No SHA support!");
        }
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        messageDigest.update(byArray3);
        byte[] byArray4 = messageDigest.digest();
        byte[] byArray5 = new byte[4];
        this.rng.nextBytes(byArray5);
        for (int i = 0; i < 4; ++i) {
            byArray4[i] = byArray5[i];
        }
        NodeId nodeId = new NodeId(byArray4);
        return nodeId;
    }
}

