/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastrySeed;

public class RandomNodeIdFactory
implements NodeIdFactory {
    private Random rng = new Random(PastrySeed.getSeed());
    private long next = this.rng.nextLong();

    public void setSeed(int n) {
        this.rng = new Random(n);
        this.next = this.rng.nextLong();
    }

    public NodeId generateNodeId() {
        byte[] byArray = new byte[8];
        long l = ++this.next;
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            System.err.println("No SHA support!");
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        NodeId nodeId = new NodeId(byArray2);
        return nodeId;
    }
}

