/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.join.InitiateJoin;
import rice.pastry.join.JoinAddress;
import rice.pastry.join.JoinRequest;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.Credentials;
import rice.pastry.security.PastrySecurityManager;
import rice.pastry.security.PermissiveCredentials;

public class StandardJoinProtocol
implements MessageReceiver {
    private PastryNode localNode;
    private NodeHandle localHandle;
    private PastrySecurityManager security;
    private RoutingTable routeTable;
    private LeafSet leafSet;
    private Address address;

    public StandardJoinProtocol(PastryNode pastryNode, NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, RoutingTable routingTable, LeafSet leafSet) {
        this.localNode = pastryNode;
        this.localHandle = nodeHandle;
        this.security = pastrySecurityManager;
        this.address = new JoinAddress();
        this.routeTable = routingTable;
        this.leafSet = leafSet;
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message message) {
        if (message instanceof JoinRequest) {
            JoinRequest joinRequest = (JoinRequest)message;
            NodeHandle nodeHandle = joinRequest.getHandle();
            if ((nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) {
                if (!joinRequest.accepted()) {
                    joinRequest.acceptJoin(this.localHandle, this.leafSet);
                    nodeHandle.receiveMessage(joinRequest);
                } else {
                    NodeHandle nodeHandle2 = joinRequest.getJoinHandle();
                    if ((nodeHandle2 = this.security.verifyNodeHandle(nodeHandle2)).getNodeId().equals(this.localHandle.getNodeId()) && !this.localNode.isReady()) {
                        System.out.println("NodeId collision, unable to join: " + this.localHandle.getNodeId());
                    } else if (nodeHandle2.isAlive()) {
                        this.routeTable.put(nodeHandle2);
                        this.broadcastRows(joinRequest);
                        BroadcastLeafSet broadcastLeafSet = new BroadcastLeafSet(nodeHandle2, joinRequest.getLeafSet(), 1);
                        this.localHandle.receiveMessage(broadcastLeafSet);
                    }
                }
            }
        } else if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            JoinRequest joinRequest = (JoinRequest)routeMessage.unwrap();
            NodeId nodeId = this.localHandle.getNodeId();
            NodeHandle nodeHandle = joinRequest.getHandle();
            NodeId nodeId2 = nodeHandle.getNodeId();
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            int n = RoutingTable.baseBitLength();
            int n2 = nodeId.indexOfMSDD(nodeId2, n);
            int n3 = joinRequest.lastRow();
            for (int i = n3 - 1; n2 > 0 && i >= n2; --i) {
                RouteSet[] routeSetArray = this.routeTable.getRow(i);
                joinRequest.pushRow(routeSetArray);
            }
            routeMessage.routeMessage(nodeId);
        } else if (message instanceof InitiateJoin) {
            InitiateJoin initiateJoin = (InitiateJoin)message;
            NodeHandle nodeHandle = initiateJoin.getHandle();
            if ((nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) {
                JoinRequest joinRequest = new JoinRequest(this.localHandle);
                RouteMessage routeMessage = new RouteMessage((Id)this.localHandle.getNodeId(), (Message)joinRequest, (Credentials)new PermissiveCredentials(), this.address);
                nodeHandle.receiveMessage(routeMessage);
            }
        }
    }

    public void broadcastRows(JoinRequest joinRequest) {
        BroadcastRouteRow broadcastRouteRow;
        RouteSet[] routeSetArray;
        int n;
        int n2 = joinRequest.numRows();
        for (n = joinRequest.lastRow(); n < n2; ++n) {
            routeSetArray = joinRequest.getRow(n);
            if (routeSetArray == null) continue;
            broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            this.localHandle.receiveMessage(broadcastRouteRow);
        }
        for (n = joinRequest.lastRow(); n < n2; ++n) {
            routeSetArray = joinRequest.getRow(n);
            broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            for (int i = 0; i < routeSetArray.length; ++i) {
                RouteSet routeSet = routeSetArray[i];
                if (routeSet == null) continue;
                NodeHandle nodeHandle = routeSet.closestNode();
                if (nodeHandle != null) {
                    nodeHandle = this.security.verifyNodeHandle(nodeHandle);
                }
                if (nodeHandle == null) continue;
                nodeHandle.receiveMessage(broadcastRouteRow);
            }
        }
    }
}

