/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.util.HashSet;
import java.util.Iterator;
import rice.pastry.IdSet;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.leafset.BroadcastLeafSet;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.leafset.LeafSetProtocolAddress;
import rice.pastry.leafset.RequestLeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardLeafSetProtocol
implements MessageReceiver {
    private final boolean failstop = true;
    private NodeHandle localHandle;
    private PastryNode localNode;
    private PastrySecurityManager security;
    private LeafSet leafSet;
    private RoutingTable routeTable;
    private Address address;

    public StandardLeafSetProtocol(PastryNode pastryNode, NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, LeafSet leafSet, RoutingTable routingTable) {
        this.localNode = pastryNode;
        this.localHandle = nodeHandle;
        this.security = pastrySecurityManager;
        this.leafSet = leafSet;
        this.routeTable = routingTable;
        this.address = new LeafSetProtocolAddress();
    }

    public Address getAddress() {
        return this.address;
    }

    public void receiveMessage(Message message) {
        if (message instanceof BroadcastLeafSet) {
            BroadcastLeafSet broadcastLeafSet = (BroadcastLeafSet)message;
            int n = broadcastLeafSet.type();
            NodeHandle nodeHandle = broadcastLeafSet.from();
            LeafSet leafSet = broadcastLeafSet.leafSet();
            boolean bl = this.mergeLeafSet(leafSet, nodeHandle);
            if (n == 1) {
                this.localNode.setReady();
            }
            if (n == 1) {
                this.broadcast();
            }
            if (n == 3 && bl) {
                this.broadcast();
            }
            this.checkLeafSet(leafSet, nodeHandle, true);
        } else if (message instanceof RequestLeafSet) {
            RequestLeafSet requestLeafSet = (RequestLeafSet)message;
            NodeHandle nodeHandle = requestLeafSet.returnHandle();
            if ((nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) {
                BroadcastLeafSet broadcastLeafSet = new BroadcastLeafSet(this.localHandle, this.leafSet, 0);
                nodeHandle.receiveMessage(broadcastLeafSet);
            }
        } else if (message instanceof InitiateLeafSetMaintenance) {
            this.maintainLeafSet();
        } else {
            throw new Error("message received is of unknown type");
        }
    }

    protected boolean checkLeafSet(LeafSet leafSet, NodeHandle nodeHandle, boolean bl) {
        HashSet hashSet = bl ? new HashSet(this.leafSet.maxSize() * 2) : null;
        BroadcastLeafSet broadcastLeafSet = new BroadcastLeafSet(this.localHandle, this.leafSet, 3);
        boolean bl2 = leafSet.merge(this.leafSet, this.localHandle, null, this.security, true, hashSet);
        if (bl2) {
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            nodeHandle.receiveMessage(broadcastLeafSet);
            if (bl) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    NodeHandle nodeHandle2 = (NodeHandle)iterator.next();
                    nodeHandle2.receiveMessage(broadcastLeafSet);
                }
            }
        }
        return bl2;
    }

    protected boolean mergeLeafSet(LeafSet leafSet, NodeHandle nodeHandle) {
        return this.leafSet.merge(leafSet, nodeHandle, this.routeTable, this.security, false, null);
    }

    protected void broadcast() {
        this.broadcast(2);
    }

    protected void broadcast(int n) {
        BroadcastLeafSet broadcastLeafSet = new BroadcastLeafSet(this.localHandle, this.leafSet, n);
        int n2 = this.leafSet.cwSize();
        int n3 = this.leafSet.ccwSize();
        IdSet idSet = new IdSet();
        for (int i = -n3; i <= n2; ++i) {
            NodeHandle nodeHandle;
            if (i == 0 || (nodeHandle = this.leafSet.get(i)) == null || !nodeHandle.isAlive() || idSet.isMember(nodeHandle.getNodeId())) continue;
            nodeHandle.receiveMessage(broadcastLeafSet);
            idSet.addMember(nodeHandle.getNodeId());
        }
    }

    protected void broadcast(LeafSet leafSet, NodeHandle nodeHandle) {
        BroadcastLeafSet broadcastLeafSet = new BroadcastLeafSet(this.localHandle, this.leafSet, 2);
        int n = leafSet.cwSize();
        int n2 = leafSet.ccwSize();
        for (int i = -n2; i <= n; ++i) {
            NodeHandle nodeHandle2 = i == 0 ? nodeHandle : leafSet.get(i);
            if (nodeHandle2 == null || !nodeHandle2.isAlive()) continue;
            nodeHandle2 = this.security.verifyNodeHandle(nodeHandle2);
            nodeHandle2.receiveMessage(broadcastLeafSet);
        }
    }

    public void maintainLeafSet() {
        NodeHandle nodeHandle;
        int n;
        if (Log.ifp(7)) {
            System.out.println("maintainLeafSet " + this.localHandle.getNodeId());
        }
        boolean bl = false;
        for (n = -this.leafSet.ccwSize(); n < 0; ++n) {
            nodeHandle = this.leafSet.get(n);
            if (nodeHandle == null || nodeHandle.ping()) continue;
            this.leafSet.remove(nodeHandle.getNodeId());
            bl = true;
        }
        for (n = this.leafSet.cwSize(); n > 0; --n) {
            nodeHandle = this.leafSet.get(n);
            if (nodeHandle == null || nodeHandle.ping()) continue;
            this.leafSet.remove(nodeHandle.getNodeId());
            bl = true;
        }
        if (bl || this.leafSet.size() < this.leafSet.maxSize()) {
            this.requestLeafSet();
        }
    }

    private void requestLeafSet() {
        NodeHandle nodeHandle;
        int n;
        RequestLeafSet requestLeafSet = new RequestLeafSet(this.localHandle);
        int n2 = this.leafSet.cwSize();
        int n3 = this.leafSet.ccwSize();
        boolean bl = true;
        for (n = -n3; n < 0; ++n) {
            nodeHandle = this.leafSet.get(n);
            if (nodeHandle == null || !nodeHandle.isAlive()) continue;
            nodeHandle.receiveMessage(requestLeafSet);
            bl = false;
            break;
        }
        if (bl && this.leafSet.size() > 0) {
            System.out.println("Ring failure at" + this.localHandle.getNodeId() + "all ccw leafset entries failed");
        }
        bl = true;
        for (n = n2; n > 0; --n) {
            nodeHandle = this.leafSet.get(n);
            if (nodeHandle == null || !nodeHandle.isAlive()) continue;
            nodeHandle.receiveMessage(requestLeafSet);
            bl = false;
            break;
        }
        if (bl && this.leafSet.size() > 0) {
            System.out.println("Ring failure at" + this.localHandle.getNodeId() + "all cw leafset entries failed");
        }
    }
}

