/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastrySeed;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RequestRouteRow;
import rice.pastry.routing.RouteProtocolAddress;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardRouteSetProtocol
implements Observer,
MessageReceiver {
    private static final int maxTrials = (1 << RoutingTable.baseBitLength()) / 2;
    private NodeHandle localHandle;
    private PastrySecurityManager security;
    private RoutingTable routeTable;
    private Address address;
    private Random rng;

    public StandardRouteSetProtocol(NodeHandle nodeHandle, PastrySecurityManager pastrySecurityManager, RoutingTable routingTable) {
        this.localHandle = nodeHandle;
        this.security = pastrySecurityManager;
        this.routeTable = routingTable;
        this.rng = new Random(PastrySeed.getSeed());
        this.address = new RouteProtocolAddress();
        routingTable.addObserver(this);
    }

    public Address getAddress() {
        return this.address;
    }

    public void update(Observable observable, Object object) {
    }

    public void receiveMessage(Message message) {
        if (message instanceof BroadcastRouteRow) {
            BroadcastRouteRow broadcastRouteRow = (BroadcastRouteRow)message;
            RouteSet[] routeSetArray = broadcastRouteRow.getRow();
            NodeHandle nodeHandle = broadcastRouteRow.from();
            if ((nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) {
                this.routeTable.put(nodeHandle);
            }
            for (int i = 0; i < routeSetArray.length; ++i) {
                RouteSet routeSet = routeSetArray[i];
                for (int j = 0; routeSet != null && j < routeSet.size(); ++j) {
                    nodeHandle = routeSet.get(j);
                    if (!(nodeHandle = this.security.verifyNodeHandle(nodeHandle)).isAlive()) continue;
                    this.routeTable.put(nodeHandle);
                }
            }
        } else if (message instanceof RequestRouteRow) {
            RequestRouteRow requestRouteRow = (RequestRouteRow)message;
            int n = requestRouteRow.getRow();
            NodeHandle nodeHandle = requestRouteRow.returnHandle();
            nodeHandle = this.security.verifyNodeHandle(nodeHandle);
            RouteSet[] routeSetArray = this.routeTable.getRow(n);
            BroadcastRouteRow broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            nodeHandle.receiveMessage(broadcastRouteRow);
        } else if (message instanceof InitiateRouteSetMaintenance) {
            this.maintainRouteSet();
        } else {
            throw new Error("StandardRouteSetProtocol: received message is of unknown type");
        }
    }

    private void maintainRouteSet() {
        int n;
        Serializable serializable;
        RouteSet[] routeSetArray;
        int n2;
        for (n2 = this.routeTable.numRows() - 1; n2 >= 0; --n2) {
            routeSetArray = this.routeTable.getRow(n2);
            for (int i = 0; i < routeSetArray.length; ++i) {
                serializable = routeSetArray[i];
                for (n = 0; serializable != null && n < ((RouteSet)serializable).size(); ++n) {
                    NodeHandle nodeHandle = ((RouteSet)serializable).get(n);
                    if (nodeHandle.isAlive()) continue;
                    ((RouteSet)serializable).remove(nodeHandle.getNodeId());
                }
            }
        }
        if (Log.ifp(7)) {
            System.out.println("maintainRouteSet " + this.localHandle.getNodeId());
        }
        for (n2 = this.routeTable.numRows() - 1; n2 >= 0; --n2) {
            int n3;
            routeSetArray = this.routeTable.getRow(n2);
            BroadcastRouteRow broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            serializable = new RequestRouteRow(this.localHandle, n2);
            n = this.localHandle.getNodeId().getDigit(n2, RoutingTable.baseBitLength());
            for (n3 = 0; n3 < maxTrials; ++n3) {
                NodeHandle nodeHandle;
                RouteSet routeSet;
                int n4 = this.rng.nextInt(this.routeTable.numColumns());
                if (n4 == n || (routeSet = routeSetArray[n4]) == null || (nodeHandle = routeSet.closestNode()) == null) continue;
                nodeHandle.receiveMessage(broadcastRouteRow);
                nodeHandle.receiveMessage((Message)serializable);
                break;
            }
            if (n3 == maxTrials) break;
        }
    }
}

