/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.standard;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.messaging.MessageReceiver;
import rice.pastry.routing.BroadcastRouteRow;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RouterAddress;
import rice.pastry.routing.RoutingTable;
import rice.pastry.security.PastrySecurityManager;

public class StandardRouter
implements MessageReceiver {
    private NodeId localId;
    private NodeHandle localHandle;
    private RoutingTable routeTable;
    private LeafSet leafSet;
    private PastrySecurityManager security;
    private Address routeAddress;

    public StandardRouter(NodeHandle nodeHandle, RoutingTable routingTable, LeafSet leafSet, PastrySecurityManager pastrySecurityManager) {
        this.localHandle = nodeHandle;
        this.localId = nodeHandle.getNodeId();
        this.routeTable = routingTable;
        this.leafSet = leafSet;
        this.security = pastrySecurityManager;
        this.routeAddress = new RouterAddress();
    }

    public Address getAddress() {
        return this.routeAddress;
    }

    public void receiveMessage(Message message) {
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            if (!routeMessage.routeMessage(this.localHandle.getNodeId())) {
                this.receiveRouteMessage(routeMessage);
            }
        } else {
            throw new Error("message " + message + " bounced at StandardRouter");
        }
    }

    public void receiveRouteMessage(RouteMessage routeMessage) {
        Id id = routeMessage.getTarget();
        if (id == null) {
            id = this.localId;
        }
        int n = this.leafSet.cwSize();
        int n2 = this.leafSet.ccwSize();
        int n3 = this.leafSet.mostSimilar(id);
        if (n3 == 0) {
            routeMessage.nextHop = this.localHandle;
        } else if (n3 > 0 && (n3 < n || !this.leafSet.get(n3).getNodeId().clockwise(id)) || n3 < 0 && (-n3 < n2 || this.leafSet.get(n3).getNodeId().clockwise(id))) {
            NodeHandle nodeHandle = this.leafSet.get(n3);
            if (!nodeHandle.isAlive()) {
                this.leafSet.remove(nodeHandle.getNodeId());
                this.receiveRouteMessage(routeMessage);
                return;
            }
            routeMessage.nextHop = nodeHandle;
        } else {
            RouteSet routeSet = this.routeTable.getBestEntry(id);
            NodeHandle nodeHandle = null;
            if (routeSet == null || (nodeHandle = routeSet.closestNode()) == null) {
                nodeHandle = this.routeTable.bestAlternateRoute(id);
                if (nodeHandle == null) {
                    nodeHandle = this.leafSet.get(n3);
                    if (!nodeHandle.isAlive()) {
                        this.leafSet.remove(nodeHandle.getNodeId());
                        this.receiveRouteMessage(routeMessage);
                        return;
                    }
                } else {
                    Id.Distance distance = nodeHandle.getNodeId().distance(id);
                    Id.Distance distance2 = this.leafSet.get(n3).getNodeId().distance(id);
                    if (distance2.compareTo(distance) < 0 && !(nodeHandle = this.leafSet.get(n3)).isAlive()) {
                        this.leafSet.remove(nodeHandle.getNodeId());
                        this.receiveRouteMessage(routeMessage);
                        return;
                    }
                }
            } else {
                this.checkForRouteTableHole(routeMessage, nodeHandle);
            }
            routeMessage.nextHop = nodeHandle;
        }
        routeMessage.setPrevNode(this.localHandle);
        this.localHandle.receiveMessage(routeMessage);
    }

    private void checkForRouteTableHole(RouteMessage routeMessage, NodeHandle nodeHandle) {
        Id id;
        if (routeMessage.getPrevNode() == null) {
            return;
        }
        NodeId nodeId = routeMessage.getPrevNode().getNodeId();
        int n = nodeId.indexOfMSDD(id = routeMessage.getTarget(), RoutingTable.baseBitLength());
        if (n == this.localId.indexOfMSDD(id, RoutingTable.baseBitLength())) {
            RouteSet[] routeSetArray = this.routeTable.getRow(n);
            BroadcastRouteRow broadcastRouteRow = new BroadcastRouteRow(this.localHandle, routeSetArray);
            NodeHandle nodeHandle2 = this.security.verifyNodeHandle(routeMessage.getPrevNode());
            if (nodeHandle2.isAlive()) {
                nodeHandle2.receiveMessage(broadcastRouteRow);
            }
        }
    }
}

