/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.SphereNetwork;
import rice.pastry.standard.RandomNodeIdFactory;

public class ClosestRegrTest {
    public static int NUM_NODES = 1000;
    public static int NUM_TRIALS = 1000;
    private PastryNodeFactory factory;
    private NetworkSimulator simulator;
    private Vector pastryNodes;
    Random random = new Random();
    int incorrect = 0;
    double sum = 0.0;

    private ClosestRegrTest() {
        this.simulator = new SphereNetwork();
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
    }

    protected NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    protected void run() {
        for (int i = 0; i < NUM_NODES; ++i) {
            PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
            if (i > 0) {
                this.test(i, pastryNode.getLocalHandle());
            }
            while (this.simulator.simulate()) {
            }
            System.out.println("CREATED NODE " + i + " " + pastryNode.getNodeId());
            this.pastryNodes.add(pastryNode);
        }
    }

    protected void test(int n, NodeHandle nodeHandle) {
        NodeId nodeId = nodeHandle.getNodeId();
        PastryNode pastryNode = (PastryNode)this.pastryNodes.elementAt(this.random.nextInt(n));
        NodeHandle nodeHandle2 = pastryNode.getLocalHandle();
        NodeHandle nodeHandle3 = this.factory.getNearest(nodeHandle, nodeHandle2);
        DirectNodeHandle directNodeHandle = this.simulator.getClosest(nodeId);
        if (!nodeHandle3.getNodeId().equals(((NodeHandle)directNodeHandle).getNodeId())) {
            ++this.incorrect;
            this.sum += (double)(this.simulator.proximity(nodeHandle3.getNodeId(), nodeId) / this.simulator.proximity(((NodeHandle)directNodeHandle).getNodeId(), nodeId));
            System.out.println("ERROR: CLOSEST TO " + nodeId + " WAS " + nodeHandle3.getNodeId() + " REAL CLOSEST: " + ((NodeHandle)directNodeHandle).getNodeId());
            System.out.println("SO FAR: " + this.incorrect + "/" + n + " PERCENTAGE: " + this.sum / (double)this.incorrect);
        }
    }

    public static void main(String[] stringArray) {
        ClosestRegrTest closestRegrTest = new ClosestRegrTest();
        closestRegrTest.run();
    }
}

