/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.PastrySeed;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.IPNodeIdFactory;
import rice.pastry.testing.HelloWorldApp;

public class DistHelloWorld {
    private PastryNodeFactory factory = DistPastryNodeFactory.getFactory(new IPNodeIdFactory(port), protocol, port);
    private Vector pastryNodes = new Vector();
    private Vector helloClients = new Vector();
    private Random rng = new Random(PastrySeed.getSeed());
    private static int port = 5009;
    private static String bshost = null;
    private static int bsport = 5009;
    private static int numnodes = 5;
    private static int nummsgs = 2;
    public static int protocol = DistPastryNodeFactory.PROTOCOL_RMI;

    protected NodeHandle getBootstrap(boolean bl) {
        InetSocketAddress inetSocketAddress = null;
        if (bl && bshost != null) {
            inetSocketAddress = new InetSocketAddress(bshost, bsport);
        } else {
            try {
                inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost().getHostName(), bsport);
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println(unknownHostException);
            }
        }
        NodeHandle nodeHandle = ((DistPastryNodeFactory)this.factory).getNodeHandle(inetSocketAddress);
        return nodeHandle;
    }

    private static void doIinitstuff(String[] stringArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-help")) continue;
            System.out.println("Usage: DistHelloWorld [-msgs m] [-nodes n] [-port p] [-bootstrap bshost[:bsport]]");
            System.out.println("                     [-protocol (rmi|wire)] [-verbose|-silent|-verbosity v] [-help]");
            System.out.println("");
            System.out.println("  Ports p and bsport refer to RMI registry  or Socket port numbers (default = 5009).");
            System.out.println("  Without -bootstrap bshost[:bsport], only localhost:p is used for bootstrap.");
            System.out.println("  Default verbosity is 5, -verbose is 10, and -silent is -1 (error msgs only).");
            System.exit(1);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-msgs") || n2 + 1 >= stringArray.length) continue;
            nummsgs = Integer.parseInt(stringArray[n2 + 1]);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-port") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            port = n;
            bsport = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-bootstrap") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                bshost = string;
                bsport = port;
                break;
            }
            bshost = string.substring(0, n3);
            bsport = Integer.parseInt(string.substring(n3 + 1));
            if (bsport > 0) break;
            bsport = port;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-nodes") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            numnodes = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-protocol") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            if (string.equalsIgnoreCase("wire")) {
                protocol = DistPastryNodeFactory.PROTOCOL_WIRE;
                break;
            }
            if (string.equalsIgnoreCase("rmi")) {
                protocol = DistPastryNodeFactory.PROTOCOL_RMI;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + string);
            break;
        }
    }

    public PastryNode makePastryNode(boolean bl) {
        NodeHandle nodeHandle = this.getBootstrap(bl);
        PastryNode pastryNode = this.factory.newNode(nodeHandle);
        this.pastryNodes.addElement(pastryNode);
        HelloWorldApp helloWorldApp = new HelloWorldApp(pastryNode);
        this.helloClients.addElement(helloWorldApp);
        if (Log.ifp(5)) {
            System.out.println("created " + pastryNode);
        }
        return pastryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PastryNode pastryNode;
        Log.init(stringArray);
        DistHelloWorld.doIinitstuff(stringArray);
        DistHelloWorld distHelloWorld = new DistHelloWorld();
        PastryNode pastryNode2 = pastryNode = distHelloWorld.makePastryNode(true);
        synchronized (pastryNode2) {
            while (!pastryNode.isReady()) {
                try {
                    pastryNode.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
        }
        for (int i = 1; i < numnodes; ++i) {
            distHelloWorld.makePastryNode(false);
        }
        if (Log.ifp(5)) {
            System.out.println(numnodes + " nodes constructed");
        }
    }
}

