/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.standard.IPNodeIdFactory;
import rice.pastry.testing.PastryRegrTest;
import rice.pastry.testing.RegrTestApp;

public class DistPastryRegrTest
extends PastryRegrTest {
    private static int port = 5009;
    private static String bshost;
    private static int bsport;
    private static int numnodes;
    private static int protocol;
    private InetSocketAddress bsaddress;

    public DistPastryRegrTest() {
        this.pastryNodesSorted = Collections.synchronizedSortedMap(this.pastryNodesSorted);
        this.factory = DistPastryNodeFactory.getFactory(new IPNodeIdFactory(port), protocol, port);
        try {
            this.bsaddress = new InetSocketAddress(bshost, bsport);
        }
        catch (Exception exception) {
            System.out.println("ERROR (init): " + exception);
        }
    }

    protected NodeHandle getBootstrap(boolean bl) {
        if (bl) {
            return ((DistPastryNodeFactory)this.factory).getNodeHandle(this.bsaddress);
        }
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost().getHostName(), port);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println(unknownHostException);
        }
        return ((DistPastryNodeFactory)this.factory).getNodeHandle(inetSocketAddress);
    }

    private static void doInitstuff(String[] stringArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-help")) continue;
            System.out.println("Usage: DistPastryRegrTest [-port p] [-protocol (rmi|wire|socket)] [-nodes n] [-bootstrap host[:port]] [-help]");
            System.exit(1);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-port") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            port = n;
            break;
        }
        bsport = port;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-bootstrap") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                bshost = string;
                bsport = port;
                break;
            }
            bshost = string.substring(0, n3);
            bsport = Integer.parseInt(string.substring(n3 + 1));
            if (bsport > 0) break;
            bsport = port;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-nodes") || n2 + 1 >= stringArray.length) continue;
            n = Integer.parseInt(stringArray[n2 + 1]);
            if (n <= 0) break;
            numnodes = n;
            break;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-protocol") || n2 + 1 >= stringArray.length) continue;
            String string = stringArray[n2 + 1];
            if (string.equalsIgnoreCase("wire")) {
                protocol = DistPastryNodeFactory.PROTOCOL_WIRE;
                break;
            }
            if (string.equalsIgnoreCase("rmi")) {
                protocol = DistPastryNodeFactory.PROTOCOL_RMI;
                break;
            }
            if (string.equalsIgnoreCase("socket")) {
                protocol = DistPastryNodeFactory.PROTOCOL_SOCKET;
                break;
            }
            System.out.println("ERROR: Unsupported protocol: " + string);
            break;
        }
    }

    protected void registerapp(PastryNode pastryNode, RegrTestApp regrTestApp) {
    }

    public boolean simulate() {
        return false;
    }

    public synchronized void pause(int n) {
        System.out.println("Waiting " + n + "ms...");
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isReallyAlive(NodeId nodeId) {
        return false;
    }

    protected void killNode(PastryNode pastryNode) {
        ((DistPastryNode)pastryNode).kill();
    }

    public static void main(String[] stringArray) {
        DistPastryRegrTest.doInitstuff(stringArray);
        DistPastryRegrTest distPastryRegrTest = new DistPastryRegrTest();
        DistPastryRegrTest.mainfunc(distPastryRegrTest, stringArray, numnodes, 1, 1, 20, 4);
    }

    static {
        bsport = 5009;
        numnodes = 10;
        protocol = DistPastryNodeFactory.PROTOCOL_RMI;
        try {
            bshost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Error determining local host: " + unknownHostException);
        }
    }
}

