/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.HelloWorldApp;

public class HelloWorld {
    private PastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private Vector pastryNodes;
    private Vector helloClients;
    private Random rng;
    private static int numnodes = 3;
    private static int nummsgs = 3;
    private static boolean simultaneous_joins = false;
    private static boolean simultaneous_msgs = false;

    public HelloWorld() {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
        this.helloClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    public void makePastryNode() {
        PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pastryNode);
        HelloWorldApp helloWorldApp = new HelloWorldApp(pastryNode);
        this.helloClients.addElement(helloWorldApp);
        if (Log.ifp(5)) {
            System.out.println("created " + pastryNode);
        }
    }

    private void printLeafSets() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(i);
            if (!Log.ifp(5)) continue;
            System.out.println(pastryNode.getLeafSet());
        }
    }

    private void sendRandomMessage() {
        int n = this.helloClients.size();
        int n2 = this.rng.nextInt(n);
        HelloWorldApp helloWorldApp = (HelloWorldApp)this.helloClients.get(n2);
        helloWorldApp.sendRndMsg(this.rng);
    }

    private boolean simulate() {
        return this.simulator.simulate();
    }

    public static void main(String[] stringArray) {
        int n;
        Log.init(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nodes") && i + 1 < stringArray.length) {
                numnodes = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-msgs") && i + 1 < stringArray.length) {
                nummsgs = Integer.parseInt(stringArray[i + 1]);
            }
            if (stringArray[i].equals("-simultaneous_joins")) {
                simultaneous_joins = true;
            }
            if (stringArray[i].equals("-simultaneous_msgs")) {
                simultaneous_msgs = true;
            }
            if (!stringArray[i].equals("-help")) continue;
            System.out.println("Usage: HelloWorld [-msgs m] [-nodes n] [-verbose|-silent|-verbosity v]");
            System.out.println("                  [-simultaneous_joins] [-simultaneous_msgs] [-help]");
            System.exit(1);
        }
        HelloWorld helloWorld = new HelloWorld();
        for (n = 0; n < numnodes; ++n) {
            helloWorld.makePastryNode();
            if (simultaneous_joins) continue;
            while (helloWorld.simulate()) {
            }
        }
        if (simultaneous_joins) {
            if (Log.ifp(5)) {
                System.out.println("let the joins begin!");
            }
            while (helloWorld.simulate()) {
            }
        }
        if (Log.ifp(5)) {
            System.out.println(numnodes + " nodes constructed");
        }
        helloWorld.printLeafSets();
        for (n = 0; n < nummsgs; ++n) {
            helloWorld.sendRandomMessage();
            if (simultaneous_msgs) continue;
            while (helloWorld.simulate()) {
            }
        }
        if (simultaneous_msgs) {
            if (Log.ifp(5)) {
                System.out.println("let the msgs begin!");
            }
            while (helloWorld.simulate()) {
            }
        }
    }
}

