/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Random;
import rice.pastry.Id;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.HelloMsg;

public class HelloWorldApp
extends PastryAppl {
    private int msgid = 0;
    private static Address addr = new HelloAddress();
    private static Credentials cred = new PermissiveCredentials();

    public HelloWorldApp(PastryNode pastryNode) {
        super(pastryNode);
    }

    public void sendRndMsg(Random random) {
        Id id = Id.makeRandomId(random);
        if (Log.ifp(5)) {
            System.out.println("Sending message from " + this.getNodeId() + " to random dest " + id);
        }
        HelloMsg helloMsg = new HelloMsg(addr, this.getNodeId(), id, ++this.msgid);
        this.routeMsg(id, helloMsg, cred, new SendOptions());
    }

    public Address getAddress() {
        return addr;
    }

    public Credentials getCredentials() {
        return cred;
    }

    public void messageForAppl(Message message) {
        if (Log.ifp(5)) {
            System.out.println("Received " + message + " at " + this.getNodeId());
        }
    }

    public boolean enrouteMessage(Message message, Id id, NodeId nodeId, SendOptions sendOptions) {
        if (Log.ifp(5)) {
            System.out.println("Enroute " + message + " at " + this.getNodeId());
        }
        return true;
    }

    public void leafSetChange(NodeHandle nodeHandle, boolean bl) {
        if (Log.ifp(5)) {
            System.out.print("In " + this.getNodeId() + "'s leaf set, " + "node " + nodeHandle.getNodeId() + " was ");
            if (bl) {
                System.out.println("added");
            } else {
                System.out.println("removed");
            }
        }
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
        if (Log.ifp(5)) {
            System.out.print("In " + this.getNodeId() + "'s route set, " + "node " + nodeHandle.getNodeId() + " was ");
            if (bl) {
                System.out.println("added");
            } else {
                System.out.println("removed");
            }
        }
    }

    public void notifyReady() {
        System.out.println("Node " + this.getNodeId() + " ready, waking up any clients");
        this.sendRndMsg(new Random());
    }

    private static class HelloAddress
    implements Address {
        private int myCode = 428125133;

        private HelloAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object object) {
            return object instanceof HelloAddress;
        }

        public String toString() {
            return "[HelloAddress]";
        }
    }
}

