/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Random;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.PastrySeed;

public class IdRangeUnit {
    private Random rng = new Random(PastrySeed.getSeed());

    public IdRange createRandomIdRange() {
        IdRange idRange = new IdRange(Id.makeRandomId(this.rng), Id.makeRandomId(this.rng));
        return idRange;
    }

    public IdRange createFullIdRange() {
        Id id = Id.makeRandomId(this.rng);
        IdRange idRange = new IdRange(id, id);
        return idRange;
    }

    public IdRange createEmptyIdRange() {
        IdRange idRange = new IdRange();
        return idRange;
    }

    public IdRange createIdRangeStartingWith(Id id) {
        IdRange idRange = new IdRange(id, Id.makeRandomId(this.rng));
        return idRange;
    }

    public IdRange createIdRangeEndingIn(Id id) {
        IdRange idRange = new IdRange(Id.makeRandomId(this.rng), id);
        return idRange;
    }

    public Id createIdWithPrefix(byte by) {
        byte[] byArray = new byte[20];
        byArray[byArray.length - 1] = by;
        return new Id(byArray);
    }

    public void equalityTest(IdRange idRange, IdRange idRange2) {
        IdRange idRange3;
        IdRange idRange4;
        if (idRange.equals(idRange2) && !idRange.isEmpty() && !idRange.isFull()) {
            System.out.println("ALERT: equality failed with high probability" + idRange + idRange2);
        }
        if (!idRange.equals(idRange)) {
            System.out.println("ALERT: equality is not reflexive." + idRange);
        }
        IdRange idRange5 = new IdRange(idRange2.getCCW(), idRange2.getCW());
        IdRange idRange6 = new IdRange(idRange5);
        if (!idRange5.equals(idRange2) && !idRange2.isEmpty() || !idRange5.equals(idRange6)) {
            System.out.println("ALERT: equality failed." + idRange2 + idRange5 + idRange6);
        }
        if ((idRange4 = new IdRange()).equals(idRange3 = new IdRange(idRange.getCCW(), idRange.getCCW()))) {
            System.out.println("ALERT: equality failed" + idRange4 + idRange4);
        }
        if (!idRange4.isEmpty() || idRange3.isEmpty()) {
            System.out.println("ALERT: isEmpty failed" + idRange4 + idRange3);
        }
    }

    public void mergeIntersectTest(IdRange idRange, IdRange idRange2) {
        IdRange idRange3 = idRange.merge(idRange2);
        IdRange idRange4 = idRange2.merge(idRange);
        IdRange idRange5 = idRange.intersect(idRange2);
        if (!(idRange3.equals(idRange4) || idRange5.isEmpty() && !idRange.isAdjacent(idRange2) || idRange.isEmpty())) {
            System.out.println("ALERT: merge is not symmetric 1" + idRange + idRange2 + idRange3 + idRange4);
        }
        boolean bl = !idRange5.isEmpty();
        boolean bl2 = idRange.isAdjacent(idRange2);
        boolean bl3 = bl || bl2;
        IdRange idRange6 = idRange2.intersect(idRange);
        if (idRange5.isEmpty() != idRange6.isEmpty()) {
            System.out.println("ALERT: intersect error 1." + idRange5 + idRange6);
        }
        if (bl3) {
            if (idRange3.equals(idRange) && !idRange5.isEmpty() && !idRange5.equals(idRange2)) {
                System.out.println("ALERT: merge is not symmetric 2" + idRange + idRange2 + idRange3 + idRange5);
            }
            if (idRange3.equals(idRange2) && !idRange5.isEmpty() && !idRange5.equals(idRange)) {
                System.out.println("ALERT: merge is not symmetric 3" + idRange + idRange2 + idRange3 + idRange5);
            }
            IdRange idRange7 = idRange3.intersect(idRange);
            IdRange idRange8 = idRange3.intersect(idRange2);
            if (!idRange.equals(idRange7) || !idRange2.equals(idRange8)) {
                System.out.println("ALERT: intersect error 2." + idRange + idRange7 + idRange2 + idRange8 + idRange3);
            }
        } else if (!idRange3.equals(idRange) && !idRange.isEmpty()) {
            System.out.println("ALERT: merge error 0." + idRange + idRange2 + idRange3);
        }
        if ((idRange.isEmpty() || idRange2.isEmpty()) && !idRange5.isEmpty()) {
            System.out.println("ALERT: intersect error 3." + idRange + idRange2 + idRange5);
        }
        if (idRange.isEmpty() && !idRange3.equals(idRange2)) {
            System.out.println("ALERT: merge error 1." + idRange + idRange2 + idRange3);
        }
        if (idRange2.isEmpty() && !idRange3.equals(idRange)) {
            System.out.println("ALERT: merge error 2." + idRange + idRange2 + idRange3);
        }
        if ((idRange.isFull() || idRange2.isFull()) && !idRange3.isFull()) {
            System.out.println("ALERT: merge error 3." + idRange + idRange2 + idRange3);
        }
        if (idRange.isFull() && !idRange5.equals(idRange2)) {
            System.out.println("ALERT: intersect error 4." + idRange + idRange2 + idRange5);
        }
        if (idRange2.isFull() && !idRange5.equals(idRange)) {
            System.out.println("ALERT: intersect error 5." + idRange + idRange2 + idRange3);
        }
    }

    public void diffSubtractTest(IdRange idRange, IdRange idRange2) {
        int n;
        IdRange idRange3 = idRange.diff(idRange2);
        IdRange idRange4 = idRange2.diff(idRange);
        IdRange idRange5 = idRange.intersect(idRange2);
        IdRange idRange6 = idRange2.intersect(idRange);
        if (!(idRange3.intersect(idRange5).isEmpty() && idRange3.intersect(idRange6).isEmpty() && idRange4.intersect(idRange5).isEmpty() && idRange4.intersect(idRange6).isEmpty())) {
            System.out.println("ALERT: diff error 1." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6);
        }
        if (!idRange5.equals(idRange6) && idRange3.equals(idRange4)) {
            System.out.println("ALERT: diff error 15." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6);
        }
        IdRange idRange7 = idRange3;
        IdRange idRange8 = idRange4;
        for (int i = 0; i < 3; ++i) {
            idRange7 = idRange7.merge(idRange3);
            idRange7 = idRange7.merge(idRange5);
            idRange7 = idRange7.merge(idRange4);
            idRange7 = idRange7.merge(idRange6);
            idRange8 = idRange8.merge(idRange3);
            idRange8 = idRange8.merge(idRange5);
            idRange8 = idRange8.merge(idRange4);
            idRange8 = idRange8.merge(idRange6);
        }
        IdRange idRange9 = idRange.merge(idRange2);
        if (!idRange7.equals(idRange) && !idRange7.equals(idRange2) && !idRange7.equals(idRange9) || !idRange8.equals(idRange) && !idRange8.equals(idRange2) && !idRange8.equals(idRange9)) {
            System.out.println("ALERT: diff error 2." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6 + idRange7 + idRange8);
        }
        idRange3 = idRange.subtract(idRange2, false);
        idRange4 = idRange.subtract(idRange2, true);
        if (!(idRange3.intersect(idRange5).isEmpty() && idRange3.intersect(idRange6).isEmpty() && idRange4.intersect(idRange5).isEmpty() && idRange4.intersect(idRange6).isEmpty())) {
            System.out.println("ALERT: subtract error 1." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6);
        }
        if (!idRange3.isEmpty() && idRange3.intersect(idRange).isEmpty() || !idRange4.isEmpty() && idRange4.intersect(idRange).isEmpty()) {
            System.out.println("ALERT: subtract error 2." + idRange + idRange2 + idRange3 + idRange4);
        }
        idRange7 = idRange3;
        idRange8 = idRange4;
        for (n = 0; n < 3; ++n) {
            idRange7 = idRange7.merge(idRange3);
            idRange7 = idRange7.merge(idRange5);
            idRange7 = idRange7.merge(idRange4);
            idRange7 = idRange7.merge(idRange6);
            idRange8 = idRange8.merge(idRange3);
            idRange8 = idRange8.merge(idRange5);
            idRange8 = idRange8.merge(idRange4);
            idRange8 = idRange8.merge(idRange6);
        }
        idRange9 = idRange.merge(idRange2);
        if (!idRange7.equals(idRange) && !idRange8.equals(idRange)) {
            System.out.println("ALERT: subtract error 25." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6 + idRange7 + idRange8);
        }
        idRange3 = idRange2.subtract(idRange, false);
        idRange4 = idRange2.subtract(idRange, true);
        if (!(idRange3.intersect(idRange5).isEmpty() && idRange3.intersect(idRange6).isEmpty() && idRange4.intersect(idRange5).isEmpty() && idRange4.intersect(idRange6).isEmpty())) {
            System.out.println("ALERT: subtract error 3." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6);
        }
        if (!idRange3.isEmpty() && idRange3.intersect(idRange2).isEmpty() || !idRange4.isEmpty() && idRange4.intersect(idRange2).isEmpty()) {
            System.out.println("ALERT: subtract error 4." + idRange + idRange2 + idRange3 + idRange4);
        }
        idRange7 = idRange3;
        idRange8 = idRange4;
        for (n = 0; n < 3; ++n) {
            idRange7 = idRange7.merge(idRange3);
            idRange7 = idRange7.merge(idRange5);
            idRange7 = idRange7.merge(idRange4);
            idRange7 = idRange7.merge(idRange6);
            idRange8 = idRange8.merge(idRange3);
            idRange8 = idRange8.merge(idRange5);
            idRange8 = idRange8.merge(idRange4);
            idRange8 = idRange8.merge(idRange6);
        }
        idRange9 = idRange.merge(idRange2);
        if (!idRange7.equals(idRange2) && !idRange8.equals(idRange2)) {
            System.out.println("ALERT: subtract error 5." + idRange + idRange2 + idRange3 + idRange4 + idRange5 + idRange6 + idRange7 + idRange8);
        }
    }

    public void mergeTest(IdRange idRange, IdRange idRange2) {
        IdRange idRange3;
        IdRange idRange4 = idRange.ccwHalf();
        if (!idRange4.intersect(idRange3 = idRange.cwHalf()).isEmpty()) {
            System.out.println("ALERT: ccw and cw halves intersect." + idRange + idRange4 + idRange3);
        }
        if (!idRange.equals(idRange4.merge(idRange3))) {
            System.out.println("ALERT: merge cw/ccw failure." + idRange + idRange4 + idRange3);
        }
        if (!(idRange4 = idRange2.ccwHalf()).intersect(idRange3 = idRange2.cwHalf()).isEmpty()) {
            System.out.println("ALERT: ccw and cw halves intersect." + idRange2 + idRange4 + idRange3);
        }
        if (!idRange2.equals(idRange4.merge(idRange3))) {
            System.out.println("ALERT: merge cw/ccw failure." + idRange2 + idRange4 + idRange3);
        }
    }

    public IdRangeUnit() {
        System.out.println("IdRangeUnit test starting...");
        for (int i = 0; i < 1000; ++i) {
            IdRange idRange = this.createEmptyIdRange();
            IdRange idRange2 = this.createEmptyIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createFullIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createRandomIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange = this.createFullIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createFullIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createEmptyIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange = this.createRandomIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = idRange.complement();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange = this.createFullIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange = this.createEmptyIdRange();
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeStartingWith(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange2 = this.createIdRangeEndingIn(idRange.getCCW());
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
            idRange = new IdRange(this.createIdWithPrefix((byte)-64), this.createIdWithPrefix((byte)64));
            idRange2 = new IdRange(this.createIdWithPrefix((byte)-32), this.createIdWithPrefix((byte)32));
            this.equalityTest(idRange, idRange2);
            this.mergeIntersectTest(idRange, idRange2);
            this.diffSubtractTest(idRange, idRange2);
            this.mergeTest(idRange, idRange2);
        }
        System.out.println("IdRangeUnit test finished.");
    }

    public static void main(String[] stringArray) {
        IdRangeUnit idRangeUnit = new IdRangeUnit();
    }
}

