/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Arrays;
import java.util.Random;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.standard.RandomNodeIdFactory;

public class LeafSetTest {
    protected NodeIdFactory factory = new RandomNodeIdFactory();
    protected Random random = new Random();

    public void start() {
        this.testCumulativeRange();
        this.testNonCumulativeRange();
    }

    protected final void assertTrue(String string, boolean bl) {
        if (!bl) {
            System.out.println(string + " - failed.");
            System.exit(0);
        }
    }

    protected int min(int n, int n2) {
        if (n2 < n) {
            return n2;
        }
        return n;
    }

    protected int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public void testCumulativeRange() {
        for (int i = 2; i < 20; ++i) {
            for (int j = 2; j < 17; j += 2) {
                LeafSet leafSet = this.generateLeafSet(j, i, false);
                System.out.println("Testing cumulative ranges with " + i + " nodes and leafset size of " + j);
                for (int k = -this.min(j / 2, i / 2); k <= this.min(j / 2, i / 2); ++k) {
                    for (int i2 = 0; i2 < j; ++i2) {
                        IdRange idRange = leafSet.range(leafSet.get(k), i2);
                        if (i2 < j / 2 - this.abs(k) || j + 1 > i) {
                            this.assertTrue("Range of node " + k + " with q " + i2 + " nodes " + i + " size " + j + " should be defined in leafset " + leafSet, idRange != null);
                            if (i2 >= i - 1) {
                                this.assertTrue("Range of node " + k + " with q " + i2 + " nodes " + i + " size " + j + " should be full in leafset " + leafSet, idRange.isFull());
                                continue;
                            }
                            this.assertTrue("Range of node " + k + " with q " + i2 + " nodes " + i + " size " + j + " should be full in leafset " + leafSet, !idRange.isFull());
                            continue;
                        }
                        this.assertTrue("Range of node " + k + " with q " + i2 + " nodes " + i + " size " + j + " should be not defined in leafset " + leafSet, idRange == null);
                    }
                }
            }
        }
    }

    public void testNonCumulativeRange() {
        for (int i = 1; i < 20; ++i) {
            for (int j = 2; j < 17; j += 2) {
                int n;
                LeafSet leafSet = this.generateLeafSet(j, i, false);
                System.out.println("Testing non-cumulative ranges with " + i + " nodes and leafset size of " + j);
                for (int k = -this.min(j / 2, i / 2); k <= this.min(j / 2, i / 2); ++k) {
                    for (n = 0; n < j; ++n) {
                        IdRange idRange = leafSet.range(leafSet.get(k), n, true);
                        if (n < j / 2 - this.abs(k) || j + 1 > i) {
                            this.assertTrue("Range of node " + k + " with q " + n + " nodes " + i + " size " + j + " should not be null in leafset " + leafSet, idRange != null);
                            if (n >= i) {
                                this.assertTrue("Range of node " + k + " with q " + n + " nodes " + i + " size " + j + " should be empty in leafset " + leafSet, idRange.isEmpty());
                                continue;
                            }
                            this.assertTrue("Range of node " + k + " with q " + n + " nodes " + i + " size " + j + " should be defined in leafset " + leafSet, !idRange.isEmpty());
                            continue;
                        }
                        this.assertTrue("Range of node " + k + " with q " + n + " nodes " + i + " size " + j + " should be not defined in leafset " + leafSet, idRange == null);
                    }
                }
                if (j + 1 <= i) continue;
                IdRange idRange = new IdRange();
                for (n = 0; n < j; ++n) {
                    idRange = idRange.merge(leafSet.range(leafSet.get(0), n, true));
                    idRange = idRange.merge(leafSet.range(leafSet.get(0), n, false));
                }
                this.assertTrue("Sum of individual ranges should produce entire range with nodes " + i + " size " + j + " in leafset " + leafSet + " with total " + idRange, idRange.isFull());
            }
        }
    }

    protected LeafSet generateLeafSet(int n, int n2, boolean bl) {
        int n3;
        Object[] objectArray = new NodeHandle[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            objectArray[n3] = new TestNodeHandle(this.factory.generateNodeId());
        }
        Arrays.sort(objectArray);
        n3 = 0;
        n3 = bl ? (n2 - n + this.random.nextInt(n)) % n2 : this.random.nextInt(n2);
        int n4 = (n3 + n / 2) % n2;
        LeafSet leafSet = new LeafSet((NodeHandle)objectArray[n4], n);
        for (int i = 0; i < n2; ++i) {
            leafSet.put((NodeHandle)objectArray[i]);
        }
        return leafSet;
    }

    public static void main(String[] stringArray) {
        LeafSetTest leafSetTest = new LeafSetTest();
        leafSetTest.start();
    }

    public static class TestNodeHandle
    extends NodeHandle
    implements Comparable {
        private NodeId id;

        public TestNodeHandle(NodeId nodeId) {
            this.id = nodeId;
        }

        public NodeId getNodeId() {
            return this.id;
        }

        public boolean isAlive() {
            return true;
        }

        public int proximity() {
            return 1;
        }

        public boolean ping() {
            return true;
        }

        public boolean equals(Object object) {
            if (object instanceof TestNodeHandle) {
                return ((TestNodeHandle)object).id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public void receiveMessage(Message message) {
        }

        public int compareTo(Object object) {
            return this.id.compareTo(((TestNodeHandle)object).id);
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

