/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Random;
import rice.pastry.Id;
import rice.pastry.NodeId;
import rice.pastry.PastrySeed;

public class NodeIdUnit {
    private NodeId nid;
    private Random rng = new Random(PastrySeed.getSeed());

    public NodeId createNodeId() {
        int n;
        byte[] byArray = new byte[20];
        this.rng.nextBytes(byArray);
        NodeId nodeId = new NodeId(byArray);
        System.out.println("created node " + nodeId);
        byte[] byArray2 = new byte[byArray.length];
        nodeId.blit(byArray2);
        for (n = 0; n < byArray.length; ++n) {
            if (byArray2[n] == byArray[n]) continue;
            System.out.println("blit test failed!");
        }
        byArray2 = nodeId.copy();
        for (n = 0; n < byArray.length; ++n) {
            if (byArray2[n] == byArray[n]) continue;
            System.out.println("copy test failed!");
        }
        return nodeId;
    }

    public void equalityTest() {
        System.out.println("--------------------------");
        System.out.println("Creating oth");
        NodeId nodeId = this.createNodeId();
        if (!this.nid.equals(nodeId)) {
            System.out.println("not equal - as expected.");
        } else {
            System.out.println("ALERT: equal - warning this happens with very low probability");
        }
        if (this.nid.equals(this.nid)) {
            System.out.println("equality seems reflexive.");
        } else {
            System.out.println("ALERT: equality is not reflexive.");
        }
        System.out.println("hash code of nid: " + this.nid.hashCode());
        System.out.println("hash code of oth: " + nodeId.hashCode());
        System.out.println("--------------------------");
    }

    public void distanceTest() {
        Comparable comparable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        System.out.println("--------------------------");
        System.out.println("creating a and b respectively");
        NodeId nodeId = this.createNodeId();
        NodeId nodeId2 = this.createNodeId();
        for (int i = 0; i < 100; ++i) {
            object4 = this.nid.distance(nodeId);
            object3 = nodeId.distance(this.nid);
            object2 = this.nid.distance(nodeId2);
            System.out.println("adist =" + object4 + "\n bdist=" + object2);
            if (((Id.Distance)object4).equals(object3)) {
                System.out.println("distance seems reflexive");
            } else {
                System.out.println("ALERT: distance is non-reflexive.");
            }
            if (((Id.Distance)object4).equals(object2)) {
                System.out.println("ALERT: nodes seem at equal distance - very unlikely");
            } else {
                System.out.println("nodes have different distance as expected.");
            }
            System.out.println("result of comparison with a and b " + ((Id.Distance)object4).compareTo(object2));
            System.out.println("result of comparison with a to itself " + ((Id.Distance)object4).compareTo(object3));
            if (nodeId.clockwise(nodeId2)) {
                System.out.println("b is clockwise from a");
            } else {
                System.out.println("b is counter-clockwise from a");
            }
            object = nodeId.distance(nodeId2);
            comparable = nodeId.longDistance(nodeId2);
            if (((Id.Distance)object).compareTo(comparable) != -1) {
                System.out.println("ERROR: abs.compareTo(abl)=" + ((Id.Distance)object).compareTo(comparable));
            }
            System.out.println("abs=" + object);
            ((Id.Distance)object).shift(-1, 1);
            System.out.println("abs.shift(-1)=" + object);
            ((Id.Distance)object).shift(1, 0);
            System.out.println("abs.shift(1)=" + object);
            if (!((Id.Distance)object).equals(nodeId.distance(nodeId2))) {
                System.out.println("SHIFT ERROR!");
            }
            nodeId = this.createNodeId();
            nodeId2 = this.createNodeId();
        }
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        object4 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -128};
        object3 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 127};
        object2 = new byte[]{98, -84, 10, 109, 38, 58, -21, -79, -28, -114, 37, -14, -27, 14, -94, 19};
        object = new byte[]{58, 63, -6, -126, 0, -111, -5, -126, -99, -46, -40, 66, -122, 64, 93, -41};
        nodeId = new NodeId((byte[])object2);
        nodeId2 = new NodeId((byte[])object);
        comparable = new NodeId(byArray);
        NodeId nodeId3 = new NodeId((byte[])object3);
        NodeId nodeId4 = new NodeId((byte[])object4);
        Comparable comparable2 = comparable;
        System.out.println("a=" + nodeId + "b=" + nodeId2 + "c=" + comparable2);
        System.out.println("a.clockwise(b)=" + nodeId.clockwise(nodeId2));
        System.out.println("a.clockwise(a)=" + nodeId.clockwise(nodeId));
        System.out.println("b.clockwise(b)=" + nodeId2.clockwise(nodeId2));
        if (nodeId.clockwise((Id)comparable2)) {
            System.out.println("c is clockwise from a");
        } else {
            System.out.println("c is counter-clockwise from a");
        }
        if (nodeId2.clockwise((Id)comparable2)) {
            System.out.println("c is clockwise from b");
        } else {
            System.out.println("c is counter-clockwise from b");
        }
        System.out.println("a.distance(b)" + nodeId.distance(nodeId2) + "b.distance(a)=" + nodeId2.distance(nodeId));
        System.out.println("a.longDistance(b)" + nodeId.longDistance(nodeId2) + "b.longDistance(a)=" + nodeId2.longDistance(nodeId));
        System.out.println("a.distance(a)" + nodeId.distance(nodeId) + "a.longDistance(a)=" + nodeId.longDistance(nodeId));
        System.out.println("a.isBetween(a,n7f)=" + nodeId.isBetween(nodeId, nodeId3));
        System.out.println("a.isBetween(n0,a)=" + nodeId.isBetween((Id)comparable, nodeId));
        System.out.println("a.isBetween(n0,n7f)=" + nodeId.isBetween((Id)comparable, nodeId3));
        System.out.println("b.isBetween(n0,n80)=" + nodeId2.isBetween((Id)comparable, nodeId4));
        System.out.println("a.isBetween(a,n80)=" + nodeId.isBetween(nodeId, nodeId4));
        System.out.println("b.isBetween(n0,b)=" + nodeId2.isBetween((Id)comparable, nodeId2));
        System.out.println("--------------------------");
    }

    public void baseFiddlingTest() {
        System.out.println("--------------------------");
        String string = "";
        for (int i = 0; i < 160; ++i) {
            string = this.nid.checkBit(i) ? string + "1" : string + "0";
        }
        System.out.println(string);
        String string2 = "";
        for (int i = 0; i < 160; ++i) {
            string2 = string2 + this.nid.getDigit(i, 1);
        }
        System.out.println(string2);
        if (string.equals(string2)) {
            System.out.println("strings the same - as expected");
        } else {
            System.out.println("ALERT: strings differ - this is wrong.");
        }
        System.out.println("--------------------------");
    }

    public void msdTest() {
        System.out.println("--------------------------");
        System.out.println("creating a and b respectively");
        NodeId nodeId = this.createNodeId();
        NodeId nodeId2 = this.createNodeId();
        Id.Distance distance = this.nid.distance(nodeId);
        Id.Distance distance2 = this.nid.distance(nodeId2);
        Id.Distance distance3 = this.nid.longDistance(nodeId);
        Id.Distance distance4 = this.nid.longDistance(nodeId2);
        System.out.println("nid.dist(a)=" + distance);
        System.out.println("nid.longDist(a)=" + distance3);
        System.out.println("nid.dist(b)=" + distance2);
        System.out.println("nid.longDist(b)=" + distance4);
        System.out.println("adist.compareTo(bdist) " + distance.compareTo(distance2));
        System.out.println("aldist.compareTo(bldist) " + distance3.compareTo(distance4));
        System.out.println("msdb a and nid " + this.nid.indexOfMSDB(nodeId));
        System.out.println("msdb b and nid " + this.nid.indexOfMSDB(nodeId2));
        if (this.nid.indexOfMSDB(nodeId) == nodeId.indexOfMSDB(this.nid)) {
            System.out.println("msdb is symmetric");
        } else {
            System.out.println("ALERT: msdb is not symmetric");
        }
        for (int i = 2; i <= 6; ++i) {
            int n = this.nid.indexOfMSDD(nodeId, i);
            System.out.println("msdd a and nid (base " + (1 << i) + ") " + n + " val=" + nodeId.getDigit(n, i) + "," + this.nid.getDigit(n, i));
            n = this.nid.indexOfMSDD(nodeId2, i);
            System.out.println("msdd b and nid (base " + (1 << i) + ") " + n + " val=" + nodeId2.getDigit(n, i) + "," + this.nid.getDigit(n, i));
        }
        System.out.println("--------------------------");
    }

    public void alternateTest() {
        System.out.println("--------------------------");
        System.out.println("nid=" + this.nid);
        for (int i = 2; i < 7; ++i) {
            for (int j = 2; j <= 1 << i; j *= 2) {
                for (int k = 1; k < j; ++k) {
                    System.out.println("alternate (b=" + i + ") " + k + ":" + this.nid.getAlternateId(j, i, k));
                }
            }
        }
        System.out.println("--------------------------");
    }

    public void domainPrefixTest() {
        System.out.println("--------------------------");
        System.out.println("nid=" + this.nid);
        for (int i = 2; i < 7; ++i) {
            for (int j = 160 / i - 1; j >= 0; --j) {
                for (int k = 0; k < 1 << i; ++k) {
                    Id id = this.nid.getDomainPrefix(j, k, 0, i);
                    Id id2 = this.nid.getDomainPrefix(j, k, -1, i);
                    System.out.println("prefixes " + this.nid + id + id2);
                    int n = id.compareTo(id2);
                    boolean bl = id.equals(id2);
                    if (n == 0 != bl) {
                        System.out.println("ERROR, compareTo=" + n + " equal=" + bl);
                    }
                    if (n != 1) continue;
                    System.out.println("ERROR, compareTo=" + n);
                }
            }
        }
        System.out.println("--------------------------");
    }

    public NodeIdUnit() {
        System.out.println("Creating nid");
        this.nid = this.createNodeId();
        this.equalityTest();
        this.distanceTest();
        this.baseFiddlingTest();
        this.msdTest();
        this.alternateTest();
        this.domainPrefixTest();
    }

    public static void main(String[] stringArray) {
        NodeIdUnit nodeIdUnit = new NodeIdUnit();
    }
}

