/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import rice.pastry.Id;
import rice.pastry.IdRange;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeSet;
import rice.pastry.PastryNode;
import rice.pastry.PastryNodeFactory;
import rice.pastry.PastrySeed;
import rice.pastry.leafset.InitiateLeafSetMaintenance;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.Message;
import rice.pastry.routing.InitiateRouteSetMaintenance;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.testing.RegrTestApp;

public abstract class PastryRegrTest {
    protected PastryNodeFactory factory;
    public Vector pastryNodes = new Vector();
    public SortedMap pastryNodesSorted = new TreeMap();
    public Vector pastryNodesLastAdded = new Vector();
    public boolean inConcJoin = false;
    private Vector rtApps = new Vector();
    private Random rng = new Random(PastrySeed.getSeed());
    public Message lastMsg;
    public Id.Distance lastDist;
    public NodeId lastNode;
    int msgCount = 0;

    protected abstract NodeHandle getBootstrap(boolean var1);

    protected abstract void registerapp(PastryNode var1, RegrTestApp var2);

    protected abstract boolean simulate();

    protected abstract boolean isReallyAlive(NodeId var1);

    protected abstract void killNode(PastryNode var1);

    protected PastryRegrTest() {
    }

    private void makePastryNode() {
        NodeHandle nodeHandle = this.getBootstrap(this.pastryNodes.size() == 0);
        PastryNode pastryNode = this.generateNode(nodeHandle);
        this.pastryNodes.addElement(pastryNode);
        this.pastryNodesSorted.put(pastryNode.getNodeId(), pastryNode);
        this.pastryNodesLastAdded.clear();
        this.pastryNodesLastAdded.addElement(pastryNode);
        RegrTestApp regrTestApp = new RegrTestApp(pastryNode, this);
        this.rtApps.addElement(regrTestApp);
        this.registerapp(pastryNode, regrTestApp);
        int n = 0;
        if (nodeHandle != null) {
            while (this.simulate()) {
                ++n;
            }
        }
        this.checkLeafSet(regrTestApp);
        this.checkRoutingTable(regrTestApp);
    }

    protected PastryNode generateNode(NodeHandle nodeHandle) {
        PastryNode pastryNode = this.factory.newNode(nodeHandle);
        return pastryNode;
    }

    private void makePastryNode(int n) {
        int n2;
        PastryNode pastryNode;
        int n3;
        RegrTestApp[] regrTestAppArray = new RegrTestApp[n];
        this.pause(1000);
        this.pastryNodesLastAdded.clear();
        this.inConcJoin = true;
        int n4 = this.pastryNodes.size();
        if (n4 == 0) {
            n = 1;
        }
        for (n3 = 0; n3 < n; ++n3) {
            NodeHandle nodeHandle = this.getBootstrap(n4 == 0);
            pastryNode = this.generateNode(nodeHandle);
            this.pastryNodes.addElement(pastryNode);
            this.pastryNodesSorted.put(pastryNode.getNodeId(), pastryNode);
            this.pastryNodesLastAdded.addElement(pastryNode);
            regrTestAppArray[n3] = new RegrTestApp(pastryNode, this);
            this.rtApps.addElement(regrTestAppArray[n3]);
            this.registerapp(pastryNode, regrTestAppArray[n3]);
            if (nodeHandle == null || n4 != 0) continue;
            while (this.simulate()) {
                ++this.msgCount;
            }
            while (!pastryNode.isReady()) {
                this.pause(500);
            }
        }
        n3 = 0;
        while (this.simulate()) {
            ++n3;
        }
        for (n2 = 0; n2 < this.pastryNodesLastAdded.size(); ++n2) {
            pastryNode = (PastryNode)this.pastryNodesLastAdded.get(n2);
            while (!pastryNode.isReady()) {
                this.pause(500);
            }
        }
        this.pause(2500);
        this.inConcJoin = false;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.println("created " + regrTestAppArray[n2].getNodeId());
            this.checkLeafSet(regrTestAppArray[n2]);
            this.checkRoutingTable(regrTestAppArray[n2]);
        }
        System.out.println("messages: " + n3);
        for (n2 = 0; n2 < this.rtApps.size(); ++n2) {
        }
    }

    public abstract void pause(int var1);

    public void sendPings(int n) {
        int n2 = this.rtApps.size();
        for (int i = 0; i < n; ++i) {
            int n3 = this.rng.nextInt(n2);
            int n4 = this.rng.nextInt(n2);
            byte[] byArray = new byte[20];
            this.rng.nextBytes(byArray);
            NodeId nodeId = new NodeId(byArray);
            RegrTestApp regrTestApp = (RegrTestApp)this.rtApps.get(n3);
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(n4);
            regrTestApp.sendTrace(pastryNode.getNodeId());
            while (this.simulate()) {
            }
            regrTestApp.sendTrace(nodeId);
            while (this.simulate()) {
            }
        }
    }

    private void checkLeafSet(RegrTestApp regrTestApp) {
        Serializable serializable;
        int n;
        Serializable serializable2;
        int n2;
        LeafSet leafSet = regrTestApp.getLeafSet();
        NodeId nodeId = regrTestApp.getNodeId();
        if (leafSet.size() < leafSet.maxSize() && (this.pastryNodesSorted.size() - 1) * 2 != leafSet.size()) {
            System.out.println("checkLeafSet: incorrect size " + regrTestApp.getNodeId() + " ls.size()=" + leafSet.size() + " total nodes=" + this.pastryNodesSorted.size() + "\n" + leafSet);
        }
        for (n2 = -leafSet.ccwSize(); n2 < 0; ++n2) {
            serializable2 = leafSet.get(n2);
            if (!((NodeHandle)serializable2).isAlive()) {
                System.out.println("checkLeafSet: dead node handle " + ((NodeHandle)serializable2).getNodeId() + " in leafset at " + regrTestApp.getNodeId() + "\n" + leafSet);
            }
            if ((n = nodeId.compareTo(serializable = leafSet.get(n2).getNodeId()) > 0 ? this.pastryNodesSorted.subMap(serializable, nodeId).size() : this.pastryNodesSorted.tailMap(serializable).size() + this.pastryNodesSorted.headMap(nodeId).size()) == -n2) continue;
            System.out.println("checkLeafSet: failure at" + regrTestApp.getNodeId() + "i=" + n2 + " inBetween=" + n + "\n" + leafSet);
        }
        for (n2 = 1; n2 <= leafSet.cwSize(); ++n2) {
            serializable2 = leafSet.get(n2);
            if (!((NodeHandle)serializable2).isAlive()) {
                System.out.println("checkLeafSet: dead node handle " + ((NodeHandle)serializable2).getNodeId() + " in leafset at " + regrTestApp.getNodeId() + "\n" + leafSet);
            }
            if ((n = nodeId.compareTo(serializable = leafSet.get(n2).getNodeId()) < 0 ? this.pastryNodesSorted.subMap(nodeId, serializable).size() : this.pastryNodesSorted.tailMap(nodeId).size() + this.pastryNodesSorted.headMap(serializable).size()) == n2) continue;
            System.out.println("checkLeafSet: failure at" + regrTestApp.getNodeId() + "i=" + n2 + " inBetween=" + n + "\n" + leafSet);
        }
        for (n2 = -leafSet.ccwSize(); n2 <= leafSet.cwSize(); ++n2) {
            int n3;
            Id id;
            int n4;
            serializable2 = leafSet.get(n2).getNodeId();
            class DistComp
            implements Comparator {
                NodeId id;

                public DistComp(NodeId nodeId) {
                    this.id = nodeId;
                }

                public int compare(Object object, Object object2) {
                    NodeId nodeId = (NodeId)object;
                    NodeId nodeId2 = (NodeId)object2;
                    return nodeId.distance(this.id).compareTo(nodeId2.distance(this.id));
                }
            }
            serializable = new TreeSet(new DistComp((NodeId)serializable2));
            for (n = -leafSet.ccwSize(); n <= leafSet.cwSize(); ++n) {
                NodeHandle nodeHandle = leafSet.get(n);
                ((TreeSet)serializable).add(nodeHandle.getNodeId());
            }
            n = ((TreeSet)serializable).headSet(leafSet.get(-leafSet.ccwSize()).getNodeId()).size() + 1;
            int n5 = ((TreeSet)serializable).headSet(leafSet.get(leafSet.cwSize()).getNodeId()).size() + 1;
            if (n5 < n) {
                n = n5;
            }
            if (leafSet.overlaps()) {
                n = ((TreeSet)serializable).size();
            }
            NodeSet nodeSet = leafSet.replicaSet((Id)serializable2, n);
            for (n4 = 0; n4 < nodeSet.size(); ++n4) {
                NodeHandle nodeHandle = nodeSet.get(n4);
                id = nodeHandle.getNodeId();
                n3 = ((TreeSet)serializable).subSet(serializable2, id).size();
                if (n3 == n4) continue;
                System.out.println("checkLeafSet: replicaSet failure at" + regrTestApp.getNodeId() + " i=" + n4 + " k=" + n2 + " inBetween=" + n3 + "\n" + nodeSet + "\n" + leafSet);
            }
            if (nodeSet.size() != n) {
                System.out.println("checkLeafSet: replicaSet size failure at " + regrTestApp.getNodeId() + " k=" + n2 + " expectedSize=" + n + " " + "\n" + nodeSet + "\n" + leafSet + " distanceSet:" + serializable);
            }
            n4 = leafSet.overlaps() || leafSet.size() == 0 ? nodeSet.size() - 1 : (n2 > 0 ? leafSet.cwSize() - n2 - 1 : leafSet.ccwSize() + n2 - 1);
            id = null;
            for (n3 = -1; n3 <= n4 * 2 + 1; ++n3) {
                IdRange idRange = n3 < 0 ? regrTestApp.range(leafSet.get(n2), n4, id, true) : regrTestApp.range(leafSet.get(n2), n3 / 2, id, false);
                if (idRange == null) {
                    if (n4 < 0) continue;
                    System.out.println("checkLeafSet: range size failure at " + regrTestApp.getNodeId() + " k=" + n2 + " maxRank=" + n4 + "\n" + nodeSet + "\n" + leafSet);
                    continue;
                }
                id = leafSet.get(n2).getNodeId();
                int n6 = n2;
                NodeSet nodeSet2 = leafSet.replicaSet(idRange.getCCW(), n4 + 1);
                if (n3 >= 0 && nodeSet2.get(n3 / 2) == null || n3 >= 0 && !nodeSet2.get(n3 / 2).getNodeId().equals(id) || n3 < 0 && !leafSet.overlaps() && !nodeSet2.get(n4).getNodeId().equals(id) || n3 < 0 && leafSet.overlaps() && !idRange.isFull()) {
                    System.out.println("checkLeafSet: range failure 1 at " + regrTestApp.getNodeId() + " k=" + n2 + " j=" + n3 + " maxRank=" + n4 + "\n" + nodeSet2 + "\n" + leafSet + "\n" + idRange + "\nnearest=" + id);
                    System.out.println("dist(nearest)=" + id.distance(idRange.getCCW()));
                    if (leafSet.get(n6 - 1) != null) {
                        System.out.println("dist(nearest-1)=" + leafSet.get(n6 - 1).getNodeId().distance(idRange.getCCW()));
                    }
                    if (leafSet.get(n6 + 1) != null) {
                        System.out.println("dist(nearest+1)=" + leafSet.get(n6 + 1).getNodeId().distance(idRange.getCCW()));
                    }
                }
                nodeSet2 = leafSet.replicaSet(idRange.getCW().getCCW(), n4 + 1);
                if (n3 >= 0 && nodeSet2.get(n3 / 2) == null || n3 >= 0 && !nodeSet2.get(n3 / 2).getNodeId().equals(id) || n3 < 0 && !leafSet.overlaps() && !nodeSet2.get(n4).getNodeId().equals(id) || n3 < 0 && leafSet.overlaps() && !idRange.isFull()) {
                    System.out.println("checkLeafSet: range failure 2 at " + regrTestApp.getNodeId() + " k=" + n2 + " j=" + n3 + " maxRank=" + n4 + "\n" + nodeSet2 + "\n" + leafSet + "\n" + idRange + "\nnearest=" + id);
                    System.out.println("dist(nearest)=" + id.distance(idRange.getCW()));
                    if (leafSet.get(n6 - 1) != null) {
                        System.out.println("dist(nearest-1)=" + leafSet.get(n6 - 1).getNodeId().distance(idRange.getCW()));
                    }
                    if (leafSet.get(n6 + 1) != null) {
                        System.out.println("dist(nearest+1)=" + leafSet.get(n6 + 1).getNodeId().distance(idRange.getCW()));
                    }
                }
                id = idRange.getCW();
            }
        }
    }

    private void checkRoutingTable(RegrTestApp regrTestApp) {
        RoutingTable routingTable = regrTestApp.getRoutingTable();
        for (int i = routingTable.numRows() - 1; i >= 0; --i) {
            for (int j = 0; j < routingTable.numColumns(); ++j) {
                RouteSet routeSet = routingTable.getRouteSet(i, j);
                Id id = regrTestApp.getNodeId().getDomainPrefix(i, j, 0, routingTable.baseBitLength());
                Id id2 = regrTestApp.getNodeId().getDomainPrefix(i, j, -1, routingTable.baseBitLength());
                if (routeSet == null || routeSet.size() == 0) {
                    int n = this.pastryNodesSorted.subMap(id, id2).size() + (this.pastryNodesSorted.containsKey(id2) ? 1 : 0);
                    if (n <= 0) continue;
                    System.out.println("checkRoutingTable: missing RT entry at" + regrTestApp.getNodeId() + "row=" + i + " column=" + j + " inBetween=" + n);
                    continue;
                }
                NodeHandle nodeHandle = routeSet.closestNode();
                int n = Integer.MAX_VALUE;
                if (nodeHandle != null) {
                    n = nodeHandle.proximity();
                    if (nodeHandle.proximity() == Integer.MAX_VALUE) {
                        System.out.println("checkRoutingTable failure 0, row=" + i + " column=" + j);
                    }
                }
                for (int k = 0; k < routeSet.size(); ++k) {
                    NodeId nodeId;
                    if (routeSet.get(k).isAlive() && routeSet.get(k).proximity() < n) {
                        System.out.println("checkRoutingTable failure 1, row=" + i + " column=" + j + " rank=" + k);
                    }
                    if (!this.pastryNodesSorted.containsKey(nodeId = routeSet.get(k).getNodeId())) {
                        if (!this.isReallyAlive(nodeId)) continue;
                        System.out.println("checkRoutingTable failure 2, row=" + i + " column=" + j + " rank=" + k);
                        continue;
                    }
                    if (this.pastryNodesSorted.subMap(id, id2).containsKey(nodeId) || id2.equals(nodeId)) continue;
                    System.out.println("checkRoutingTable failure 3, row=" + i + " column=" + j + " rank=" + k);
                }
            }
        }
    }

    private void initiateLeafSetMaintenance() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(i);
            pastryNode.receiveMessage(new InitiateLeafSetMaintenance());
            while (this.simulate()) {
            }
        }
    }

    private void initiateRouteSetMaintenance() {
        for (int i = 0; i < this.pastryNodes.size(); ++i) {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(i);
            pastryNode.receiveMessage(new InitiateRouteSetMaintenance());
            while (this.simulate()) {
            }
        }
    }

    private void killNodes(int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = this.rng.nextInt(this.pastryNodes.size());
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(n2);
            this.pastryNodes.remove(n2);
            this.rtApps.remove(n2);
            this.pastryNodesSorted.remove(pastryNode.getNodeId());
            this.killNode(pastryNode);
            System.out.println("Killed " + pastryNode.getNodeId());
        }
    }

    protected static void mainfunc(PastryRegrTest pastryRegrTest, String[] stringArray, int n, int n2, int n3, int n4, int n5) {
        int n6;
        Date date = new Date();
        while (pastryRegrTest.pastryNodes.size() < n) {
            n6 = n - pastryRegrTest.pastryNodes.size();
            if (n6 > n5) {
                n6 = n5;
            }
            pastryRegrTest.makePastryNode(n6);
            if (pastryRegrTest.pastryNodes.size() % n4 == 0) {
                Date date2 = new Date();
                System.out.println(pastryRegrTest.pastryNodes.size() + " " + (date2.getTime() - date.getTime()) + " " + pastryRegrTest.msgCount);
                pastryRegrTest.msgCount = 0;
                date = date2;
            }
            pastryRegrTest.sendPings(n3);
        }
        System.out.println(pastryRegrTest.pastryNodes.size() + " nodes constructed");
        System.out.println("starting RT and leafset check");
        for (n6 = 0; n6 < pastryRegrTest.rtApps.size(); ++n6) {
            pastryRegrTest.checkLeafSet((RegrTestApp)pastryRegrTest.rtApps.get(n6));
            pastryRegrTest.checkRoutingTable((RegrTestApp)pastryRegrTest.rtApps.get(n6));
        }
        System.out.println("finished RT and leafset check");
        pastryRegrTest.killNodes(n2);
        System.out.println(n2 + " nodes killed");
        pastryRegrTest.sendPings((n - n2) * n3);
        System.out.println((n - n2) * n3 + " messages sent");
        System.out.println("starting leafset/RT maintenance");
        pastryRegrTest.initiateLeafSetMaintenance();
        pastryRegrTest.initiateRouteSetMaintenance();
        System.out.println("finished leafset/RT maintenance");
        pastryRegrTest.sendPings((n - n2) * n3);
        System.out.println((n - n2) * n3 + " messages sent");
        pastryRegrTest.pause(5000);
        System.out.println("starting RT and leafset check");
        for (n6 = 0; n6 < pastryRegrTest.rtApps.size(); ++n6) {
            pastryRegrTest.checkLeafSet((RegrTestApp)pastryRegrTest.rtApps.get(n6));
            pastryRegrTest.checkRoutingTable((RegrTestApp)pastryRegrTest.rtApps.get(n6));
        }
        for (n6 = 0; n6 < 4; ++n6) {
            System.out.println("Starting leafset/RT maintenance, round " + (n6 + 2));
            pastryRegrTest.initiateLeafSetMaintenance();
            pastryRegrTest.initiateRouteSetMaintenance();
            System.out.println("finished leafset/RT maintenance, round " + (n6 + 2));
            pastryRegrTest.sendPings((n - n2) * n3);
            System.out.println((n - n2) * n3 + " messages sent");
            System.out.println("starting RT and leafset check, round " + (n6 + 2));
            for (int i = 0; i < pastryRegrTest.rtApps.size(); ++i) {
                pastryRegrTest.checkLeafSet((RegrTestApp)pastryRegrTest.rtApps.get(i));
                pastryRegrTest.checkRoutingTable((RegrTestApp)pastryRegrTest.rtApps.get(i));
            }
            pastryRegrTest.pause(1000);
        }
        pastryRegrTest.pause(5000);
        System.out.println("finished, exiting...");
        System.exit(0);
    }
}

