/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.PingClient;

public class PastryTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private Vector pastryNodes;
    private Vector pingClients;
    private Random rng;

    public PastryTest() {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    public void makePastryNode() {
        PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pastryNode);
        PingClient pingClient = new PingClient(pastryNode);
        this.pingClients.addElement(pingClient);
    }

    public void sendPings(int n) {
        int n2 = this.pingClients.size();
        for (int i = 0; i < n; ++i) {
            int n3 = this.rng.nextInt(n2);
            int n4 = this.rng.nextInt(n2);
            PingClient pingClient = (PingClient)this.pingClients.get(n3);
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(n4);
            pingClient.sendTrace(pastryNode.getNodeId());
            while (this.simulate()) {
            }
            System.out.println("-------------------");
        }
    }

    public boolean simulate() {
        return this.simulator.simulate();
    }

    public static void main(String[] stringArray) {
        PastryTest pastryTest = new PastryTest();
        int n = 4000;
        int n2 = 100;
        int n3 = 10;
        int n4 = 0;
        Date date = new Date();
        for (int i = 0; i < n; ++i) {
            pastryTest.makePastryNode();
            while (pastryTest.simulate()) {
                ++n4;
            }
            if ((i + 1) % n2 != 0) continue;
            Date date2 = new Date();
            System.out.println(i + 1 + " " + (date2.getTime() - date.getTime()) + " " + n4);
            n4 = 0;
            date = date2;
        }
        System.out.println(n + " nodes constructed");
        pastryTest.sendPings(n3);
    }
}

