/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.direct.DirectNodeHandle;
import rice.pastry.direct.DirectPastryNode;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.PingAddress;
import rice.pastry.testing.PingMessageNew;
import rice.pastry.testing.PingTestRecord;

public class Ping
extends PastryAppl {
    private static Address pingAddress = new PingAddress();
    private Credentials pingCred = new PermissiveCredentials();

    public Ping(PastryNode pastryNode) {
        super(pastryNode);
    }

    public Address getAddress() {
        return pingAddress;
    }

    public Credentials getCredentials() {
        return this.pingCred;
    }

    public void sendPing(NodeId nodeId) {
        this.routeMsg(nodeId, new PingMessageNew(pingAddress, this.getNodeId(), nodeId), this.pingCred, new SendOptions());
    }

    public void messageForAppl(Message message) {
        PingMessageNew pingMessageNew = (PingMessageNew)message;
        int n = pingMessageNew.getHops() - 1;
        double d = pingMessageNew.getDistance();
        NetworkSimulator networkSimulator = ((DirectNodeHandle)((DirectPastryNode)this.thePastryNode).getLocalHandle()).getSimulator();
        PingTestRecord pingTestRecord = (PingTestRecord)networkSimulator.getTestRecord();
        double d2 = networkSimulator.proximity(this.thePastryNode.getNodeId(), pingMessageNew.getSource());
        double d3 = d2 == 0.0 ? 0.0 : d / d2;
        pingTestRecord.addHops(n);
        pingTestRecord.addDistance(d3);
    }

    public boolean enrouteMessage(Message message, Id id, NodeId nodeId, SendOptions sendOptions) {
        PingMessageNew pingMessageNew = (PingMessageNew)message;
        pingMessageNew.incrHops();
        pingMessageNew.incrDistance(((DirectNodeHandle)((DirectPastryNode)this.thePastryNode).getLocalHandle()).getSimulator().proximity(this.thePastryNode.getNodeId(), nodeId));
        return true;
    }

    public void leafSetChange(NodeHandle nodeHandle, boolean bl) {
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
    }
}

