/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.PastryAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.PingMessage;

public class PingClient
extends PastryAppl {
    private static Address pingAddress = new PingAddress();
    private Credentials pingCred = new PermissiveCredentials();

    public PingClient(PastryNode pastryNode) {
        super(pastryNode);
    }

    public Address getAddress() {
        return pingAddress;
    }

    public Credentials getCredentials() {
        return this.pingCred;
    }

    public void sendPing(NodeId nodeId) {
        this.routeMsg(nodeId, new PingMessage(pingAddress, this.getNodeId(), nodeId), this.pingCred, new SendOptions());
    }

    public void sendTrace(NodeId nodeId) {
        System.out.println("sending a trace from " + this.getNodeId() + " to " + nodeId);
        this.routeMsg(nodeId, new PingMessage(pingAddress, this.getNodeId(), nodeId), this.pingCred, new SendOptions());
    }

    public void messageForAppl(Message message) {
        System.out.print(message);
        System.out.println(" received");
    }

    public boolean enrouteMessage(Message message, Id id, NodeId nodeId, SendOptions sendOptions) {
        System.out.print(message);
        System.out.println(" at " + this.getNodeId());
        return true;
    }

    public void leafSetChange(NodeHandle nodeHandle, boolean bl) {
        System.out.println("at... " + this.getNodeId() + "'s leaf set");
        System.out.print("node " + nodeHandle.getNodeId() + " was ");
        if (bl) {
            System.out.println("added");
        } else {
            System.out.println("removed");
        }
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
        System.out.println("at... " + this.getNodeId() + "'s route set");
        System.out.print("node " + nodeHandle.getNodeId() + " was ");
        if (bl) {
            System.out.println("added");
        } else {
            System.out.println("removed");
        }
    }

    private static class PingAddress
    implements Address {
        private int myCode = -1843799809;

        private PingAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object object) {
            return object instanceof PingAddress;
        }

        public String toString() {
            return "[PingAddress]";
        }
    }
}

