/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.direct.TestRecord;
import rice.pastry.routing.RoutingTable;

public class PingTestRecord
extends TestRecord {
    private int nIndex;
    private int[] nHops;
    private double[] fProb;
    private double fHops;
    private double fDistance = 0.0;

    public PingTestRecord(int n, int n2) {
        super(n, n2);
        this.nIndex = (int)Math.ceil(Math.log(n) / Math.log(Math.pow(2.0, RoutingTable.baseBitLength())));
        this.nIndex *= 3;
        this.nHops = new int[this.nIndex];
        this.fProb = new double[this.nIndex];
    }

    public void doneTest() {
        int n;
        long l = 0L;
        for (n = 0; n < this.nIndex; ++n) {
            l += (long)(this.nHops[n] * n);
        }
        this.fHops = (double)l / (double)this.nTests;
        this.fDistance /= (double)this.nTests;
        for (n = 0; n < this.nIndex; ++n) {
            this.fProb[n] = (double)(n * this.nHops[n]) / (double)l;
        }
    }

    public void addHops(int n) {
        int n2 = n;
        this.nHops[n2] = this.nHops[n2] + 1;
    }

    public void addDistance(double d) {
        this.fDistance += d;
    }

    public double getAveHops() {
        return this.fHops;
    }

    public double getAveDistance() {
        return this.fDistance;
    }

    public double[] getProbability() {
        return this.fProb;
    }
}

