/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import rice.pastry.Id;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.client.CommonAPIAppl;
import rice.pastry.messaging.Address;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.routing.RoutingTable;
import rice.pastry.routing.SendOptions;
import rice.pastry.security.Credentials;
import rice.pastry.security.PermissiveCredentials;
import rice.pastry.testing.PastryRegrTest;
import rice.pastry.testing.RTMessage;

public class RegrTestApp
extends CommonAPIAppl {
    private static Credentials cred = new PermissiveCredentials();
    private static Address addr = new RTAddress();
    private PastryRegrTest prg;

    public RegrTestApp(PastryNode pastryNode, PastryRegrTest pastryRegrTest) {
        super(pastryNode);
        this.prg = pastryRegrTest;
    }

    public Address getAddress() {
        return addr;
    }

    public Credentials getCredentials() {
        return cred;
    }

    public void sendMsg(NodeId nodeId) {
        this.routeMsg(nodeId, new RTMessage(addr, this.getNodeHandle(), nodeId), cred, new SendOptions());
    }

    public void sendTrace(NodeId nodeId) {
        this.routeMsg(nodeId, new RTMessage(addr, this.getNodeHandle(), nodeId), cred, new SendOptions());
    }

    public void deliver(Id id, Message message) {
        RTMessage rTMessage = (RTMessage)message;
        NodeId nodeId = this.getNodeId();
        if (nodeId != id) {
            int n;
            if (nodeId.compareTo(id) < 0) {
                int n2;
                int n3 = this.prg.pastryNodesSorted.subMap(nodeId, id).size();
                n = n3 < (n2 = this.prg.pastryNodesSorted.tailMap(id).size() + this.prg.pastryNodesSorted.headMap(nodeId).size()) ? n3 : n2;
            } else {
                int n4;
                int n5 = this.prg.pastryNodesSorted.subMap(id, nodeId).size();
                int n6 = n = n5 < (n4 = this.prg.pastryNodesSorted.tailMap(nodeId).size() + this.prg.pastryNodesSorted.headMap(id).size()) ? n5 : n4;
            }
            if (n > 1) {
                System.out.println("messageForAppl failure, inBetween=" + n);
                System.out.print(message);
                System.out.println(" received at " + this.getNodeId());
                System.out.println(this.getLeafSet());
            }
        }
    }

    public void forward(RouteMessage routeMessage) {
        Message message = routeMessage.unwrap();
        Id id = routeMessage.getTarget();
        NodeId nodeId = routeMessage.getNextHop().getNodeId();
        NodeId nodeId2 = this.getNodeId();
        Id.Distance distance = nodeId2.distance(id);
        this.getRoutingTable();
        int n = RoutingTable.baseBitLength();
        if (this.prg.lastMsg == message) {
            int n2;
            int n3 = nodeId2.indexOfMSDD(id, n);
            if (n3 > (n2 = this.prg.lastNode.indexOfMSDD(id, n)) && nodeId != nodeId2 || n3 == n2 && distance.compareTo(this.prg.lastDist) > 0) {
                System.out.println("at... " + this.getNodeId() + " enrouteMessage failure with " + message + " lastNode=" + this.prg.lastNode + " lastDist=" + this.prg.lastDist + " dist=" + distance + " nextHop=" + nodeId + " loci=" + n3 + " lasti=" + n2);
            }
            this.prg.lastDist = distance;
        }
        this.prg.lastMsg = message;
        this.prg.lastDist = distance;
        this.prg.lastNode = nodeId2;
    }

    public void update(NodeHandle nodeHandle, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        NodeId nodeId;
        NodeId nodeId2 = nodeHandle.getNodeId();
        if (!this.prg.pastryNodesSorted.containsKey(nodeId2) && nodeHandle.isAlive()) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 1 with " + nodeId2);
        }
        if ((nodeId = this.thePastryNode.getNodeId()) == nodeId2) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 2 with " + nodeId2);
        }
        if ((n4 = nodeId.compareTo(nodeId2) < 0 ? ((n3 = this.prg.pastryNodesSorted.subMap(nodeId, nodeId2).size()) < (n2 = this.prg.pastryNodesSorted.tailMap(nodeId2).size() + this.prg.pastryNodesSorted.headMap(nodeId).size()) ? n3 : n2) : ((n3 = this.prg.pastryNodesSorted.subMap(nodeId2, nodeId).size()) < (n = this.prg.pastryNodesSorted.tailMap(nodeId).size() + this.prg.pastryNodesSorted.headMap(nodeId2).size()) ? n3 : n)) > (n3 = this.getLeafSet().maxSize() / 2) && bl && !this.prg.pastryNodesLastAdded.contains(this.thePastryNode) && !this.prg.inConcJoin || n4 <= n3 && !bl && this.getLeafSet().get(nodeId2) == null && this.prg.pastryNodesSorted.containsKey(nodeHandle.getNodeId())) {
            System.out.println("at... " + this.getNodeId() + "leafSetChange failure 3 with " + nodeId2 + " wasAdded=" + bl + " inBetween=" + n4);
            System.out.println(this.getLeafSet());
        }
    }

    public void routeSetChange(NodeHandle nodeHandle, boolean bl) {
        NodeId nodeId = nodeHandle.getNodeId();
        if (!this.prg.pastryNodesSorted.containsKey(nodeId) && (nodeHandle.isAlive() || bl)) {
            System.out.println("at... " + this.getNodeId() + "routeSetChange failure 1 with " + nodeId + " wasAdded=" + bl);
        }
    }

    public void notifyReady() {
    }

    private static class RTAddress
    implements Address {
        private int myCode = -1843800321;

        private RTAddress() {
        }

        public int hashCode() {
            return this.myCode;
        }

        public boolean equals(Object object) {
            return object instanceof RTAddress;
        }

        public String toString() {
            return "[RTAddress]";
        }
    }
}

