/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.testing;

import java.util.Date;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import rice.pastry.NodeHandle;
import rice.pastry.PastryNode;
import rice.pastry.PastrySeed;
import rice.pastry.direct.DirectPastryNodeFactory;
import rice.pastry.direct.EuclideanNetwork;
import rice.pastry.direct.NetworkSimulator;
import rice.pastry.direct.TestRecord;
import rice.pastry.standard.RandomNodeIdFactory;
import rice.pastry.testing.Ping;

public class SinglePingTest {
    private DirectPastryNodeFactory factory;
    private NetworkSimulator simulator = new EuclideanNetwork();
    private TestRecord testRecord;
    private Vector pastryNodes;
    private Vector pingClients;
    private Random rng;

    public SinglePingTest(TestRecord testRecord) {
        this.factory = new DirectPastryNodeFactory(new RandomNodeIdFactory(), this.simulator);
        this.simulator.setTestRecord(testRecord);
        this.testRecord = testRecord;
        this.pastryNodes = new Vector();
        this.pingClients = new Vector();
        this.rng = new Random(PastrySeed.getSeed());
    }

    private NodeHandle getBootstrap() {
        NodeHandle nodeHandle = null;
        try {
            PastryNode pastryNode = (PastryNode)this.pastryNodes.lastElement();
            nodeHandle = pastryNode.getLocalHandle();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return nodeHandle;
    }

    public void makePastryNode() {
        PastryNode pastryNode = this.factory.newNode(this.getBootstrap());
        this.pastryNodes.addElement(pastryNode);
        Ping ping = new Ping(pastryNode);
        this.pingClients.addElement(ping);
    }

    public void sendPings(int n) {
        int n2 = this.pingClients.size();
        for (int i = 0; i < n; ++i) {
            int n3 = this.rng.nextInt(n2);
            int n4 = this.rng.nextInt(n2);
            Ping ping = (Ping)this.pingClients.get(n3);
            PastryNode pastryNode = (PastryNode)this.pastryNodes.get(n4);
            ping.sendPing(pastryNode.getNodeId());
            while (this.simulate()) {
            }
        }
    }

    public boolean simulate() {
        return this.simulator.simulate();
    }

    public void checkRoutingTable() {
        int n;
        Date date = new Date();
        for (n = 0; n < this.testRecord.getNodeNumber(); ++n) {
            this.makePastryNode();
            while (this.simulate()) {
            }
            if (n == 0 || n % 1000 != 0) continue;
            System.out.println(n + " nodes constructed");
        }
        System.out.println(n + " nodes constructed");
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("time used " + l / 60000L + ":" + l % 60000L / 1000L + ":" + l % 60000L % 1000L);
    }

    public void test() {
        int n;
        Date date = new Date();
        System.out.println("-------------------------");
        for (n = 0; n < this.testRecord.getNodeNumber(); ++n) {
            this.makePastryNode();
            while (this.simulate()) {
            }
            if (n == 0 || n % 500 != 0) continue;
            System.out.println(n + " nodes constructed");
        }
        System.out.println(n + " nodes constructed");
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("time used " + l / 60000L + ":" + l % 60000L / 1000L + ":" + l % 60000L % 1000L);
        date = date2;
        this.sendPings(this.testRecord.getTestNumber());
        System.out.println(this.testRecord.getTestNumber() + " lookups done");
        date2 = new Date();
        l = date2.getTime() - date.getTime();
        System.out.println("time used " + l / 60000L + ":" + l % 60000L / 1000L + ":" + l % 60000L % 1000L);
        this.testRecord.doneTest();
    }
}

