/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.messaging.Message;
import rice.pastry.wire.DatagramTransmissionManager;
import rice.pastry.wire.NeedsWakeUp;
import rice.pastry.wire.PendingWrite;
import rice.pastry.wire.SelectionKeyHandler;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WireNodeHandlePool;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.exception.DeserializationException;
import rice.pastry.wire.exception.ImproperlyFormattedMessageException;
import rice.pastry.wire.exception.SerializationException;
import rice.pastry.wire.messaging.datagram.AcknowledgementMessage;
import rice.pastry.wire.messaging.datagram.DatagramMessage;
import rice.pastry.wire.messaging.datagram.DatagramTransportMessage;
import rice.pastry.wire.messaging.datagram.PingMessage;

public class DatagramManager
implements SelectionKeyHandler,
NeedsWakeUp {
    private int port;
    private WirePastryNode pastryNode;
    private SelectorManager manager;
    private ByteBuffer buffer;
    private DatagramChannel channel;
    private SelectionKey key;
    private DatagramTransmissionManager transmissionManager;
    private HashMap lastAckNum;
    private LinkedList ackQueue;
    public static int DATAGRAM_RECEIVE_BUFFER_SIZE = 131072;
    public static int DATAGRAM_SEND_BUFFER_SIZE = 65536;
    transient PrintStream outputStream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramManager(WirePastryNode wirePastryNode, SelectorManager selectorManager, int n) {
        this.port = n;
        this.manager = selectorManager;
        this.pastryNode = wirePastryNode;
        this.ackQueue = new LinkedList();
        this.lastAckNum = new HashMap();
        this.buffer = ByteBuffer.allocateDirect(DATAGRAM_SEND_BUFFER_SIZE);
        try {
            Selector selector;
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
            this.channel.socket().bind(inetSocketAddress);
            this.channel.socket().setSendBufferSize(DATAGRAM_SEND_BUFFER_SIZE);
            this.channel.socket().setReceiveBufferSize(DATAGRAM_RECEIVE_BUFFER_SIZE);
            Selector selector2 = selector = selectorManager.getSelector();
            synchronized (selector2) {
                this.key = this.channel.register(selector, 1);
            }
            this.key.attach(this);
        }
        catch (IOException iOException) {
            System.out.println("PANIC: Error binding datagram server to port " + n + ": " + iOException);
            System.exit(-1);
        }
        this.transmissionManager = new DatagramTransmissionManager(wirePastryNode, this.key, this);
    }

    public void notifyKilled() {
        this.transmissionManager.notifyKilled();
    }

    public void resetAckNumber(NodeId nodeId) {
        this.transmissionManager.resetAckNumber(nodeId);
        this.lastAckNum.remove(nodeId);
    }

    public void write(NodeId nodeId, InetSocketAddress inetSocketAddress, Object object) {
        this.debug("Enqueueing write to " + nodeId + " of " + object);
        this.transmissionManager.add(new PendingWrite(nodeId, inetSocketAddress, object));
    }

    public void read(SelectionKey selectionKey) {
        WireNodeHandle wireNodeHandle = null;
        try {
            InetSocketAddress inetSocketAddress = null;
            while ((inetSocketAddress = (InetSocketAddress)this.channel.receive(this.buffer)) != null) {
                this.buffer.flip();
                if (this.buffer.remaining() > 0) {
                    Object object = DatagramManager.deserialize(this.buffer);
                    if (object instanceof DatagramMessage) {
                        DatagramTransportMessage datagramTransportMessage;
                        DatagramMessage datagramMessage = (DatagramMessage)object;
                        if (datagramMessage instanceof DatagramTransportMessage) {
                            datagramTransportMessage = (DatagramTransportMessage)datagramMessage;
                            this.wireDebug(datagramMessage.getSource() + ":REC:" + datagramTransportMessage.getObject());
                        } else {
                            this.wireDebug(datagramMessage.getSource() + ":REC:" + datagramMessage);
                        }
                        if (datagramMessage.getDestination().equals(this.pastryNode.getNodeId())) {
                            wireNodeHandle = ((WireNodeHandlePool)this.pastryNode.getNodeHandlePool()).get(datagramMessage.getSource());
                            if (wireNodeHandle == null) {
                                wireNodeHandle = new WireNodeHandle(inetSocketAddress, datagramMessage.getSource(), this.pastryNode);
                                System.out.println("Making new wirehandle with name " + inetSocketAddress.getHostName());
                                System.out.println("Source name received " + datagramMessage.getSourceName() + "message " + datagramMessage);
                                wireNodeHandle.setNodeName(new NodeName(datagramMessage.getSourceName()));
                                wireNodeHandle = (WireNodeHandle)this.pastryNode.getNodeHandlePool().coalesce(wireNodeHandle);
                            }
                            if (object instanceof AcknowledgementMessage) {
                                this.transmissionManager.receivedAck((AcknowledgementMessage)datagramMessage);
                                continue;
                            }
                            if (!wireNodeHandle.isAlive()) {
                                System.out.println("false !!!");
                                this.lastAckNum.remove(datagramMessage.getSource());
                            }
                            if (!this.sendAck(inetSocketAddress, datagramMessage)) continue;
                            if (object instanceof DatagramTransportMessage) {
                                datagramTransportMessage = (DatagramTransportMessage)object;
                                this.pastryNode.receiveMessage((Message)datagramTransportMessage.getObject());
                                continue;
                            }
                            if (object instanceof PingMessage) continue;
                            System.out.println("ERROR: Recieved unreccognized datagrammessage: " + object);
                            continue;
                        }
                        this.debug("ERROR: Recieved message " + datagramMessage + " at " + this.pastryNode.getNodeId() + " for dest " + datagramMessage.getDestination() + " - dropping on floor.");
                        continue;
                    }
                    System.out.println("ERROR: Received unrecognized message " + object + " at " + this.pastryNode.getNodeId() + " - dropping on floor.");
                    continue;
                }
                this.debug("Read from datagram channel, but no bytes were there - no bad, but wierd.");
                this.buffer.clear();
                break;
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR (datagrammanager:read): " + iOException);
            this.debug("ERROR (datagrammanager:read): " + iOException);
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wireDebug(String string) {
        if (!Wire.outputDebug) {
            return;
        }
        Object object = Wire.outputStreamLock;
        synchronized (object) {
            try {
                if (this.outputStream == null) {
                    String string2 = null;
                    if (this.pastryNode != null) {
                        string2 = this.pastryNode.getId().toString();
                    }
                    String string3 = "DM " + string2 + ".txt";
                    this.outputStream = new PrintStream(new FileOutputStream(string3));
                }
                this.outputStream.println(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void write(SelectionKey selectionKey) {
        try {
            Object object;
            Iterator iterator = this.ackQueue.iterator();
            while (iterator.hasNext()) {
                object = (AcknowledgementMessage)iterator.next();
                if (this.channel.send(DatagramManager.serialize(object), ((AcknowledgementMessage)object).getAddress()) > 0) {
                    iterator.remove();
                    continue;
                }
                System.out.println("ERROR: 0 bytes written of ack (not fatal, but bad)");
            }
            iterator = this.transmissionManager.getReady();
            while (iterator.hasNext()) {
                Object object2;
                object = (PendingWrite)iterator.next();
                Object object3 = ((PendingWrite)object).getObject();
                int n = 0;
                if (object3 instanceof DatagramTransportMessage) {
                    object2 = (DatagramTransportMessage)object3;
                    n = ((DatagramMessage)object2).getNum();
                    object3 = ((DatagramTransportMessage)object2).getObject();
                }
                this.wireDebug(((PendingWrite)object).getDestination() + ":" + "SEN:" + object3);
                this.wireDebug(((PendingWrite)object).getDestination() + ":" + "DBG:" + n + ":" + object3);
                object2 = DatagramManager.serialize(((PendingWrite)object).getObject());
                int n2 = this.channel.send((ByteBuffer)object2, ((PendingWrite)object).getAddress());
                if (n2 == 0) {
                    System.out.println("ERROR: 0 bytes were written (not fatal, but bad) - full buffer.");
                }
                this.debug("Wrote message " + ((PendingWrite)object).getObject() + " to " + ((PendingWrite)object).getDestination());
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR (datagrammanager:write): " + iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        WirePastryNode wirePastryNode = this.pastryNode;
        synchronized (wirePastryNode) {
            this.transmissionManager.wakeup();
        }
        int n = this.ackQueue.size();
        if (n > 0) {
            this.transmissionManager.enableWrite(true, "ackQueue.size() = " + n);
        }
    }

    public void accept(SelectionKey selectionKey) {
        System.out.println("PANIC: accept was called on the DatagramManager!");
    }

    public void connect(SelectionKey selectionKey) {
        System.out.println("PANIC: connect was called on the DatagramManager!");
    }

    private boolean sendAck(InetSocketAddress inetSocketAddress, DatagramMessage datagramMessage) throws IOException {
        Integer n;
        if (this.channel.send(DatagramManager.serialize(datagramMessage.getAck(inetSocketAddress)), inetSocketAddress) == 0) {
            this.ackQueue.add(datagramMessage.getAck(inetSocketAddress));
        }
        if ((n = (Integer)this.lastAckNum.get(datagramMessage.getSource())) == null || n < datagramMessage.getNum()) {
            this.lastAckNum.put(datagramMessage.getSource(), new Integer(datagramMessage.getNum()));
            return true;
        }
        if (n > datagramMessage.getNum()) {
            this.debug(this.pastryNode.getNodeId() + " (M): ERROR: Got transmission with ack less than the last ack - ignoring message." + " This is probably becuase a socket is being opened, but we haven't yet noticed it.");
        }
        return false;
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            System.out.println(this.pastryNode.getNodeId() + " (DM): " + string);
        }
    }

    public static ByteBuffer serialize(Object object) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            int n = byteArrayOutputStream.toByteArray().length;
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        catch (InvalidClassException invalidClassException) {
            System.out.println("PANIC: Object to be serialized was an invalid class!");
            throw new SerializationException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException notSerializableException) {
            System.out.println("PANIC: Object to be serialized was not serializable! [" + object + "]");
            throw new SerializationException("Unserializable class " + object + " during attempt to serialize.");
        }
    }

    public static Object deserialize(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        byteBuffer.clear();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        try {
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("PANIC: Unknown class type in serialized message!");
            throw new ImproperlyFormattedMessageException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException invalidClassException) {
            System.out.println("PANIC: Serialized message was an invalid class!");
            throw new DeserializationException("Invalid class in message - closing channel.");
        }
    }
}

