/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.NodeName;
import rice.pastry.messaging.Message;
import rice.pastry.wire.DatagramManager;
import rice.pastry.wire.PendingWrite;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WireNodeHandlePool;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.exception.NodeIsDeadException;
import rice.pastry.wire.messaging.datagram.AcknowledgementMessage;
import rice.pastry.wire.messaging.datagram.DatagramMessage;
import rice.pastry.wire.messaging.datagram.DatagramTransportMessage;
import rice.pastry.wire.messaging.datagram.PingMessage;
import rice.pastry.wire.messaging.socket.SocketTransportMessage;

public class DatagramTransmissionManager {
    boolean writing = false;
    private HashMap map;
    private SelectionKey key;
    private WirePastryNode pastryNode;
    private Random random;
    public static int BEGIN_ACK_NUM = Integer.MIN_VALUE;
    private DatagramManager datagramManager;
    private Object killedLock = new Object();
    private boolean killed = false;

    public DatagramTransmissionManager(WirePastryNode wirePastryNode, SelectionKey selectionKey, DatagramManager datagramManager) {
        this.map = new HashMap();
        this.datagramManager = datagramManager;
        this.key = selectionKey;
        this.pastryNode = wirePastryNode;
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getReady() {
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            LinkedList<PendingWrite> linkedList = new LinkedList<PendingWrite>();
            Object[] objectArray = this.getEntries();
            for (int i = 0; i < objectArray.length; ++i) {
                TransmissionEntry transmissionEntry = (TransmissionEntry)objectArray[i];
                if (transmissionEntry.getState() != transmissionEntry.STATE_READY) continue;
                linkedList.addLast(transmissionEntry.get());
            }
            return linkedList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKilled() {
        Object object = this.killedLock;
        synchronized (object) {
            if (this.killed) {
                return;
            }
            this.killed = true;
        }
        object = this.map;
        synchronized (object) {
            Iterator iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                ((TransmissionEntry)iterator.next()).notifyKilled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PendingWrite pendingWrite) {
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            TransmissionEntry transmissionEntry = (TransmissionEntry)this.map.get(pendingWrite.getDestination());
            if (transmissionEntry == null) {
                transmissionEntry = new TransmissionEntry(pendingWrite.getDestination(), pendingWrite.getAddress());
                this.map.put(pendingWrite.getDestination(), transmissionEntry);
            }
            transmissionEntry.add(pendingWrite);
            if (transmissionEntry.getState() == transmissionEntry.STATE_READY) {
                this.enableWrite(true, "added " + pendingWrite);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedAck(AcknowledgementMessage acknowledgementMessage) {
        TransmissionEntry transmissionEntry = null;
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            transmissionEntry = (TransmissionEntry)this.map.get(acknowledgementMessage.getSource());
        }
        if (transmissionEntry != null) {
            transmissionEntry.ackReceived(acknowledgementMessage.getNum());
        } else {
            this.debug("PANIC: Ack received from unknown nodeId " + acknowledgementMessage.getSource());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object[] objectArray = this.getEntries();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                TransmissionEntry transmissionEntry = (TransmissionEntry)objectArray[i];
                transmissionEntry.wakeup();
                if (transmissionEntry.getState() != transmissionEntry.STATE_READY) continue;
                bl = true;
            }
            this.enableWrite(bl, "wakeUp()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableWrite(boolean bl, String string) {
        block10: {
            this.writing = bl;
            try {
                Selector selector;
                if (bl) {
                    Selector selector2;
                    SelectorManager selectorManager = this.pastryNode.getSelectorManager();
                    Selector selector3 = selector2 = selectorManager.getSelector();
                    synchronized (selector3) {
                        this.key.interestOps(this.key.interestOps() | 4);
                        break block10;
                    }
                }
                SelectorManager selectorManager = this.pastryNode.getSelectorManager();
                Selector selector4 = selector = selectorManager.getSelector();
                synchronized (selector4) {
                    this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!this.key.isValid()) {
                    this.notifyKilled();
                    throw new NodeIsDeadException(cancelledKeyException);
                }
                throw cancelledKeyException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetAckNumber(NodeId nodeId) {
        TransmissionEntry transmissionEntry = null;
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            transmissionEntry = (TransmissionEntry)this.map.get(nodeId);
        }
        if (transmissionEntry != null) {
            transmissionEntry.resetAckNumber();
        } else {
            this.debug("PANIC: Reset request received for unknown nodeId " + nodeId);
        }
    }

    private Object[] getEntries() {
        return this.map.values().toArray();
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            System.out.println(this.pastryNode.getNodeId() + " (T): " + string);
        }
    }

    private class TransmissionEntry {
        public int STATE_READY = -1;
        public int STATE_WAITING_FOR_ACK = -2;
        public int STATE_NO_DATA = -3;
        public int STATE_WAITING_FOR_RESEND = -4;
        public int STATE_WAITING_TO_SEND = -5;
        public long SEND_TIMEOUT_DEFAULT = 1000L;
        public long SEND_TIMEOUT_MIN = 500L;
        public long INITIAL_RESEND_WAIT_TIME = 100L;
        public double TIMEOUT_FACTOR = 2.0;
        public int MAX_NUM_RETRIES = 6;
        public int NUM_RETRIES_BEFORE_OPENING_SOCKET = 4;
        public int MAX_UDP_QUEUE_SIZE = 4;
        private InetSocketAddress address;
        private NodeId nodeId;
        private WireNodeHandle handle;
        private LinkedList queue = new LinkedList();
        private int ackExpected = BEGIN_ACK_NUM;
        private long sendTime;
        private long resendWaitBeginTime;
        private long resendWaitTime;
        private int state = this.STATE_NO_DATA;
        private long sendTimeoutTime;
        private int numRetries;

        public TransmissionEntry(NodeId nodeId, InetSocketAddress inetSocketAddress) {
            this.resendWaitTime = (long)((double)this.INITIAL_RESEND_WAIT_TIME * (1.0 + DatagramTransmissionManager.this.random.nextDouble()));
            this.sendTimeoutTime = this.SEND_TIMEOUT_DEFAULT;
            this.numRetries = 0;
            this.nodeId = nodeId;
            this.address = inetSocketAddress;
            this.handle = ((WireNodeHandlePool)DatagramTransmissionManager.this.pastryNode.getNodeHandlePool()).get(nodeId);
            if (this.handle == null) {
                this.handle = new WireNodeHandle(inetSocketAddress, nodeId, DatagramTransmissionManager.this.pastryNode);
                this.handle.setNodeName(new NodeName(inetSocketAddress.getHostName()));
                System.out.println("DTM: hostname" + this.handle.getNodeName());
                this.handle = (WireNodeHandle)DatagramTransmissionManager.this.pastryNode.getNodeHandlePool().coalesce(this.handle);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyKilled() {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                Iterator iterator = this.queue.iterator();
                while (iterator.hasNext()) {
                    PendingWrite pendingWrite = (PendingWrite)iterator.next();
                    System.err.println("DTM2: Potentially lost the message:" + pendingWrite.getObject());
                }
            }
        }

        public PendingWrite get() {
            if (this.state == this.STATE_READY) {
                this.state = this.STATE_WAITING_FOR_ACK;
                this.sendTime = System.currentTimeMillis();
                PendingWrite pendingWrite = (PendingWrite)this.queue.getFirst();
                this.handle.wireDebug("DBG:udp.get():returning" + pendingWrite.getObject());
                this.debug("Returning write for object " + pendingWrite.getObject());
                if (pendingWrite.getObject() instanceof DatagramMessage) {
                    DatagramMessage datagramMessage = (DatagramMessage)pendingWrite.getObject();
                    datagramMessage.setNum(this.ackExpected);
                    return new PendingWrite(this.nodeId, this.address, datagramMessage);
                }
                DatagramTransportMessage datagramTransportMessage = new DatagramTransportMessage(DatagramTransmissionManager.this.pastryNode.getNodeId(), this.nodeId, this.ackExpected, pendingWrite.getObject());
                datagramTransportMessage.setSourceName(DatagramTransmissionManager.this.pastryNode.getLocalHandle().getNodeName().toString());
                return new PendingWrite(this.nodeId, this.address, datagramTransportMessage);
            }
            throw new IllegalArgumentException("get() called on non-ready TransmissionEntry.");
        }

        public int getState() {
            return this.state;
        }

        public void resetAckNumber() {
            this.ackExpected = BEGIN_ACK_NUM;
        }

        public void add(PendingWrite pendingWrite) {
            this.addToQueue(pendingWrite);
            this.handle.wireDebug("DBG:udp add(" + pendingWrite.getObject() + "):" + this.queue.size());
            this.debug("Added write for object " + pendingWrite.getObject());
            if (this.queue.size() > this.MAX_UDP_QUEUE_SIZE && !(pendingWrite.getObject() instanceof DatagramMessage) && this.handle.getState() == -1) {
                LinkedList<SocketTransportMessage> linkedList = new LinkedList<SocketTransportMessage>();
                this.debug("Queue has exceed maximum length - moving to TCP.");
                Iterator iterator = this.queue.iterator();
                while (iterator.hasNext()) {
                    PendingWrite pendingWrite2 = (PendingWrite)iterator.next();
                    if (pendingWrite2.getObject() instanceof DatagramMessage) continue;
                    this.handle.wireDebug("DBG:Q 2 Long" + pendingWrite2.getObject() + " to TCP queue.");
                    this.debug("Moving message " + pendingWrite2.getObject() + " to TCP queue.");
                    linkedList.addLast(new SocketTransportMessage(pendingWrite2.getObject(), pendingWrite2.getDestination()));
                    iterator.remove();
                }
                this.state = this.queue.size() > 0 ? this.STATE_READY : this.STATE_NO_DATA;
                this.handle.connectToRemoteNode(linkedList.iterator());
            } else if (this.state == this.STATE_NO_DATA) {
                this.state = this.STATE_READY;
            }
        }

        public void ackReceived(int n) {
            if (this.state != this.STATE_NO_DATA) {
                if (this.ackExpected == n) {
                    long l;
                    this.handle.markAlive();
                    PendingWrite pendingWrite = (PendingWrite)this.queue.removeFirst();
                    if (pendingWrite.getObject() instanceof PingMessage) {
                        this.handle.pingResponse();
                    }
                    this.sendTimeoutTime = (double)(l = System.currentTimeMillis() - this.sendTime) * this.TIMEOUT_FACTOR > (double)this.SEND_TIMEOUT_MIN ? (long)(this.TIMEOUT_FACTOR * (double)l) : this.SEND_TIMEOUT_MIN;
                    this.resendWaitTime /= 2L;
                    if (this.queue.size() > 0) {
                        this.state = this.STATE_WAITING_TO_SEND;
                        this.resendWaitBeginTime = System.currentTimeMillis();
                    } else {
                        this.state = this.STATE_NO_DATA;
                    }
                    this.numRetries = 0;
                    ++this.ackExpected;
                } else {
                    this.debug("WARNING: Got wrong ack - got " + n + " expected " + this.ackExpected);
                }
            } else {
                this.debug("WARNING: ackReceived() called on non-active TransmissionEntry. num " + n + " ackExpected " + this.ackExpected);
            }
        }

        public void wakeup() {
            long l;
            if (this.state == this.STATE_WAITING_FOR_ACK) {
                long l2 = System.currentTimeMillis() - this.sendTime;
                if (l2 > this.sendTimeoutTime) {
                    PendingWrite pendingWrite;
                    DatagramTransmissionManager.this.datagramManager.wireDebug("DBG:WARNING: It has been too long (" + l2 + ") - packet lost. Resending in " + this.resendWaitTime + " milliseconds. (" + this.numRetries + " try)");
                    this.debug("WARNING: It has been too long (" + l2 + ") - packet lost. Resending in " + this.resendWaitTime + " milliseconds. (" + this.numRetries + " try)");
                    this.state = this.STATE_WAITING_FOR_RESEND;
                    this.resendWaitBeginTime = System.currentTimeMillis();
                    ++this.numRetries;
                    if (this.numRetries == this.NUM_RETRIES_BEFORE_OPENING_SOCKET && !((pendingWrite = (PendingWrite)this.queue.getFirst()).getObject() instanceof DatagramMessage)) {
                        this.debug("Attempting to open a socket... (" + this.numRetries + " try)");
                        LinkedList<SocketTransportMessage> linkedList = new LinkedList<SocketTransportMessage>();
                        Iterator iterator = this.queue.iterator();
                        while (iterator.hasNext()) {
                            PendingWrite pendingWrite2 = (PendingWrite)iterator.next();
                            if (pendingWrite2.getObject() instanceof DatagramMessage) continue;
                            this.handle.wireDebug("DBG:Wait 2 Long" + pendingWrite2.getObject() + " to TCP queue.");
                            this.debug("Moving message " + pendingWrite2.getObject() + " to TCP queue.");
                            linkedList.addLast(new SocketTransportMessage(pendingWrite2.getObject(), pendingWrite2.getDestination()));
                            iterator.remove();
                        }
                        this.state = this.queue.size() > 0 ? this.STATE_READY : this.STATE_NO_DATA;
                        this.handle.connectToRemoteNode(linkedList.iterator());
                    }
                }
                if (this.numRetries >= this.MAX_NUM_RETRIES) {
                    this.debug(DatagramTransmissionManager.this.pastryNode.getNodeId() + " found " + this.nodeId + " to be non-responsive - cancelling message " + this.queue.getFirst());
                    this.queue.removeFirst();
                    this.state = this.STATE_NO_DATA;
                }
            } else if (this.state == this.STATE_WAITING_FOR_RESEND) {
                long l3 = System.currentTimeMillis() - this.resendWaitBeginTime;
                if (l3 > this.resendWaitTime) {
                    this.debug("WARNING: Timeout has completed - resending.");
                    this.state = this.STATE_READY;
                    this.resendWaitTime = (long)((double)this.resendWaitTime * this.TIMEOUT_FACTOR);
                    this.sendTimeoutTime = (long)((double)this.sendTimeoutTime * this.TIMEOUT_FACTOR);
                }
            } else if (this.state == this.STATE_WAITING_TO_SEND && (l = System.currentTimeMillis() - this.resendWaitBeginTime) > this.resendWaitTime) {
                this.state = this.STATE_READY;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToQueue(PendingWrite pendingWrite) {
            Object object = DatagramTransmissionManager.this.killedLock;
            synchronized (object) {
                boolean bl;
                if (DatagramTransmissionManager.this.killed) {
                    Object object2 = pendingWrite.getObject();
                    System.err.println("DTM1: Potentially lost the message:" + object2);
                }
                if (!(pendingWrite.getObject() instanceof DatagramMessage) && (bl = ((Message)pendingWrite.getObject()).hasPriority()) && this.queue.size() > 0) {
                    for (int i = 1; i < this.queue.size(); ++i) {
                        PendingWrite pendingWrite2 = (PendingWrite)this.queue.get(i);
                        if (pendingWrite2.getObject() instanceof DatagramMessage || ((Message)pendingWrite2.getObject()).hasPriority()) continue;
                        this.debug("Prioritizing datagram message " + pendingWrite.getObject() + " over message " + pendingWrite2.getObject());
                        this.queue.add(i, pendingWrite);
                        return;
                    }
                }
                this.queue.addLast(pendingWrite);
            }
        }

        private void debug(String string) {
            if (Log.ifp(8)) {
                System.out.println(DatagramTransmissionManager.this.pastryNode.getNodeId() + " (" + this.nodeId + ") (TE): " + string);
            }
        }
    }
}

