/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import rice.pastry.Log;
import rice.pastry.wire.NeedsWakeUp;
import rice.pastry.wire.SelectionKeyHandler;
import rice.pastry.wire.WirePastryNode;

public class SelectorManager {
    public int SELECT_WAIT_TIME = 100;
    Object selectorLock = new Object();
    Iterator selectorIterator;
    ArrayList needToWakeUp = new ArrayList();
    private Selector selector;
    private WirePastryNode pastryNode;
    private boolean alive = true;

    public SelectorManager(WirePastryNode wirePastryNode) {
        this.pastryNode = wirePastryNode;
        try {
            this.selector = Selector.open();
        }
        catch (IOException iOException) {
            System.out.println("ERROR (SocketClient): Error creating selector " + iOException);
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public boolean isAlive() {
        return this.alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForWakeup(NeedsWakeUp needsWakeUp) {
        ArrayList arrayList = this.needToWakeUp;
        synchronized (arrayList) {
            this.needToWakeUp.add(needsWakeUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterForWakeup(NeedsWakeUp needsWakeUp) {
        ArrayList arrayList = this.needToWakeUp;
        synchronized (arrayList) {
            this.needToWakeUp.remove(needsWakeUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object;
            this.debug("Manager starting...");
            this.selectorIterator = this.selector.selectedKeys().iterator();
            Object[] objectArray = null;
            SelectionKey selectionKey = null;
            Object var3_4 = null;
            boolean bl = false;
            boolean bl2 = false;
            int n = 5;
            while (this.alive) {
                Object object2;
                selectionKey = this.getNextSelectedKey();
                if (selectionKey != null) {
                    object = selectionKey;
                    synchronized (object) {
                        object2 = (SelectionKeyHandler)selectionKey.attachment();
                        if (object2 != null) {
                            if (selectionKey.isValid() && selectionKey.isAcceptable()) {
                                object2.accept(selectionKey);
                            }
                            if (selectionKey.isValid() && selectionKey.isConnectable()) {
                                object2.connect(selectionKey);
                            }
                            if (selectionKey.isValid() && selectionKey.isReadable()) {
                                object2.read(selectionKey);
                            }
                            if (selectionKey.isValid() && selectionKey.isWritable()) {
                                object2.write(selectionKey);
                            }
                        } else {
                            this.debug("Found key witout attachment!");
                        }
                    }
                }
                object = this.needToWakeUp;
                synchronized (object) {
                    object2 = this.needToWakeUp.iterator();
                    while (object2.hasNext()) {
                        NeedsWakeUp needsWakeUp = (NeedsWakeUp)object2.next();
                        needsWakeUp.wakeup();
                    }
                }
            }
            object = this.selectorLock;
            synchronized (object) {
                objectArray = this.selector.keys().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    selectionKey = (SelectionKey)objectArray[i];
                    try {
                        selectionKey.channel().close();
                        selectionKey.cancel();
                        continue;
                    }
                    catch (IOException iOException) {
                        System.err.println("Error Closing socket from " + this.pastryNode + "to " + selectionKey.attachment() + ":" + iOException);
                        iOException.printStackTrace();
                    }
                }
                if (this.selector.isOpen()) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException iOException) {
                        System.out.println("SelectorManager:closing:" + iOException);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("ERROR (run): node:" + this.pastryNode + ":" + throwable);
            throwable.printStackTrace();
        }
    }

    public void kill() {
        this.alive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectionKey getNextSelectedKey() throws IOException {
        Object object = this.selectorLock;
        synchronized (object) {
            if (this.selectorIterator.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)this.selectorIterator.next();
                this.selectorIterator.remove();
                return selectionKey;
            }
            this.selector.select(this.SELECT_WAIT_TIME);
            this.selectorIterator = this.selector.selectedKeys().iterator();
            return null;
        }
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            System.out.println(this.pastryNode.getNodeId() + " (M): " + string);
        }
    }
}

