/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import rice.pastry.Log;
import rice.pastry.wire.SocketChannelWriter;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.exception.DeserializationException;
import rice.pastry.wire.exception.ImproperlyFormattedMessageException;

public class SocketChannelReader {
    private WirePastryNode spn;
    private boolean initialized;
    private int objectSize = -1;
    private ByteBuffer buffer;
    private ByteBuffer sizeBuffer;
    private ByteBuffer magicBuffer;
    protected WireNodeHandle handle;
    protected static byte[] MAGIC_NUMBER = SocketChannelWriter.MAGIC_NUMBER;

    public SocketChannelReader(WirePastryNode wirePastryNode, WireNodeHandle wireNodeHandle) {
        this.spn = wirePastryNode;
        this.initialized = false;
        this.handle = wireNodeHandle;
        this.sizeBuffer = ByteBuffer.allocateDirect(4);
        this.magicBuffer = ByteBuffer.allocateDirect(MAGIC_NUMBER.length);
    }

    public Object read(SocketChannel socketChannel) throws IOException {
        int n;
        if (!this.initialized) {
            n = socketChannel.read(this.magicBuffer);
            if (n == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.magicBuffer.remaining() == 0) {
                this.magicBuffer.flip();
                this.verifyMagicBuffer();
            } else {
                return null;
            }
        }
        if (this.objectSize == -1) {
            n = socketChannel.read(this.sizeBuffer);
            if (n == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.sizeBuffer.remaining() == 0) {
                this.sizeBuffer.flip();
                this.initializeObjectBuffer();
            } else {
                return null;
            }
        }
        if (this.objectSize != -1) {
            n = socketChannel.read(this.buffer);
            this.debug("Read " + n + " bytes of object..." + this.buffer.remaining());
            this.wireDebug("DBG:Read " + n + " bytes of object..." + this.buffer.remaining());
            if (n == -1) {
                throw new IOException("Error on read - the channel has been closed.");
            }
            if (this.buffer.remaining() == 0) {
                this.wireDebug("DBG:buffer.preFlip()" + this.buffer.remaining());
                this.buffer.flip();
                this.wireDebug("DBG:buffer.postFlip()" + this.buffer.remaining());
                byte[] byArray = new byte[this.objectSize];
                this.buffer.get(byArray);
                Object object = this.deserialize(byArray);
                this.debug("Deserialized bytes into object " + object);
                return object;
            }
        }
        return null;
    }

    private void wireDebug(String string) {
        try {
            if (this.handle != null) {
                this.handle.wireDebug(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void reset() {
        this.initialized = false;
        this.objectSize = -1;
        this.buffer = null;
        this.sizeBuffer.clear();
        this.magicBuffer.clear();
    }

    private void verifyMagicBuffer() throws IOException {
        if (this.magicBuffer.remaining() == 4) {
            this.initialized = true;
            byte[] byArray = new byte[4];
            this.magicBuffer.get(byArray, 0, 4);
            if (!Arrays.equals(byArray, MAGIC_NUMBER)) {
                System.out.println("Improperly formatted message received - ignoring.");
                throw new IOException("Improperly formatted message - incorrect magic number.");
            }
        }
    }

    private void initializeObjectBuffer() throws IOException {
        if (this.sizeBuffer.remaining() == 4) {
            byte[] byArray = new byte[4];
            this.sizeBuffer.get(byArray, 0, 4);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.objectSize = dataInputStream.readInt();
            if (this.objectSize <= 0) {
                throw new ImproperlyFormattedMessageException("Found message of improper number of bytes - " + this.objectSize + " bytes");
            }
            this.debug("Found object of " + this.objectSize + " bytes");
            this.buffer = ByteBuffer.allocateDirect(this.objectSize);
        } else {
            this.debug("PANIC: Only " + this.buffer.remaining() + " bytes in buffer - must wait for 4.");
        }
    }

    private Object deserialize(byte[] byArray) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        Object var3_3 = null;
        try {
            this.reset();
            return objectInputStream.readObject();
        }
        catch (ClassCastException classCastException) {
            System.out.println("PANIC: Serialized message was not a pastry message!");
            throw new ImproperlyFormattedMessageException("Message recieved " + var3_3 + " was not a pastry message - closing channel.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("PANIC: Unknown class type in serialized message!");
            throw new ImproperlyFormattedMessageException("Unknown class type in message - closing channel.");
        }
        catch (InvalidClassException invalidClassException) {
            System.out.println("PANIC: Serialized message was an invalid class!");
            throw new DeserializationException("Invalid class in message - closing channel.");
        }
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            if (this.spn == null) {
                System.out.println("(R): " + string);
            } else {
                System.out.println(this.spn.getNodeId() + " (R): " + string);
            }
        }
    }
}

