/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import rice.pastry.Log;
import rice.pastry.messaging.Message;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.exception.NodeIsDeadException;
import rice.pastry.wire.exception.SerializationException;
import rice.pastry.wire.messaging.socket.HelloMessage;
import rice.pastry.wire.messaging.socket.SocketCommandMessage;
import rice.pastry.wire.messaging.socket.SocketTransportMessage;

public class SocketChannelWriter {
    private WirePastryNode pastryNode;
    private ByteBuffer buffer;
    private LinkedList queue;
    private SelectionKey key;
    private boolean waitingForGreeting = false;
    private boolean interestedInWriting = false;
    public static int MAXIMUM_QUEUE_LENGTH = 256;
    protected static byte[] MAGIC_NUMBER = new byte[]{69, 121, 18, 13};
    protected WireNodeHandle handle;
    protected Object pendingMsg = null;

    public SocketChannelWriter(WirePastryNode wirePastryNode, SocketCommandMessage socketCommandMessage, SelectionKey selectionKey) {
        this(wirePastryNode, socketCommandMessage, selectionKey, null);
    }

    public SocketChannelWriter(WirePastryNode wirePastryNode, SocketCommandMessage socketCommandMessage, SelectionKey selectionKey, WireNodeHandle wireNodeHandle) {
        this.pastryNode = wirePastryNode;
        this.key = selectionKey;
        this.handle = wireNodeHandle;
        try {
            this.buffer = SocketChannelWriter.serialize(socketCommandMessage, null);
        }
        catch (IOException iOException) {
            System.out.println("PANIC: Error serializing message " + socketCommandMessage);
        }
        if (socketCommandMessage != null) {
            this.wireDebug("DBG:SCW ctor:" + socketCommandMessage + ":" + this.buffer.remaining());
        } else {
            this.wireDebug("DBG:SCW ctor:" + null + ":" + null);
        }
        this.queue = new LinkedList();
        if (socketCommandMessage != null && socketCommandMessage instanceof HelloMessage) {
            this.waitingForGreeting = true;
        }
        this.updateSelectionKeyBasedOnQueue(true);
    }

    public boolean isInterestedInWriting() {
        return this.interestedInWriting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            return this.buffer == null && (this.queue.size() == 0 || this.waitingForGreeting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getQueue() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            return ((Collection)this.queue.clone()).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.size() < MAXIMUM_QUEUE_LENGTH) {
                this.addToQueue(object);
                this.updateSelectionKeyBasedOnQueue();
            } else {
                System.err.println("Maximum TCP queue length reached - message " + object + " will be dropped.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKey(SelectionKey selectionKey) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.key = selectionKey;
            this.updateSelectionKeyBasedOnQueue(true);
        }
    }

    public int queueSize() {
        return this.queue.size();
    }

    public void reset(SocketCommandMessage socketCommandMessage) {
        try {
            this.buffer = SocketChannelWriter.serialize(socketCommandMessage, this.buffer);
            this.greetingReceived();
        }
        catch (IOException iOException) {
            System.out.println("PANIC: Error serializing message " + socketCommandMessage);
        }
    }

    public void greetingReceived() {
        this.debug("Greeting has been received - acting normally.");
        this.waitingForGreeting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(SocketChannel socketChannel) throws IOException {
        Object var4_4;
        boolean bl;
        IOException iOException;
        block20: {
            block19: {
                block18: {
                    iOException = null;
                    bl = false;
                    var4_4 = null;
                    if (this.queue.size() > 0) {
                        var4_4 = this.queue.getFirst();
                    }
                    try {
                        try {
                            boolean bl2 = false;
                            LinkedList linkedList = this.queue;
                            synchronized (linkedList) {
                                if (this.buffer == null) {
                                    if (this.waitingForGreeting || this.queue.size() <= 0) {
                                        this.updateSelectionKeyBasedOnQueue();
                                        boolean bl3 = true;
                                        // MONITOREXIT @DISABLED, blocks:[0, 16, 17, 1, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var6_7
                                        Object var12_10 = null;
                                        break block18;
                                    }
                                    this.pendingMsg = this.queue.removeFirst();
                                    this.wireDebug("SEN:" + this.pendingMsg.toString());
                                    this.debug("About to serialize object " + this.pendingMsg);
                                    this.buffer = SocketChannelWriter.serialize(this.pendingMsg, null);
                                    bl2 = true;
                                }
                                int n = this.buffer.limit();
                                int n2 = socketChannel.write(this.buffer);
                                this.wireDebug("DBG:" + System.currentTimeMillis() + "Wrote " + n2 + " of " + n + " bytes, buf.remaining():" + this.buffer.remaining());
                                this.debug("Wrote " + n2 + " of " + n + " bytes to " + socketChannel.socket().getRemoteSocketAddress());
                                if (this.buffer.remaining() != 0) {
                                    boolean bl4 = false;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var6_7
                                    break block19;
                                }
                                this.buffer = null;
                                this.pendingMsg = null;
                                bl = this.write(socketChannel);
                                break block20;
                            }
                        }
                        catch (IOException iOException2) {
                            iOException = iOException2;
                            if (this.pendingMsg != null) {
                                System.err.println("SCW3: Potentially lost the message:" + this.pendingMsg);
                            }
                            Object var12_13 = null;
                            Wire.registerSocketChannel(socketChannel, "write:" + var4_4 + " ex:" + iOException);
                            if (iOException != null) {
                                throw iOException;
                            }
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        Wire.registerSocketChannel(socketChannel, "write:" + var4_4 + " ex:" + iOException);
                        if (iOException != null) {
                            throw iOException;
                        }
                        return bl;
                    }
                }
                Wire.registerSocketChannel(socketChannel, "write:" + var4_4 + " ex:" + iOException);
                if (iOException != null) {
                    throw iOException;
                }
                return bl;
            }
            Object var12_11 = null;
            Wire.registerSocketChannel(socketChannel, "write:" + var4_4 + " ex:" + iOException);
            if (iOException != null) {
                throw iOException;
            }
            return bl;
        }
        Object var12_12 = null;
        Wire.registerSocketChannel(socketChannel, "write:" + var4_4 + " ex:" + iOException);
        if (iOException != null) {
            throw iOException;
        }
        return bl;
    }

    private void wireDebug(String string) {
        try {
            if (this.handle != null) {
                this.handle.wireDebug(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void addToQueue(Object object) {
        boolean bl;
        this.wireDebug("DBG:addToQueue(" + object + ")");
        if (object instanceof SocketTransportMessage && (bl = ((Message)((SocketTransportMessage)object).getObject()).hasPriority()) && this.queue.size() > 0) {
            for (int i = 1; i < this.queue.size(); ++i) {
                Object e = this.queue.get(i);
                if (!(e instanceof SocketTransportMessage) || ((Message)((SocketTransportMessage)e).getObject()).hasPriority()) continue;
                this.debug("Prioritizing socket message " + object + " over message " + e);
                this.queue.add(i, object);
                return;
            }
        }
        this.queue.addLast(object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateSelectionKeyBasedOnQueue() {
        this.updateSelectionKeyBasedOnQueue(false);
        try {
            if (this.key == null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSelectionKeyBasedOnQueue(boolean bl) {
        if (this.buffer == null && this.queue.size() == 0) {
            if (this.interestedInWriting || bl) {
                this.enableWrite(false);
            }
        } else if (!this.interestedInWriting || bl) {
            this.enableWrite(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWrite(boolean bl) {
        if (this.key == null) {
            return;
        }
        if (bl) {
            try {
                Selector selector;
                Selector selector2 = selector = this.key.selector();
                synchronized (selector2) {
                    this.key.interestOps(this.key.interestOps() | 4);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                SelectorManager selectorManager = this.pastryNode.getSelectorManager();
                if (!selectorManager.isAlive()) {
                    this.notifyKilled();
                    throw new NodeIsDeadException(cancelledKeyException);
                }
                WireNodeHandle wireNodeHandle = (WireNodeHandle)this.key.attachment();
                wireNodeHandle.closeDueToError();
            }
        } else {
            Selector selector;
            Selector selector3 = selector = this.key.selector();
            synchronized (selector3) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
        }
        this.interestedInWriting = bl;
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            if (this.pastryNode == null) {
                System.out.println("(W): " + string);
            } else {
                System.out.println(this.pastryNode.getNodeId() + " (W): " + string);
            }
        }
    }

    public static ByteBuffer serialize(Object object, ByteBuffer byteBuffer) throws IOException {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            int n = byteArrayOutputStream.toByteArray().length;
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream2);
            dataOutputStream.write(MAGIC_NUMBER);
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            dataOutputStream.write(byteArrayOutputStream.toByteArray());
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            if (byteBuffer != null) {
                byteBuffer.rewind();
                byte[] byArray2 = byteBuffer.array();
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                byArray = byArray3;
            }
            return ByteBuffer.wrap(byArray);
        }
        catch (InvalidClassException invalidClassException) {
            System.out.println("PANIC: Object to be serialized was an invalid class!");
            throw new SerializationException("Invalid class during attempt to serialize.");
        }
        catch (NotSerializableException notSerializableException) {
            System.out.println("PANIC: Object to be serialized was not serializable! [" + object + "]");
            throw new SerializationException("Unserializable class during attempt to serialize.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKilled() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.pendingMsg != null) {
                System.err.println("SCW2: Potentially lost the message:" + this.pendingMsg);
            }
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                System.err.println("SCW: Potentially lost the message:" + e);
            }
        }
    }
}

