/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.LinkedList;
import rice.pastry.Log;
import rice.pastry.NodeName;
import rice.pastry.wire.SelectionKeyHandler;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.SocketChannelReader;
import rice.pastry.wire.SocketChannelWriter;
import rice.pastry.wire.StaleSKH;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WireNodeHandlePool;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.messaging.socket.HelloMessage;
import rice.pastry.wire.messaging.socket.LeafSetRequestMessage;
import rice.pastry.wire.messaging.socket.LeafSetResponseMessage;
import rice.pastry.wire.messaging.socket.NodeIdRequestMessage;
import rice.pastry.wire.messaging.socket.NodeIdResponseMessage;
import rice.pastry.wire.messaging.socket.RouteRowRequestMessage;
import rice.pastry.wire.messaging.socket.RouteRowResponseMessage;

public class SocketManager
implements SelectionKeyHandler {
    private WirePastryNode pastryNode;
    protected LinkedList openSockets;
    private HashMap connectors;
    private ServerSocketChannel serverChannel;
    private SelectionKey serverKey;
    private int port;
    public static int MAX_OPEN_SOCKETS = 256;
    transient PrintStream outputStream = null;

    public SocketManager(WirePastryNode wirePastryNode, int n, Selector selector) {
        this.pastryNode = wirePastryNode;
        this.wireDebug("DBG:SM ctor 1");
        this.openSockets = this.generateOpenSockets();
        this.connectors = new HashMap();
        this.port = n;
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost(), n);
            this.serverChannel = ServerSocketChannel.open();
            this.serverChannel.configureBlocking(false);
            this.serverChannel.socket().bind(inetSocketAddress);
            this.serverKey = this.serverChannel.register(selector, 16);
            this.serverKey.attach(this);
        }
        catch (IOException iOException) {
            System.out.println("ERROR creating server socket channel " + iOException);
            this.wireDebug("DBG:SM ctor failure");
        }
        this.wireDebug("DBG:SM ctor 2");
    }

    protected LinkedList generateOpenSockets() {
        return new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openSocket(WireNodeHandle wireNodeHandle) {
        LinkedList linkedList = this.openSockets;
        synchronized (linkedList) {
            if (!this.openSockets.contains(wireNodeHandle)) {
                this.removeOpenSocketsIfNeeded();
                this.openSockets.addFirst(wireNodeHandle);
                this.debug("Got request to open socket to " + wireNodeHandle);
            } else {
                this.debug("ERROR: Request to open already-open socket to " + wireNodeHandle.getAddress());
            }
        }
    }

    protected void removeOpenSocketsIfNeeded() {
        while (this.needToDisconnectSockets() && this.openSockets.size() > 0) {
            WireNodeHandle wireNodeHandle = (WireNodeHandle)this.openSockets.removeLast();
            System.out.println("Removing Open Soket because needed. :" + wireNodeHandle.getAddress());
            wireNodeHandle.disconnect();
        }
    }

    protected boolean needToDisconnectSockets() {
        return this.openSockets.size() > MAX_OPEN_SOCKETS;
    }

    public void closeSocket(WireNodeHandle wireNodeHandle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(WireNodeHandle wireNodeHandle) {
        LinkedList linkedList = this.openSockets;
        synchronized (linkedList) {
            if (this.openSockets.contains(wireNodeHandle)) {
                this.openSockets.remove(wireNodeHandle);
                this.openSockets.addFirst(wireNodeHandle);
            } else {
                System.out.println("ERROR: Request to update non-open socket to " + wireNodeHandle.getAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(SelectionKey selectionKey) {
        try {
            Selector selector;
            SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
            socketChannel.socket().setSendBufferSize(WireNodeHandle.SOCKET_BUFFER_SIZE);
            socketChannel.socket().setReceiveBufferSize(WireNodeHandle.SOCKET_BUFFER_SIZE);
            socketChannel.configureBlocking(false);
            this.wireDebug("DBG:" + System.currentTimeMillis() + ":accept(" + socketChannel.socket().getRemoteSocketAddress() + ")");
            Selector selector2 = selector = this.pastryNode.getSelectorManager().getSelector();
            synchronized (selector2) {
                SelectionKey selectionKey2 = socketChannel.register(selector, 1);
                this.debug("Accepted connection from " + socketChannel.socket().getRemoteSocketAddress());
                selectionKey2.attach(this);
                this.connectors.put(selectionKey2, new SocketConnector(selectionKey2));
            }
        }
        catch (IOException iOException) {
            System.out.println("ERROR (accepting connection): " + iOException);
            this.wireDebug("DBG:error during accept()");
        }
    }

    public void read(SelectionKey selectionKey) {
        this.wireDebug("DBG:" + System.currentTimeMillis() + ":read()");
        SocketConnector socketConnector = (SocketConnector)this.connectors.get(selectionKey);
        this.debug("Found data to be read from " + ((SocketChannel)selectionKey.channel()).socket().getRemoteSocketAddress());
        try {
            socketConnector.read();
        }
        catch (IOException iOException) {
            this.wireDebug("DBG:exception:" + this.serverKey + "," + selectionKey + "," + iOException);
            this.debug("ERROR " + iOException + " reading connnector - cancelling.");
            this.connectors.remove(selectionKey);
            try {
                selectionKey.channel().close();
            }
            catch (IOException iOException2) {
                System.out.println("ERROR " + iOException2 + " occured while closing socket.");
            }
            selectionKey.cancel();
        }
    }

    public void write(SelectionKey selectionKey) {
        SocketConnector socketConnector = (SocketConnector)this.connectors.get(selectionKey);
        this.debug("Found channel ready for data to " + ((SocketChannel)selectionKey.channel()).socket().getRemoteSocketAddress());
        try {
            socketConnector.write();
        }
        catch (IOException iOException) {
            this.debug("ERROR " + iOException + " writing connnector - cancelling.");
            this.connectors.remove(selectionKey);
            try {
                selectionKey.channel().close();
            }
            catch (IOException iOException2) {
                System.out.println("ERROR " + iOException2 + " occured while closing socket.");
            }
            selectionKey.cancel();
        }
    }

    public void connect(SelectionKey selectionKey) {
        System.out.println("PANIC: connect() called on SocketManager!");
    }

    public void wakeup() {
    }

    private void debug(String string) {
        if (Log.ifp(8)) {
            System.out.println(this.pastryNode.getNodeId() + " (SM): " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wireDebug(String string) {
        if (!Wire.outputDebug) {
            return;
        }
        Object object = Wire.outputStreamLock;
        synchronized (object) {
            try {
                if (this.outputStream == null) {
                    String string2 = null;
                    if (this.pastryNode != null) {
                        string2 = this.pastryNode.getId().toString();
                    }
                    String string3 = "SM " + string2 + ".txt";
                    this.outputStream = new PrintStream(new FileOutputStream(string3));
                }
                this.outputStream.println(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private class SocketConnector {
        private SelectionKey key;
        private SocketChannelReader reader;
        private SocketChannelWriter writer;

        public SocketConnector(SelectionKey selectionKey) {
            this.key = selectionKey;
            this.reader = new SocketChannelReader(SocketManager.this.pastryNode, null);
        }

        public void read() throws IOException {
            Object object = this.reader.read((SocketChannel)this.key.channel());
            SocketManager.this.wireDebug("DBG:sc:read(" + object + ")");
            if (object != null) {
                if (object instanceof HelloMessage) {
                    HelloMessage helloMessage = (HelloMessage)object;
                    SocketManager.this.wireDebug("DBG:read(" + helloMessage + ")");
                    this.debug("Read header message " + helloMessage);
                    if (helloMessage.getDestination().equals(SocketManager.this.pastryNode.getNodeId())) {
                        WireNodeHandle wireNodeHandle = ((WireNodeHandlePool)SocketManager.this.pastryNode.getNodeHandlePool()).get(helloMessage.getNodeId());
                        if (wireNodeHandle == null) {
                            wireNodeHandle = new WireNodeHandle(helloMessage.getAddress(), helloMessage.getNodeId(), SocketManager.this.pastryNode);
                            wireNodeHandle.setNodeName(new NodeName(helloMessage.getName()));
                            wireNodeHandle = (WireNodeHandle)SocketManager.this.pastryNode.getNodeHandlePool().coalesce(wireNodeHandle);
                        }
                        wireNodeHandle.setKey(this.key, helloMessage.getResponse(SocketManager.this.pastryNode));
                    } else {
                        this.debug("Found socket for wrong nodeId " + helloMessage.getDestination() + " at " + SocketManager.this.pastryNode.getNodeId() + " - killing.");
                        this.key.interestOps(0);
                        this.key.channel().close();
                        this.key.cancel();
                    }
                    SocketManager.this.connectors.remove(this.key);
                } else if (object instanceof NodeIdRequestMessage) {
                    this.debug("Read nodeId request message " + object);
                    this.writer = new SocketChannelWriter(SocketManager.this.pastryNode, null, this.key);
                    this.writer.enqueue(new NodeIdResponseMessage(SocketManager.this.pastryNode.getNodeId(), SocketManager.this.pastryNode.getLocalHandle().getNodeName().toString()));
                } else if (object instanceof LeafSetRequestMessage) {
                    this.debug("Read leafset request message " + object);
                    this.writer = new SocketChannelWriter(SocketManager.this.pastryNode, null, this.key);
                    this.writer.enqueue(new LeafSetResponseMessage(SocketManager.this.pastryNode.getLeafSet()));
                } else if (object instanceof RouteRowRequestMessage) {
                    this.debug("Read route row request message " + object);
                    RouteRowRequestMessage routeRowRequestMessage = (RouteRowRequestMessage)object;
                    this.writer = new SocketChannelWriter(SocketManager.this.pastryNode, null, this.key);
                    this.writer.enqueue(new RouteRowResponseMessage(SocketManager.this.pastryNode.getRoutingTable().getRow(routeRowRequestMessage.getRow())));
                } else {
                    System.out.println("Read unknown message " + object + " - dropping on floor.");
                }
            }
        }

        public void write() throws IOException {
            boolean bl = this.writer.write((SocketChannel)this.key.channel());
            if (bl) {
                this.enableWrite(false);
                SocketManager.this.connectors.remove(this.key);
                this.key.attach(new StaleSKH());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enableWrite(boolean bl) {
            Selector selector;
            if (bl) {
                Selector selector2;
                SelectorManager selectorManager = SocketManager.this.pastryNode.getSelectorManager();
                Selector selector3 = selector2 = selectorManager.getSelector();
                synchronized (selector3) {
                    this.key.interestOps(this.key.interestOps() | 4);
                }
            }
            SelectorManager selectorManager = SocketManager.this.pastryNode.getSelectorManager();
            Selector selector4 = selector = selectorManager.getSelector();
            synchronized (selector4) {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
        }

        private void debug(String string) {
            if (Log.ifp(8)) {
                System.out.println(SocketManager.this.pastryNode.getNodeId() + " (SC): " + string);
            }
        }
    }
}

