/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.File;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import rice.pastry.wire.GlobalSocketManager;
import rice.pastry.wire.WireLimitatioinListener;

public class Wire {
    private static boolean initialized = false;
    private static int numAllowedFileDescriptors = 0;
    private static int numUsedFileDescriptors = 0;
    private static int numFDsPendingRelease = 0;
    private static float softFractionOfDescriptorsToUse = 0.5f;
    private static float notifyFractionOfDescriptorsToUse = 0.6f;
    private static ArrayList wireLimitationListeners = new ArrayList();
    private boolean unlimited = false;
    private static int oneOfs = 0;
    private static int oneOfsCalled = 0;
    private static int pendingsCalled = 0;
    static boolean outputDebug = false;
    static Object outputStreamLock = new Object();
    private static ArrayList socketChannels = new ArrayList();
    private static ArrayList reasons = new ArrayList();
    private static boolean scThreadStarted = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        numAllowedFileDescriptors = 200;
        initialized = true;
    }

    public static void initialize(int n) {
        if (initialized) {
            return;
        }
        numAllowedFileDescriptors = n;
        initialized = true;
    }

    public static void initialize(int n, float f, float f2) {
        if (initialized) {
            return;
        }
        numAllowedFileDescriptors = n;
        softFractionOfDescriptorsToUse = f;
        notifyFractionOfDescriptorsToUse = f2;
        initialized = true;
    }

    public static void initialize(float f, float f2) {
        if (!initialized) {
            Wire.initialize();
            softFractionOfDescriptorsToUse = f;
            notifyFractionOfDescriptorsToUse = f2;
        }
    }

    private static void assertInitialized() {
        if (initialized) {
            return;
        }
        System.out.println("WARNING Wire was not properly initialized.");
        Wire.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWireLimitationListener(WireLimitatioinListener wireLimitatioinListener) {
        Wire.assertInitialized();
        ArrayList arrayList = wireLimitationListeners;
        synchronized (arrayList) {
            wireLimitationListeners.add(wireLimitatioinListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWireLimitationListener(WireLimitatioinListener wireLimitatioinListener) {
        Wire.assertInitialized();
        ArrayList arrayList = wireLimitationListeners;
        synchronized (arrayList) {
            wireLimitationListeners.remove(wireLimitatioinListener);
        }
    }

    private static int getSoftLimit() {
        return (int)((float)numAllowedFileDescriptors * softFractionOfDescriptorsToUse);
    }

    private static int getNotifyLimit() {
        return (int)((float)numAllowedFileDescriptors * notifyFractionOfDescriptorsToUse);
    }

    public static synchronized void acquireFileDescriptor() {
    }

    public static synchronized void releaseFileDescriptor() {
    }

    public static synchronized void acquireFileDescriptors(int n) {
    }

    public static synchronized void releaseFileDescriptors(int n) {
    }

    public static synchronized void releaseingFileDescriptor() {
    }

    public static synchronized void doneReleaseingFileDescriptor() {
    }

    public static boolean needToReleaseFDs() {
        return Wire.getSoftLimit() <= numUsedFileDescriptors + numFDsPendingRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyWireListenersOfOverflow() {
        ArrayList arrayList = wireLimitationListeners;
        synchronized (arrayList) {
            if (wireLimitationListeners.size() > 0) {
                Iterator iterator = wireLimitationListeners.iterator();
                while (iterator.hasNext()) {
                    WireLimitatioinListener wireLimitatioinListener = (WireLimitatioinListener)iterator.next();
                    wireLimitatioinListener.resourcesRunningShort(numUsedFileDescriptors, numAllowedFileDescriptors);
                }
            } else {
                System.err.println("WARNING: running low on File Descriptors used:" + numUsedFileDescriptors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyWireListenersOfStatusFine() {
        ArrayList arrayList = wireLimitationListeners;
        synchronized (arrayList) {
            Iterator iterator = wireLimitationListeners.iterator();
            while (iterator.hasNext()) {
                WireLimitatioinListener wireLimitatioinListener = (WireLimitatioinListener)iterator.next();
                wireLimitatioinListener.resourcesFine(numUsedFileDescriptors, numAllowedFileDescriptors);
            }
        }
    }

    public static int getNumFDsUsed() throws IOException {
        File file = new File("/dev/fd").getCanonicalFile();
        File[] fileArray = file.listFiles();
        return fileArray.length;
    }

    public static synchronized void printStatus() {
        int n = -1;
        try {
            n = Wire.getNumFDsUsed();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("actual files used:" + n + " acquired:" + numUsedFileDescriptors + " oneOfs:" + oneOfs + " openSocks:" + GlobalSocketManager.openSocks.size() + " oneOfsCalled:" + oneOfsCalled);
    }

    public static void registerSocketChannel(SocketChannel socketChannel, String string) {
    }

    static /* synthetic */ ArrayList access$000() {
        return socketChannels;
    }

    static /* synthetic */ ArrayList access$100() {
        return reasons;
    }
}

