/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import rice.pastry.AML.DHTAMLInterface;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistCoalesedNodeHandle;
import rice.pastry.messaging.Message;
import rice.pastry.routing.RouteMessage;
import rice.pastry.wire.DatagramManager;
import rice.pastry.wire.SelectionKeyHandler;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.SocketChannelReader;
import rice.pastry.wire.SocketChannelWriter;
import rice.pastry.wire.StaleSKH;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.exception.DeserializationException;
import rice.pastry.wire.exception.ImproperlyFormattedMessageException;
import rice.pastry.wire.exception.NodeIsDeadException;
import rice.pastry.wire.messaging.datagram.PingMessage;
import rice.pastry.wire.messaging.socket.DisconnectMessage;
import rice.pastry.wire.messaging.socket.HelloMessage;
import rice.pastry.wire.messaging.socket.HelloResponseMessage;
import rice.pastry.wire.messaging.socket.SocketCommandMessage;
import rice.pastry.wire.messaging.socket.SocketTransportMessage;

public class WireNodeHandle
extends DistCoalesedNodeHandle
implements SelectionKeyHandler {
    private transient long lastpingtime;
    private transient SocketChannelReader reader;
    private transient SocketChannelWriter writer;
    private transient SelectionKey key;
    private transient int state;
    public static final int STATE_USING_UDP = -1;
    public static final int STATE_USING_TCP = -2;
    public static final int STATE_USING_UDP_WAITING_FOR_TCP_DISCONNECT = -3;
    public static final int STATE_USING_UDP_WAITING_TO_DISCONNECT = -4;
    public static int MAX_UDP_MESSAGE_SIZE = DatagramManager.DATAGRAM_SEND_BUFFER_SIZE;
    public static int SOCKET_BUFFER_SIZE = 32768;
    public static int PING_THROTTLE = 5;
    transient int writeCtr = 0;
    transient long writeTmr = 0L;
    transient PrintStream outputStream = null;

    public WireNodeHandle(InetSocketAddress inetSocketAddress, NodeId nodeId) {
        super(nodeId, inetSocketAddress);
        this.debug("creating Socket handle for node: " + nodeId + " address: " + inetSocketAddress);
        this.lastpingtime = 0L;
        this.setState(-1, "ctor");
    }

    public WireNodeHandle(InetSocketAddress inetSocketAddress, NodeId nodeId, PastryNode pastryNode) {
        super(nodeId, inetSocketAddress);
        this.debug("creating Socket handle for node: " + nodeId + ", local: " + pastryNode + " address: " + inetSocketAddress);
        this.lastpingtime = 0L;
        this.setState(-1, "ctor");
        this.setLocalNode(pastryNode);
    }

    public int getState() {
        return this.state;
    }

    public boolean isWriteEnabled() {
        return (this.key.interestOps() & 4) != 0;
    }

    public synchronized void setKey(SelectionKey selectionKey, SocketCommandMessage socketCommandMessage) {
        this.debug("Got new key  (state == " + this.state + ")");
        if (this.state == -1) {
            this.key = selectionKey;
            selectionKey.attach(this);
            ((WirePastryNode)this.getLocalNode()).getSocketManager().openSocket(this);
            this.reader = new SocketChannelReader((WirePastryNode)this.getLocalNode(), this);
            this.writer = new SocketChannelWriter((WirePastryNode)this.getLocalNode(), socketCommandMessage, selectionKey, this);
            this.setState(-2, "setKey1:" + System.currentTimeMillis() + ":" + socketCommandMessage + "," + selectionKey.interestOps() + "," + selectionKey.channel());
        } else {
            this.markAlive();
            InetSocketAddress inetSocketAddress = ((WireNodeHandle)this.getLocalNode().getLocalHandle()).getAddress();
            InetSocketAddress inetSocketAddress2 = this.getAddress();
            this.debug("Found double socket... (state == " + this.state + ")");
            if (this.state != -2) {
                ((WirePastryNode)this.getLocalNode()).getSocketManager().openSocket(this);
            }
            if (this.getAddress(inetSocketAddress.getAddress()) > this.getAddress(inetSocketAddress2.getAddress()) || this.getAddress(inetSocketAddress.getAddress()) == this.getAddress(inetSocketAddress2.getAddress()) && inetSocketAddress.getPort() > inetSocketAddress2.getPort()) {
                try {
                    this.key.channel().close();
                    this.key.cancel();
                    this.key.attach(null);
                    this.writer.reset(socketCommandMessage);
                }
                catch (IOException iOException) {
                    System.out.println("ERROR closing unnecessary socket: " + iOException);
                }
                this.writer.setKey(selectionKey);
                this.key = selectionKey;
                this.setState(-2, "setKey2a:" + socketCommandMessage);
                selectionKey.attach(this);
                this.debug("Killing our socket, using new one...");
            } else {
                this.wireDebug("setKey2b:" + socketCommandMessage);
                selectionKey.attach(new StaleSKH());
                this.debug("Using our socket, letting other socket die...");
            }
        }
    }

    public void receiveSocketMessage(SocketCommandMessage socketCommandMessage) {
        if (socketCommandMessage instanceof DisconnectMessage) {
            this.debug("Received DisconnectMessage (state == " + this.state + ")");
            if (this.state == -2) {
                this.setState(-4, "recSockMsg");
                ((WirePastryNode)this.getLocalNode()).getSocketManager().closeSocket(this);
            } else if (this.state == -3) {
                this.close(null);
            } else {
                System.out.println("Recieved DisconnectMessage at non-connected socket - not fatal... (state == " + this.state + ")");
            }
        } else if (socketCommandMessage instanceof HelloResponseMessage) {
            HelloResponseMessage helloResponseMessage = (HelloResponseMessage)socketCommandMessage;
            if (helloResponseMessage.getNodeId().equals(this.getNodeId()) && helloResponseMessage.getDestination().equals(this.getLocalNode().getNodeId())) {
                this.markAlive();
                this.writer.greetingReceived();
            } else {
                this.debug("Receved incorrect HelloMessageResponse for nodeId " + helloResponseMessage.getNodeId() + " - resetting.");
                this.close(null);
            }
        } else {
            System.out.println("Received unreconginzed SocketCommandMessage " + socketCommandMessage + " - dropping on floor");
        }
    }

    public void notifyKilled() {
        SocketChannelWriter socketChannelWriter = this.writer;
        if (socketChannelWriter != null) {
            this.writer.notifyKilled();
        }
    }

    public void receiveMessageImpl(Message message) {
        this.assertLocalNode();
        WirePastryNode wirePastryNode = (WirePastryNode)this.getLocalNode();
        if (this.isLocal) {
            this.debug("Sending message " + message + " locally");
            wirePastryNode.receiveMessage(message);
        } else {
            Object object;
            this.debug("Passing message " + message + " to the socket controller for writing (state == " + this.state + ")");
            this.wireDebug("ENQ:" + message);
            String string = null;
            if (this.writer != null) {
                string = "" + this.writer.queueSize();
            }
            try {
                String string2 = null;
                if (this.key != null) {
                    string2 = "" + this.key.interestOps();
                }
                this.wireDebug("DBG:" + string + "," + string2);
            }
            catch (CancelledKeyException cancelledKeyException) {
                object = ((WirePastryNode)this.getLocalNode()).getSelectorManager();
                if (!((SelectorManager)object).isAlive()) {
                    Iterator iterator;
                    SocketChannelWriter socketChannelWriter = this.writer;
                    if (this.writer != null && (iterator = this.writer.getQueue()) != null) {
                        this.notifyPotentiallyLostMessage(iterator);
                    }
                    throw new NodeIsDeadException(cancelledKeyException);
                }
                this.closeDueToError();
            }
            int n = 0;
            try {
                n = this.messageSize(message);
                if (message.getDestination().equals(DHTAMLInterface.addr) && Log.ifp(5)) {
                    System.out.println("MsgStats: Sending message of size " + n + " " + new Date().getTime());
                }
            }
            catch (IOException iOException) {
                System.out.println("IOException serializing message " + message + " - cancelling message.");
                iOException.printStackTrace();
            }
            switch (this.state) {
                case -2: {
                    this.writer.enqueue(new SocketTransportMessage(message, this.nodeId));
                    break;
                }
                case -1: {
                    if (n <= MAX_UDP_MESSAGE_SIZE) {
                        this.debug("Message is small enough to go over UDP - sending.");
                        ((WirePastryNode)this.getLocalNode()).getDatagramManager().write(this.nodeId, this.address, message);
                        break;
                    }
                    this.debug("Message is too large - open up socket!");
                    object = new LinkedList();
                    ((LinkedList)object).addFirst(new SocketTransportMessage(message, this.nodeId));
                    this.connectToRemoteNode(((AbstractSequentialList)object).iterator());
                    break;
                }
                default: {
                    ((WirePastryNode)this.getLocalNode()).getDatagramManager().write(this.nodeId, this.address, message);
                }
            }
        }
    }

    public void notifyPotentiallyLostMessage(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            System.err.println("WNH: Potentially lost the message:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectToRemoteNode(Iterator iterator) {
        if (this.state == -1) {
            try {
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.socket().setSendBufferSize(SOCKET_BUFFER_SIZE);
                socketChannel.socket().setReceiveBufferSize(SOCKET_BUFFER_SIZE);
                socketChannel.configureBlocking(false);
                boolean bl = socketChannel.connect(this.address);
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.socket().getLocalSocketAddress();
                this.wireDebug("DBG:Opening socket to " + this.address + " from:" + inetSocketAddress);
                this.debug("Opening socket to " + this.address + " from:" + inetSocketAddress);
                SelectorManager selectorManager = ((WirePastryNode)this.getLocalNode()).getSelectorManager();
                Selector selector = selectorManager.getSelector();
                Object object = selector;
                synchronized (object) {
                    if (bl) {
                        this.key = socketChannel.register(selector, 1);
                    } else {
                        try {
                            this.key = socketChannel.register(selector, 9);
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!selectorManager.isAlive()) {
                                if (iterator == null) throw new NodeIsDeadException(nullPointerException);
                                this.notifyPotentiallyLostMessage(iterator);
                                throw new NodeIsDeadException(nullPointerException);
                            }
                            if (iterator == null) throw nullPointerException;
                            this.notifyPotentiallyLostMessage(iterator);
                            throw nullPointerException;
                        }
                    }
                }
                this.setKey(this.key, new HelloMessage((WirePastryNode)this.getLocalNode(), this.nodeId));
                if (iterator == null) return;
                object = iterator;
                while (object.hasNext()) {
                    Object e = object.next();
                    this.debug("Enqueueing message " + e + " into socket channel writer.");
                    this.writer.enqueue(e);
                }
                return;
            }
            catch (IOException iOException) {
                this.debug("IOException connecting to remote node " + this.address);
                iOException.printStackTrace();
                System.out.println("WireNodeHandle.connectToRemoteNode(): IOException connecting to remote node " + this.address);
                this.setState(-2, "connToRemoteNode, exception");
                this.close(iterator);
                return;
            }
        }
        if (iterator == null) return;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            this.debug("Enqueueing message " + e + " into socket channel writer.");
            this.writer.enqueue(e);
        }
    }

    public synchronized void disconnect() {
        this.debug("Received disconnect request... (state == " + this.state + ")");
        if (this.state == -2) {
            this.setState(-3, "disconnect()");
            this.writer.enqueue(new DisconnectMessage());
        } else {
            System.out.println("Recieved disconnect request at non-connected socket - very bad... (state == " + this.state + ")");
        }
    }

    public void accept(SelectionKey selectionKey) {
        System.out.println("PANIC: accept() called on WireNodeHandle!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SelectionKey selectionKey) {
        this.wireDebug("DBG:connect()");
        try {
            if (((SocketChannel)selectionKey.channel()).finishConnect()) {
                Selector selector;
                SelectorManager selectorManager = ((WirePastryNode)this.getLocalNode()).getSelectorManager();
                Selector selector2 = selector = selectorManager.getSelector();
                synchronized (selector2) {
                    selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
                }
            }
            this.debug("Found connectable channel - completed connection to " + this.address);
        }
        catch (ConnectException connectException) {
            this.debug("ERROR connecting - cancelling. " + connectException);
            this.close(this.writer.getQueue());
        }
        catch (SocketException socketException) {
            this.debug("ERROR connecting - cancelling. " + socketException);
            this.close(this.writer.getQueue());
        }
        catch (IOException iOException) {
            this.debug("ERROR connecting - cancelling. " + iOException);
            this.close(this.writer.getQueue());
        }
    }

    public void write(SelectionKey selectionKey) {
        ++this.writeCtr;
        long l = System.currentTimeMillis();
        if (l - this.writeTmr > 1000L) {
            this.writeTmr = l;
            this.wireDebug("DBG:write():" + this.writeCtr + ":" + selectionKey.interestOps());
        }
        if (this.state == -2) {
            ((WirePastryNode)this.getLocalNode()).getSocketManager().update(this);
        }
        try {
            if (this.writer.write((SocketChannel)selectionKey.channel()) && this.state == -4) {
                this.close(null);
            }
        }
        catch (IOException iOException) {
            this.debug("ERROR writing - cancelling. " + iOException);
            this.close(this.writer.getQueue());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wireDebug(String string) {
        if (!Wire.outputDebug) {
            return;
        }
        Object object = Wire.outputStreamLock;
        synchronized (object) {
            try {
                if (this.outputStream == null) {
                    String string2 = null;
                    if (this.localnode == null) {
                        return;
                    }
                    string2 = this.localnode.getId().toString();
                    String string3 = "WNH " + string2 + "->" + this.getNodeId().toString() + ".txt";
                    this.outputStream = new PrintStream(new FileOutputStream(string3));
                }
                this.outputStream.println(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void read(SelectionKey selectionKey) {
        this.wireDebug("DBG:read()");
        if (this.state == -2) {
            ((WirePastryNode)this.getLocalNode()).getSocketManager().update(this);
        }
        SocketChannelReader socketChannelReader = this.reader;
        SocketChannelWriter socketChannelWriter = this.writer;
        if (socketChannelReader != null && socketChannelWriter != null) {
            try {
                Object object = null;
                while ((object = socketChannelReader.read((SocketChannel)selectionKey.channel())) != null) {
                    if (object == null) continue;
                    if (object instanceof SocketCommandMessage) {
                        this.debug("Read socket message " + object + " - passing to node handle.");
                        this.receiveSocketMessage((SocketCommandMessage)object);
                        continue;
                    }
                    if (object instanceof SocketTransportMessage) {
                        SocketTransportMessage socketTransportMessage = (SocketTransportMessage)object;
                        if (socketTransportMessage.getDestination().equals(this.getLocalNode().getNodeId())) {
                            this.debug("Read message " + object + " - passing to pastry node.");
                            this.wireDebug("DBG:" + System.identityHashCode(socketTransportMessage.getObject()) + "," + socketTransportMessage.getObject());
                            this.wireDebug("REC:" + socketTransportMessage.getObject());
                            this.getLocalNode().receiveMessage((Message)socketTransportMessage.getObject());
                            continue;
                        }
                        this.debug("Read message " + object + " at " + this.nodeId + " for wrong nodeId " + socketTransportMessage.getDestination() + " - killing connection.");
                        throw new IOException("Incoming message was for incorrect node id.");
                    }
                    throw new IllegalArgumentException("Message " + object + " was not correctly wrapped.");
                }
            }
            catch (ImproperlyFormattedMessageException improperlyFormattedMessageException) {
                System.out.println("Improperly formatted message found during parsing - ignoring message... " + improperlyFormattedMessageException);
                socketChannelReader.reset();
            }
            catch (DeserializationException deserializationException) {
                System.out.println("An error occured during message deserialization - ignoring message...");
                socketChannelReader.reset();
            }
            catch (IOException iOException) {
                this.debug("Error occurred during reading from " + this.address + " at " + this.getNodeId() + " - closing socket. " + iOException);
                this.close(socketChannelWriter.getQueue());
            }
        }
    }

    public boolean pingImpl() {
        if (this.isLocal) {
            this.setProximity(0);
            return this.alive;
        }
        if (this.getLocalNode() != null && ((WireNodeHandle)this.getLocalNode().getLocalHandle()).getAddress().getAddress().equals(this.address.getAddress())) {
            this.setProximity(1);
            return this.alive;
        }
        if (this.getLocalNode() != null) {
            long l = System.currentTimeMillis();
            if (l - this.lastpingtime < (long)(PING_THROTTLE * 1000)) {
                return this.alive;
            }
            this.lastpingtime = l;
            ((WirePastryNode)this.getLocalNode()).getDatagramManager().write(this.nodeId, this.address, new PingMessage(this.getLocalNode().getNodeId(), this.nodeId, 0, this));
        }
        return this.alive;
    }

    public void pingStarted() {
        this.lastpingtime = System.currentTimeMillis();
    }

    public void pingResponse() {
        if (this.isLocal) {
            this.debug("ERROR (pingResponse): Ping should never be sent to local node...");
            return;
        }
        long l = System.currentTimeMillis();
        if (this.proximity() > (int)(l - this.lastpingtime)) {
            this.setProximity((int)(l - this.lastpingtime));
        }
        this.markAlive();
    }

    public String toStringImpl() {
        return "[" + this.nodeId + " (" + this.address.getAddress().getHostAddress() + ":" + this.address.getPort() + ") on " + this.localnode + "]";
    }

    private int getAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        int n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
        return n;
    }

    private void setState(int n, String string) {
        if (this.state == -1 && n == -2) {
            Wire.acquireFileDescriptor();
        }
        if (n == -1 && this.state == -2) {
            Wire.releaseFileDescriptor();
        }
        if (n == -3 && this.state == -2) {
            Wire.releaseingFileDescriptor();
        }
        if (n == -1 && this.state == -3) {
            Wire.doneReleaseingFileDescriptor();
        }
        this.state = n;
        String string2 = "unknown";
        switch (n) {
            case -2: {
                string2 = "USING_TCP";
                break;
            }
            case -1: {
                string2 = "USING_UDP";
                break;
            }
            case -3: {
                string2 = "USING_UDP_WAITING_FOR_TCP_DISCONNECT";
                break;
            }
            case -4: {
                string2 = "USING_UDP_WAITING_TO_DISCONNECT";
            }
        }
        this.wireDebug("DBG:setState(" + string2 + "):" + string);
    }

    private int messageSize(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(new SocketTransportMessage(object, this.nodeId));
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray.length;
    }

    void closeDueToError() {
        if (this.writer != null) {
            this.close(this.writer.getQueue());
        } else {
            this.close(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Iterator iterator) {
        PastryNode pastryNode = this.localnode;
        synchronized (pastryNode) {
            WireNodeHandle wireNodeHandle = this;
            synchronized (wireNodeHandle) {
                if (this.state == -1) {
                    return;
                }
                try {
                    this.debug("Closing and cleaning up socket.");
                    if (this.key != null) {
                        this.key.channel().close();
                        this.key.cancel();
                        this.key.attach(null);
                    }
                    if (this.state == -2) {
                        this.debug("Disconnect was unexpected - marking node as dead.");
                        ((WirePastryNode)this.getLocalNode()).getSocketManager().closeSocket(this);
                        this.markDead();
                    }
                    this.setState(-1, "close()");
                    if (iterator != null) {
                        Iterator iterator2 = iterator;
                        while (iterator2.hasNext()) {
                            Object e = iterator2.next();
                            if (e instanceof SocketTransportMessage) {
                                SocketTransportMessage socketTransportMessage = (SocketTransportMessage)e;
                                if (socketTransportMessage.getObject() instanceof RouteMessage) {
                                    RouteMessage routeMessage = (RouteMessage)socketTransportMessage.getObject();
                                    routeMessage.nextHop = null;
                                    this.getLocalNode().receiveMessage(routeMessage);
                                    this.debug("Rerouted message " + routeMessage);
                                    continue;
                                }
                                this.wireDebug("DRP:" + socketTransportMessage);
                                this.debug("Dropped message " + socketTransportMessage + " on floor.");
                                continue;
                            }
                            this.debug("Dropped message " + e + " on floor.");
                            this.wireDebug("DRP:" + e);
                        }
                    }
                    this.debug("Done rerouting messages...");
                    this.writer = null;
                    this.reader = null;
                }
                catch (IOException iOException) {
                    System.out.println("IOException " + iOException + " disconnecting from remote node " + this.address);
                    this.markDead();
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.setState(-1, "readObject()");
    }
}

