/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.util.HashMap;
import java.util.Iterator;
import rice.pastry.Log;
import rice.pastry.NodeId;
import rice.pastry.dist.DistCoalesedNodeHandle;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WirePastryNode;

public class WireNodeHandlePool
extends DistNodeHandlePool {
    private HashMap handles;
    private WirePastryNode pastryNode;

    public WireNodeHandlePool(WirePastryNode wirePastryNode) {
        this.pastryNode = wirePastryNode;
        this.handles = new HashMap();
    }

    public WireNodeHandle get(NodeId nodeId) {
        return (WireNodeHandle)this.handles.get(nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKilled() {
        HashMap hashMap = this.handles;
        synchronized (hashMap) {
            Iterator iterator = this.handles.values().iterator();
            while (iterator.hasNext()) {
                ((WireNodeHandle)iterator.next()).notifyKilled();
            }
        }
    }

    public synchronized DistNodeHandle coalesce(DistNodeHandle distNodeHandle) {
        DistCoalesedNodeHandle distCoalesedNodeHandle = (DistCoalesedNodeHandle)distNodeHandle;
        if (this.handles.get(distCoalesedNodeHandle.getNodeId()) == null || this.handles.get(distCoalesedNodeHandle.getNodeId()) == distCoalesedNodeHandle) {
            this.handles.put(distCoalesedNodeHandle.getNodeId(), distCoalesedNodeHandle);
            distCoalesedNodeHandle.setIsInPool(true);
        } else {
            distCoalesedNodeHandle.setIsInPool(false);
        }
        DistNodeHandle distNodeHandle2 = (DistNodeHandle)this.handles.get(distCoalesedNodeHandle.getNodeId());
        return distNodeHandle2;
    }

    public String toString() {
        String string = "";
        Iterator iterator = this.handles.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            string = string + k + "\t->\t" + this.handles.get(k) + "\n";
        }
        return string;
    }

    private void debug(String string) {
        if (Log.ifp(6)) {
            System.out.println(this.pastryNode.getNodeId() + " (P): " + string);
        }
    }
}

