/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.net.InetSocketAddress;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.dist.DistNodeHandlePool;
import rice.pastry.dist.DistPastryNode;
import rice.pastry.wire.DatagramManager;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.SocketManager;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WireNodeHandlePool;

public class WirePastryNode
extends DistPastryNode {
    private InetSocketAddress _address;
    private SelectorManager _manager;
    private DatagramManager _dManager;
    private SocketManager _sManager;
    private WireNodeHandlePool _pool;
    private Thread _executionThread;
    private static final int BASE_NUM_FDS_REQUIRED = 5;

    public WirePastryNode(NodeId nodeId) {
        super(nodeId);
        Wire.acquireFileDescriptors(5);
    }

    public SelectorManager getSelectorManager() {
        return this._manager;
    }

    public DatagramManager getDatagramManager() {
        return this._dManager;
    }

    public SocketManager getSocketManager() {
        return this._sManager;
    }

    public DistNodeHandlePool getNodeHandlePool() {
        return this._pool;
    }

    public void setSocketElements(InetSocketAddress inetSocketAddress, SelectorManager selectorManager, DatagramManager datagramManager, SocketManager socketManager, WireNodeHandlePool wireNodeHandlePool, int n, int n2) {
        this._address = inetSocketAddress;
        this._manager = selectorManager;
        this._dManager = datagramManager;
        this._sManager = socketManager;
        this._pool = wireNodeHandlePool;
        this.leafSetMaintFreq = n;
        this.routeSetMaintFreq = n2;
    }

    public void setThread(Thread thread) {
        this._executionThread = thread;
    }

    public boolean inThread() {
        return true;
    }

    public void doneNode(NodeHandle nodeHandle) {
        super.doneNode(nodeHandle);
        this.initiateJoin(nodeHandle);
        this._manager.run();
    }

    public void nodeIsReady() {
        super.nodeIsReady();
    }

    public void kill() {
        super.kill();
        this._dManager.notifyKilled();
        this._pool.notifyKilled();
        this._manager.kill();
        Wire.releaseFileDescriptors(5);
    }
}

