/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import rice.pastry.Log;
import rice.pastry.NodeHandle;
import rice.pastry.NodeId;
import rice.pastry.NodeIdFactory;
import rice.pastry.PastryNode;
import rice.pastry.dist.DistCoalesedNodeHandle;
import rice.pastry.dist.DistNodeHandle;
import rice.pastry.dist.DistPastryNodeFactory;
import rice.pastry.leafset.LeafSet;
import rice.pastry.messaging.MessageDispatch;
import rice.pastry.routing.RouteSet;
import rice.pastry.routing.RoutingTable;
import rice.pastry.standard.StandardJoinProtocol;
import rice.pastry.standard.StandardLeafSetProtocol;
import rice.pastry.standard.StandardRouteSetProtocol;
import rice.pastry.standard.StandardRouter;
import rice.pastry.wire.DatagramManager;
import rice.pastry.wire.SelectorManager;
import rice.pastry.wire.SocketChannelReader;
import rice.pastry.wire.SocketChannelWriter;
import rice.pastry.wire.SocketManager;
import rice.pastry.wire.Wire;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WireNodeHandlePool;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.WirePastrySecurityManager;
import rice.pastry.wire.messaging.socket.LeafSetRequestMessage;
import rice.pastry.wire.messaging.socket.LeafSetResponseMessage;
import rice.pastry.wire.messaging.socket.NodeIdRequestMessage;
import rice.pastry.wire.messaging.socket.NodeIdResponseMessage;
import rice.pastry.wire.messaging.socket.RouteRowRequestMessage;
import rice.pastry.wire.messaging.socket.RouteRowResponseMessage;
import rice.pastry.wire.messaging.socket.SocketCommandMessage;

public class WirePastryNodeFactory
extends DistPastryNodeFactory {
    protected NodeIdFactory nidFactory;
    protected int port;
    protected static final int rtMax = 1;
    protected static final int lSetSize = 24;
    protected static final int maxOpenSockets = 5;
    protected static final int leafSetMaintFreq = 60;
    protected static final int routeSetMaintFreq = 900;

    public WirePastryNodeFactory(NodeIdFactory nodeIdFactory, int n) {
        this.nidFactory = nodeIdFactory;
        this.port = n;
    }

    public LeafSet getLeafSet(NodeHandle nodeHandle) {
        WireNodeHandle wireNodeHandle = (WireNodeHandle)nodeHandle;
        try {
            LeafSetResponseMessage leafSetResponseMessage = (LeafSetResponseMessage)this.getResponse(wireNodeHandle.getAddress(), new LeafSetRequestMessage());
            return leafSetResponseMessage.getLeafSet();
        }
        catch (IOException iOException) {
            System.out.println("Error connecting to (leafset) address " + wireNodeHandle.getAddress() + ": " + iOException);
            return null;
        }
    }

    public RouteSet[] getRouteRow(NodeHandle nodeHandle, int n) {
        WireNodeHandle wireNodeHandle = (WireNodeHandle)nodeHandle;
        try {
            RouteRowResponseMessage routeRowResponseMessage = (RouteRowResponseMessage)this.getResponse(wireNodeHandle.getAddress(), new RouteRowRequestMessage(n));
            return routeRowResponseMessage.getRouteRow();
        }
        catch (IOException iOException) {
            System.out.println("Error connecting to (routerow) address " + wireNodeHandle.getAddress() + ": " + iOException);
            return new RouteSet[0];
        }
    }

    public int getProximity(NodeHandle nodeHandle, NodeHandle nodeHandle2) {
        WireNodeHandle wireNodeHandle = (WireNodeHandle)nodeHandle;
        WireNodeHandle wireNodeHandle2 = (WireNodeHandle)nodeHandle2;
        if (wireNodeHandle.getAddress().equals(wireNodeHandle2.getAddress())) {
            return Integer.MAX_VALUE;
        }
        if (wireNodeHandle2.proximity() == DistCoalesedNodeHandle.DEFAULT_DISTANCE) {
            try {
                long l = System.currentTimeMillis();
                this.getResponse(wireNodeHandle2.getAddress(), new NodeIdRequestMessage());
                long l2 = System.currentTimeMillis() - l;
                return (int)l2;
            }
            catch (IOException iOException) {
                System.out.println("Error pinging address " + wireNodeHandle2.getAddress() + ": " + iOException);
                return WireNodeHandle.DEFAULT_DISTANCE;
            }
        }
        return wireNodeHandle2.proximity();
    }

    public NodeHandle generateNodeHandle(InetSocketAddress inetSocketAddress) {
        System.out.println("Wire: Contacting bootstrap node " + inetSocketAddress);
        try {
            NodeIdResponseMessage nodeIdResponseMessage = (NodeIdResponseMessage)this.getResponse(inetSocketAddress, new NodeIdRequestMessage());
            return new WireNodeHandle(inetSocketAddress, nodeIdResponseMessage.getNodeId());
        }
        catch (IOException iOException) {
            System.out.println("Error connecting to address " + inetSocketAddress + ": " + iOException);
            System.out.println("Couldn't find a bootstrap node, starting a new ring...");
            return null;
        }
    }

    public PastryNode newNode(NodeHandle nodeHandle) {
        if (nodeHandle == null) {
            // empty if block
        }
        return this.newNode(nodeHandle, this.nidFactory.generateNodeId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PastryNode newNode(NodeHandle nodeHandle, NodeId nodeId) {
        final WirePastryNode wirePastryNode = new WirePastryNode(nodeId);
        SelectorManager selectorManager = new SelectorManager(wirePastryNode);
        DatagramManager datagramManager = null;
        SocketManager socketManager = null;
        InetSocketAddress inetSocketAddress = null;
        Object object = this;
        synchronized (object) {
            datagramManager = new DatagramManager(wirePastryNode, selectorManager, this.port);
            selectorManager.registerForWakeup(datagramManager);
            socketManager = new SocketManager(wirePastryNode, this.port, selectorManager.getSelector());
            inetSocketAddress = this.getAddress(this.port);
            ++this.port;
        }
        object = new WireNodeHandle(inetSocketAddress, nodeId);
        WireNodeHandlePool wireNodeHandlePool = new WireNodeHandlePool(wirePastryNode);
        WirePastrySecurityManager wirePastrySecurityManager = new WirePastrySecurityManager((WireNodeHandle)object, wireNodeHandlePool);
        MessageDispatch messageDispatch = new MessageDispatch();
        RoutingTable routingTable = new RoutingTable((NodeHandle)object, 1);
        LeafSet leafSet = new LeafSet((NodeHandle)object, 24);
        StandardRouter standardRouter = new StandardRouter((NodeHandle)object, routingTable, leafSet, wirePastrySecurityManager);
        StandardLeafSetProtocol standardLeafSetProtocol = new StandardLeafSetProtocol(wirePastryNode, (NodeHandle)object, wirePastrySecurityManager, leafSet, routingTable);
        StandardRouteSetProtocol standardRouteSetProtocol = new StandardRouteSetProtocol((NodeHandle)object, wirePastrySecurityManager, routingTable);
        StandardJoinProtocol standardJoinProtocol = new StandardJoinProtocol(wirePastryNode, (NodeHandle)object, wirePastrySecurityManager, routingTable, leafSet);
        messageDispatch.registerReceiver(standardRouter.getAddress(), standardRouter);
        messageDispatch.registerReceiver(standardLeafSetProtocol.getAddress(), standardLeafSetProtocol);
        messageDispatch.registerReceiver(standardRouteSetProtocol.getAddress(), standardRouteSetProtocol);
        messageDispatch.registerReceiver(standardJoinProtocol.getAddress(), standardJoinProtocol);
        wirePastryNode.setElements((NodeHandle)object, wirePastrySecurityManager, messageDispatch, leafSet, routingTable);
        wirePastryNode.setSocketElements(inetSocketAddress, selectorManager, datagramManager, socketManager, wireNodeHandlePool, 60, 900);
        wirePastrySecurityManager.setLocalPastryNode(wirePastryNode);
        wireNodeHandlePool.coalesce((DistNodeHandle)object);
        ((NodeHandle)object).setLocalNode(wirePastryNode);
        if (nodeHandle != null) {
            nodeHandle.setLocalNode(wirePastryNode);
        }
        Thread thread = new Thread("Thread for node " + nodeId, (WireNodeHandle)object, nodeHandle){
            private final /* synthetic */ WireNodeHandle val$localhandle;
            private final /* synthetic */ NodeHandle val$bootstrap;
            {
                this.val$localhandle = wireNodeHandle;
                this.val$bootstrap = nodeHandle;
            }

            public void run() {
                try {
                    1.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("Interrupted in newNode!");
                }
                wirePastryNode.doneNode(WirePastryNodeFactory.this.getNearest(this.val$localhandle, this.val$bootstrap));
            }
        };
        wirePastryNode.setThread(thread);
        thread.start();
        return wirePastryNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SocketCommandMessage getResponse(InetSocketAddress inetSocketAddress, SocketCommandMessage socketCommandMessage) throws IOException {
        SocketChannel socketChannel = null;
        Object object = null;
        IOException iOException = null;
        try {
            try {
                SocketChannelWriter socketChannelWriter = new SocketChannelWriter(null, null, null);
                SocketChannelReader socketChannelReader = new SocketChannelReader(null, null);
                Wire.acquireFileDescriptor();
                socketChannel = SocketChannel.open();
                socketChannel.configureBlocking(true);
                socketChannel.socket().connect(inetSocketAddress);
                socketChannelWriter.enqueue(socketCommandMessage);
                socketChannelWriter.write(socketChannel);
                while (object == null) {
                    object = socketChannelReader.read(socketChannel);
                }
                Object var9_9 = null;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                Object var9_10 = null;
                Wire.registerSocketChannel(socketChannel, "getResponse(" + socketCommandMessage + ")");
                if (iOException != null) {
                    this.debug("not registering bogus channel:" + iOException);
                }
                socketChannel.close();
                Wire.releaseFileDescriptor();
                if (iOException != null) {
                    throw iOException;
                }
                return (SocketCommandMessage)object;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Wire.registerSocketChannel(socketChannel, "getResponse(" + socketCommandMessage + ")");
            if (iOException != null) {
                this.debug("not registering bogus channel:" + iOException);
            }
            socketChannel.close();
            Wire.releaseFileDescriptor();
            if (iOException != null) {
                throw iOException;
            }
            return (SocketCommandMessage)object;
        }
        Wire.registerSocketChannel(socketChannel, "getResponse(" + socketCommandMessage + ")");
        if (iOException != null) {
            this.debug("not registering bogus channel:" + iOException);
        }
        socketChannel.close();
        Wire.releaseFileDescriptor();
        if (iOException != null) {
            throw iOException;
        }
        return (SocketCommandMessage)object;
    }

    protected InetSocketAddress getAddress(int n) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = new InetSocketAddress(InetAddress.getLocalHost(), n);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("PANIC: Unknown host in getAddress. " + unknownHostException);
        }
        return inetSocketAddress;
    }

    protected void debug(String string) {
        if (Log.ifp(8)) {
            System.out.println(" (F): " + string);
        }
    }
}

