/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire.messaging.socket;

import java.net.InetSocketAddress;
import rice.pastry.NodeId;
import rice.pastry.wire.WireNodeHandle;
import rice.pastry.wire.WirePastryNode;
import rice.pastry.wire.messaging.socket.HelloResponseMessage;
import rice.pastry.wire.messaging.socket.SocketCommandMessage;

public class HelloMessage
extends SocketCommandMessage {
    private InetSocketAddress address;
    private NodeId nodeId;
    private NodeId dest;
    private String name;

    public HelloMessage(WirePastryNode wirePastryNode, NodeId nodeId) {
        this.address = ((WireNodeHandle)wirePastryNode.getLocalHandle()).getAddress();
        this.nodeId = wirePastryNode.getNodeId();
        this.dest = nodeId;
        this.name = wirePastryNode.getNodeName().toString();
    }

    public String getName() {
        return this.name;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeId getDestination() {
        return this.dest;
    }

    public HelloResponseMessage getResponse(WirePastryNode wirePastryNode) {
        return new HelloResponseMessage(wirePastryNode, this.nodeId);
    }

    public String toString() {
        return "HelloMessage from " + this.address + "(" + this.nodeId + ") to " + this.dest;
    }
}

