/*
 * Decompiled with CFR 0.152.
 */
package rice.pastry.wire.testing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import rice.pastry.wire.testing.MessageDigest;
import rice.pastry.wire.testing.MessageDigestFactory;
import rice.pastry.wire.testing.WireFileFilter;

public class WireFileProcessor {
    public static final String WNH_PREFIX = "WNH";
    public static final String DM_PREFIX = "DM";
    public static final int PREFIX_LENGTH = 4;
    public static final String enquePrefix = "ENQ:";
    public static final String sentPrefix = "SEN:";
    public static final String receivedPrefix = "REC:";
    public static final String dropPrefix = "DRP:";
    public static final int TYPE_ENQ = 0;
    public static final int TYPE_SEN = 1;
    public static final int TYPE_REC = 2;
    public static final int TYPE_DRP = 3;
    public static final int ID_LENGTH = 10;
    public static final int NUM_TABLES = 4;
    public Hashtable enqueued = new Hashtable();
    public Hashtable sent = new Hashtable();
    public Hashtable received = new Hashtable();
    public Hashtable dropped = new Hashtable();
    public Hashtable[] tables = new Hashtable[4];
    private MessageDigestFactory mdf = new MessageDigestFactory();

    public WireFileProcessor() {
        this.tables[0] = this.enqueued;
        this.tables[1] = this.sent;
        this.tables[2] = this.received;
        this.tables[3] = this.dropped;
    }

    public void processFiles() throws IOException {
        File file = new File("temp.blah.moo");
        file.delete();
        file.createNewFile();
        File file2 = file.getAbsoluteFile().getParentFile();
        if (!file2.isDirectory()) {
            throw new RuntimeException(file2 + " is not a directory.");
        }
        this.processFiles(file2);
    }

    public void processFile(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException("File Not Found");
        }
        if (string.startsWith(WNH_PREFIX)) {
            this.processWNHFile(file, true);
        }
        if (string.startsWith(DM_PREFIX)) {
            this.processDMFile(file, true);
        }
    }

    public void processFiles(File file) throws IOException {
        WireFileFilter wireFileFilter = new WireFileFilter(WNH_PREFIX);
        File[] fileArray = file.listFiles(wireFileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            this.processWNHFile(fileArray[i], false);
        }
        WireFileFilter wireFileFilter2 = new WireFileFilter(DM_PREFIX);
        File[] fileArray2 = file.listFiles(wireFileFilter2);
        for (int i = 0; i < fileArray2.length; ++i) {
            this.processDMFile(fileArray2[i], false);
        }
    }

    public void processWNHFile(File file, boolean bl) throws IOException {
        String string;
        int n = 2;
        int n2 = 4;
        String string2 = file.getName();
        int n3 = WNH_PREFIX.length() + n;
        int n4 = n3 + 10;
        String string3 = string2.substring(n3, n4);
        n3 = n4 + n2;
        n4 = n3 + 10;
        String string4 = string2.substring(n3, n4);
        System.out.println("WNH File:" + file.getName() + " : " + string3 + " to " + string4);
        BufferedReader bufferedReader = WireFileProcessor.getReader(file);
        int n5 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            String string5;
            int n6;
            ++n5;
            if (string.length() < 4 || (n6 = WireFileProcessor.getType(string5 = string.substring(0, 4))) == -1) continue;
            string = string.substring(4, string.length());
            MessageDigest messageDigest = this.mdf.getMessageDigest(n5, string3, string4, string, n6, false);
            int n7 = this.addToTable(n6, messageDigest);
            if (!bl) continue;
            System.out.println(n5 + ":" + n7 + ":" + messageDigest);
        }
    }

    public void processDMFile(File file, boolean bl) throws IOException {
        String string;
        int n = 2;
        String string2 = file.getName();
        int n2 = DM_PREFIX.length() + n;
        int n3 = n2 + 10;
        String string3 = string2.substring(n2, n3);
        System.out.println("DM File:" + file.getName() + " : " + string3);
        BufferedReader bufferedReader = WireFileProcessor.getReader(file);
        int n4 = 1;
        int n5 = 2;
        int n6 = n4 + 10 + n5 + 4;
        int n7 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            ++n7;
            if (string.length() < n6) continue;
            n2 = n4;
            n3 = n2 + 10;
            String string4 = string.substring(n2, n3);
            n2 = n3 + n5;
            String string5 = string.substring(n2, n3 = n2 + 4);
            int n8 = WireFileProcessor.getType(string5);
            if (n8 == -1) continue;
            string = string.substring(n6, string.length());
            MessageDigest messageDigest = this.mdf.getMessageDigest(n7, string3, string4, string, n8, true);
            int n9 = this.addToTable(n8, messageDigest);
            if (!bl) continue;
            System.out.println(n7 + ":" + n9 + ":" + messageDigest);
        }
    }

    public int addToTable(int n, MessageDigest messageDigest) {
        ObjPair objPair;
        Hashtable hashtable = this.tables[n];
        Hashtable<MessageDigest, ObjPair> hashtable2 = (Hashtable<MessageDigest, ObjPair>)hashtable.get(messageDigest.local);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<MessageDigest, ObjPair>();
            hashtable.put(messageDigest.local, hashtable2);
        }
        if ((objPair = (ObjPair)hashtable2.get(messageDigest)) == null) {
            hashtable2.put(messageDigest, new ObjPair(messageDigest));
            return 1;
        }
        objPair.add(messageDigest);
        return objPair.getCount();
    }

    public static int getType(String string) {
        if (string.equals(enquePrefix)) {
            return 0;
        }
        if (string.equals(sentPrefix)) {
            return 1;
        }
        if (string.equals(receivedPrefix)) {
            return 2;
        }
        if (string.equals(dropPrefix)) {
            return 3;
        }
        return -1;
    }

    public static String getType(int n) {
        switch (n) {
            case 0: {
                return enquePrefix;
            }
            case 1: {
                return sentPrefix;
            }
            case 2: {
                return receivedPrefix;
            }
            case 3: {
                return dropPrefix;
            }
        }
        return "UNKNOWN";
    }

    public static BufferedReader getReader(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }

    public Pair countItems(Hashtable hashtable) {
        Pair pair = new Pair(0, 0);
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Hashtable hashtable2 = (Hashtable)hashtable.get(e);
            Pair pair2 = this.countItems2(hashtable2);
            pair.add(pair2);
        }
        return pair;
    }

    public Pair countItems2(Hashtable hashtable) {
        int n = 0;
        int n2 = 0;
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            MessageDigest messageDigest = (MessageDigest)iterator.next();
            if (!messageDigest.searchForMe) continue;
            ObjPair objPair = (ObjPair)hashtable.get(messageDigest);
            n += objPair.udp.size();
            n2 += objPair.tcp.size();
        }
        return new Pair(n, n2);
    }

    public void printTableTotals() {
        for (int i = 0; i < 4; ++i) {
            System.out.println("\n" + WireFileProcessor.getType(i));
            Pair pair = this.countItems(this.tables[i]);
            System.out.println("Total:" + pair);
        }
    }

    public void compareEnqSnd() {
        this.compareTables(this.tables[0], this.tables[1]);
    }

    public void compareEnqRec() {
        this.compareTables(this.tables[0], this.tables[2]);
    }

    public void compareTables(Hashtable hashtable, Hashtable hashtable2) {
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Hashtable hashtable3 = (Hashtable)hashtable.get(k);
            Hashtable hashtable4 = (Hashtable)hashtable2.get(k);
            System.out.println("\nMissing Msgs for " + k);
            int n = this.compareSets(hashtable3, hashtable4);
            System.out.println("Total:" + n);
        }
    }

    public int compareSets(Hashtable hashtable, Hashtable hashtable2) {
        int n = 0;
        Iterator iterator = hashtable.keySet().iterator();
        while (iterator.hasNext()) {
            MessageDigest messageDigest = (MessageDigest)iterator.next();
            if (!messageDigest.searchForMe) continue;
            ObjPair objPair = (ObjPair)hashtable.get(messageDigest);
            if (hashtable2.containsKey(messageDigest)) {
                ObjPair objPair2 = (ObjPair)hashtable2.get(messageDigest);
                int n2 = objPair.getCount() - objPair2.getCount();
                if (n2 <= 0) continue;
                objPair.print();
                objPair2.print();
                System.out.println();
                n += n2;
                continue;
            }
            objPair.print();
            System.out.println();
            n += objPair.getCount();
        }
        return n;
    }

    private void analyze() {
        this.compareEnqSnd();
        this.compareEnqRec();
        this.printTableTotals();
    }

    public static void main(String[] stringArray) throws Exception {
        WireFileProcessor wireFileProcessor = new WireFileProcessor();
        if (stringArray.length == 0) {
            wireFileProcessor.processFiles();
            wireFileProcessor.analyze();
        } else {
            wireFileProcessor.processFile(stringArray[0]);
        }
    }

    public class Pair {
        public int udp;
        public int tcp;

        public Pair(int n, int n2) {
            this.udp = n;
            this.tcp = n2;
        }

        public void add(Pair pair) {
            this.udp += pair.udp;
            this.tcp += pair.tcp;
        }

        public String toString() {
            int n = this.udp + this.tcp;
            return "U:" + this.udp + ",T:" + this.tcp + ",sum:" + n;
        }
    }

    public class ObjPair {
        public ArrayList udp = new ArrayList();
        public ArrayList tcp = new ArrayList();
        MessageDigest canonMd;

        public ObjPair(MessageDigest messageDigest) {
            this.canonMd = messageDigest;
            this.add(messageDigest);
        }

        public void add(MessageDigest messageDigest) {
            if (!this.canonMd.equals(messageDigest)) {
                throw new RuntimeException("Message Digests Not Equal");
            }
            if (messageDigest.udp) {
                this.udp.add(messageDigest);
            } else {
                this.tcp.add(messageDigest);
            }
        }

        public int getCount() {
            return this.udp.size() + this.tcp.size();
        }

        public void print() {
            this.printList(this.udp);
            this.printList(this.tcp);
        }

        private void printList(ArrayList arrayList) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                MessageDigest messageDigest = (MessageDigest)iterator.next();
                System.out.println(messageDigest);
            }
        }

        public void printDiffa(ObjPair objPair) {
        }
    }
}

