/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.xnio;

import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.Channel;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.GatheringByteChannel;
import org.jboss.netty.channel.AbstractChannelSink;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.xnio.BaseXnioChannel;
import org.jboss.netty.channel.xnio.XnioChannelRegistry;
import org.jboss.netty.channel.xnio.XnioClientChannel;
import org.jboss.netty.channel.xnio.XnioClientChannelHandler;
import org.jboss.xnio.FutureConnection;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.MultipointWritableMessageChannel;
import org.jboss.xnio.channels.SuspendableReadChannel;
import org.jboss.xnio.channels.SuspendableWriteChannel;
import org.jboss.xnio.channels.WritableMessageChannel;

final class XnioClientChannelSink
extends AbstractChannelSink {
    private static final XnioClientChannelHandler HANDLER = new XnioClientChannelHandler();

    XnioClientChannelSink() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        BaseXnioChannel channel = (BaseXnioChannel)e.getChannel();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.closeNow(future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) {
                        if (channel instanceof XnioClientChannel) {
                            XnioClientChannel cc = (XnioClientChannel)channel;
                            Object object = cc.connectLock;
                            synchronized (object) {
                                if (cc.connecting) {
                                    ConnectionPendingException cause = new ConnectionPendingException();
                                    future.setFailure(cause);
                                    Channels.fireExceptionCaught(channel, (Throwable)cause);
                                } else {
                                    cc.connecting = true;
                                    Channel xnioChannel = cc.xnioChannel;
                                    if (xnioChannel == null) {
                                        FutureConnection fc = cc.xnioConnector.connectTo(value, (IoHandler)HANDLER);
                                        fc.addNotifier((IoFuture.Notifier)new FutureConnectionNotifier(cc), (Object)future);
                                    } else {
                                        AlreadyConnectedException cause = new AlreadyConnectedException();
                                        future.setFailure(cause);
                                        Channels.fireExceptionCaught(cc, (Throwable)cause);
                                    }
                                }
                                break;
                            }
                        }
                        UnsupportedOperationException cause = new UnsupportedOperationException();
                        future.setFailure(cause);
                        Channels.fireExceptionCaught(channel, (Throwable)cause);
                        break;
                    }
                    channel.closeNow(future);
                    break;
                }
                case INTEREST_OPS: {
                    int interestOps = (Integer)value;
                    Channel xnioChannel = channel.xnioChannel;
                    if (xnioChannel instanceof SuspendableReadChannel) {
                        if ((interestOps & 1) == 0) {
                            ((SuspendableReadChannel)xnioChannel).suspendReads();
                            channel.setRawInterestOpsNow(0);
                        } else {
                            ((SuspendableReadChannel)xnioChannel).resumeReads();
                            channel.setRawInterestOpsNow(1);
                        }
                    }
                    e.getFuture().setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            Channel xnioChannel = channel.xnioChannel;
            if (xnioChannel instanceof GatheringByteChannel || xnioChannel instanceof MultipointWritableMessageChannel || xnioChannel instanceof WritableMessageChannel) {
                boolean offered = channel.writeBuffer.offer(event);
                assert (offered);
                if (xnioChannel instanceof SuspendableWriteChannel) {
                    ((SuspendableWriteChannel)xnioChannel).resumeWrites();
                }
            } else {
                event.getFuture().setFailure(new IllegalStateException());
            }
        }
    }

    private static final class FutureConnectionNotifier
    implements IoFuture.Notifier {
        private final XnioClientChannel cc;

        FutureConnectionNotifier(XnioClientChannel cc) {
            this.cc = cc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(IoFuture future, Object attachment) {
            ChannelFuture cf = (ChannelFuture)attachment;
            try {
                Channel xnioChannel;
                this.cc.xnioChannel = xnioChannel = (Channel)future.get();
                XnioChannelRegistry.registerChannelMapping(this.cc);
                cf.setSuccess();
            }
            catch (Throwable t) {
                cf.setFailure(t);
                Channels.fireExceptionCaught(this.cc, t);
            }
            finally {
                this.cc.connecting = false;
            }
        }
    }
}

