package code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.StringTokenizer;

import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.simulator.Hash;
import code.simulator.IrisHashObject;
import code.simulator.Node;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;

/** 
 *  AcceptStamp: Represents a Bayou-like accept stamp 
 **/ 
public class AcceptStamp implements IrisSerializable, Externalizable, Immutable, Comparable<AcceptStamp>
{
  private final long localClock;
  private final NodeId nodeid;

  //
  // All events are guaranteed to happen at non-negative
  // moments in time. So, if you need to specify a time
  // before any event (e.g., to initialize a version vector
  // element), use BEFORE_TIME_BEGAN
  //
  public final static long BEFORE_TIME_BEGAN = -1;

    
 /** 
 *  Clone returns a reference to this -- ASSUMES WE ARE IMMUTABLE!!! 
 **/ 
  public Object clone()
    {
      assert(this instanceof Immutable);
      return this;
    }
  
  public AcceptStamp(){
    localClock = -1;
    nodeid = null;
  }

 /** 
 *  Constuctor sets the member variables 
 **/ 
  public AcceptStamp(long localClock_, NodeId nodeid_)
    {
      this.localClock = localClock_;
      this.nodeid = nodeid_;
    }

 /** 
 *  Constuctor sets the member variables 
 **/ 
  public AcceptStamp(String str)
    {
      // format: (<localClock>,"<nodeId>") 
      // please refer to the toString() method

      StringTokenizer st = new StringTokenizer(str, " \t\",()");
      this.localClock = new Long(st.nextToken()).longValue();
      assert false;
      if(SangminConfig.forkjoin){
        this.nodeid = new BranchID(new Long(st.nextToken()).longValue());
      } else {
        this.nodeid = new NodeId(new Long(st.nextToken()).longValue());
      }
    }

 /** 
 *  Return the local Lamport clock value 
 **/ 
  public final long getLocalClock()
    {
      return(this.localClock);
    }

 /** 
 *  Return the node ID of the writer 
 **/ 
  public final NodeId getNodeId()
    {
      return(this.nodeid);
    }

  //*no update/put methods for the members*

  //-----------------------------------------------------------------------
  // Return true if this AcceptStamp is equal to o
  //-----------------------------------------------------------------------
  public boolean equals(Object o)
    {
      boolean result = false;
      AcceptStamp as = null;

      if(o instanceof AcceptStamp){
        as = (AcceptStamp)o;
        result = ((as.localClock == this.localClock) &&
                  (as.nodeid.equals(this.nodeid)));
      }else{
        result = false;
      }
      return(result);
    }
  
  public int compareTo(AcceptStamp o) throws ClassCastException{
    if(!(o instanceof AcceptStamp)){
      throw new ClassCastException();
    }else{
      AcceptStamp as = (AcceptStamp)o;
      if(this.lt(as)){
        return -1;
      }else if(this.eq(as)){
        return 0;
      }else{
        return 1;
      }
    }
  }

  //-----------------------------------------------------------------------
  // Return a hash code for this AcceptStamp
  //-----------------------------------------------------------------------
  public int hashCode()
    {
      Long clockLong = null;

      clockLong = new Long(this.localClock);
      return(clockLong.hashCode() ^ this.nodeid.hashCode());
    }


  //-----------------------------------------------------------------------
  // Convert to a string representation
  //-----------------------------------------------------------------------
  public final String toString()
    {
      return("(" + this.localClock + ", \"" + this.nodeid + "\")");
    }

  //-----------------------------------------------------------------------
  // Compare operator
  //-----------------------------------------------------------------------
  public final boolean lt(AcceptStamp as)
    {
      if(localClock < as.getLocalClock()) 
        return true; 
      else if(localClock > as.getLocalClock())
        return false;
      else  {
        int val = nodeid.compareTo(as.getNodeId());
        return (val == -1);
      }
		    
    }

//-----------------------------------------------------------------------
// leq -- return true if <this> is at most <as>
//-----------------------------------------------------------------------
  public final boolean leq(AcceptStamp as){
    if(localClock < as.getLocalClock()) {
      return true;
    }
    if(localClock == as.getLocalClock()) {
      if(nodeid.leq(as.getNodeId())){
        return true;
      }
      assert(nodeid.gt(as.getNodeId()));
      return false;
    }
    assert(localClock > as.getLocalClock());
    return false;
  }

  public final boolean gt(AcceptStamp as)
    {
      if(localClock > as.getLocalClock()) 
        return true; 
      else if(localClock < as.getLocalClock())
        return false;
      else  {
        int val = nodeid.compareTo(as.getNodeId());
        return (val == 1);
      }
		    
    }
  
  public final boolean geq(AcceptStamp as){
    if(localClock > as.getLocalClock()) {
      return true;
    }
    if(localClock == as.getLocalClock()) {
      if(nodeid.geq(as.getNodeId())){
        return true;
      }
      assert(nodeid.lt(as.getNodeId()));
      return false;
    }
    assert(localClock < as.getLocalClock());
    return false;
  }

  public final boolean eq(AcceptStamp as) 
    {

      if(localClock == as.getLocalClock() &&
         nodeid.equals(as.getNodeId()))
        return true;
      else 
        return false;
    }
  //-----------------------------------------------------------------------
  // Testing moved to AcceptStampUnit.java
  //-----------------------------------------------------------------------

  public void readExternal(ObjectInput in) throws IOException,
      ClassNotFoundException{
    
    long _ts = in.readLong();
    NodeId _n = null;
    if(SangminConfig.forkjoin && SangminConfig.securityLevel > SangminConfig.SIGNEDVV){
      _n = new BranchID(-1); 
      ((BranchID)_n).readExternal(in);
    } else {
      if(SangminConfig.forkjoin){
        _n = new BranchID(in.readLong());
      }else{
        _n = new NodeId(in.readLong());
      }
    }
    
    Field[] f = new Field[2];

    try{

      f[0] = AcceptStamp.class.getDeclaredField("localClock");
      f[1] = AcceptStamp.class.getDeclaredField("nodeid");
      
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, _ts);
      f[1].set(this, _n);
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
  }

  public void writeExternal(ObjectOutput out) throws IOException{
    out.writeLong(this.localClock);
    if(SangminConfig.forkjoin && SangminConfig.securityLevel > SangminConfig.SIGNEDVV){
      ((BranchID)this.nodeid).writeExternal(out);
    } else {
      out.writeLong(nodeid.getIDint());
    }
  }
  
  public static void testExt() throws IOException{
    AcceptStamp as = new AcceptStamp(0, new BranchID(10, -1, Hash.NullHash));

    ByteArrayOutputStream bs;
    ObjectOutputStream oos;


    bs = new ByteArrayOutputStream();
    oos = new IrisObjectOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(as);
    as.writeExternal(oos);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    AcceptStamp as2 = null;
    ObjectInputStream ois = new IrisObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
    try{
//      as2 = (AcceptStamp)ois.readObject();
      as2 = new AcceptStamp();
      as2.readExternal(ois);
    }catch(ClassNotFoundException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }

    if(as.equals(as2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + as + "\n" + as2);

    }
  }
  
  public static void testStr() throws IOException{
    AcceptStamp as = new AcceptStamp(0, new BranchID(10, -1, Hash.NullHash));

    ByteArrayOutputStream bs;
    IrisOutputStream oos;


    bs = new ByteArrayOutputStream();
    oos = new IrisOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(as);
    as.writeToStream(oos, false);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    AcceptStamp as2 = null;
    IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
    as2 = new AcceptStamp();
    as2.readFromStream(ois, false);
    
    if(as.equals(as2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + as + "\n" + as2);

    }
  }
  public static void main(String[] args) throws IOException{
    testExt();
    testStr();
  }

  public void readFromStream(IrisInputStream in, boolean optimized)
      throws IOException{
    long _ts = in.readLong()-1;
    NodeId _n = null;
    if(SangminConfig.forkjoin && SangminConfig.securityLevel > SangminConfig.SIGNEDVV){
      _n = new BranchID(-1); 
      ((BranchID)_n).readFromStream(in, optimized);
    } else {
      if(SangminConfig.forkjoin){
        _n = new BranchID(in.readLong());
      }else{
        _n = new NodeId(in.readLong());
      }
    }
    
    Field[] f = new Field[2];

    try{

      f[0] = AcceptStamp.class.getDeclaredField("localClock");
      f[1] = AcceptStamp.class.getDeclaredField("nodeid");
      
    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, _ts);
      f[1].set(this, _n);
    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
      throws IOException{
    out.writeLong(this.localClock+1);
    if(SangminConfig.forkjoin && SangminConfig.securityLevel > SangminConfig.SIGNEDVV){
      ((BranchID)this.nodeid).writeToStream(out, optimized);
    } else {
      out.writeLong(nodeid.getIDint());
    }
  }
}

//---------------------------------------------------------------------------
/* $Log: AcceptStamp.java,v $
/* Revision 1.14  2006/09/19 22:18:27  nalini
/* P2 and Practi integration
/*
/* Revision 1.13  2005/06/01 16:33:45  dahlin
/* Cleaned up makefiles to compile more quickly
/*
/* Revision 1.12  2004/09/16 15:40:22  dahlin
/* Added leq function
/*
/* Revision 1.11  2004/07/28 14:27:34  dahlin
/* Added sanity checks for immutable objects
/*
/* Revision 1.10  2004/05/20 01:44:07  dahlin
/* Looks like spanning trees are getting set up with TrivialSpanningTreeDirectory (though more testing remains)
/*
/* Revision 1.9  2004/05/10 20:54:36  arun
/* compiling version
/*
/* Revision 1.8  2004/05/10 08:34:19  nayate
/* Added clone() and equals(), modified tests to use asserts
/*
/* Revision 1.7  2004/05/09 19:12:46  dahlin
/* Fixed minor typo in self test
/*
/* Revision 1.6  2004/05/09 19:11:10  dahlin
/* Updated AcceptStamp self tests
/*
/* Revision 1.5  2004/04/22 08:51:49  nayate
/* Minor change to "toString"
/*
/* Revision 1.4  2004/04/20 04:49:28  nayate
/* Tested AcceptStamp
/*
/* Revision 1.3  2004/04/16 16:05:16  nayate
/* Subset of PreciseInv implemented + removed some compiler errors.
/*
/* Revision 1.2  2004/04/15 20:04:24  nayate
/* New Makefile; added provision to allow CVS to append file modification
/* logs to files.
/* */
