package code;
import junit.textui.TestRunner;
import java.util.*;

import junit.framework.*;

public class AcceptStampUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   */
  public AcceptStampUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
  }

  protected void tearDown() throws Exception{
    super.tearDown();
  }

  public void testAcceptStamp(){
    NodeId n1 = new NodeId(1);
    NodeId n2 = new NodeId(99);
    NodeId n3 = new NodeId(1);
    
    AcceptStamp ass1 = new AcceptStamp(43, n1);
    AcceptStamp ass2 = new AcceptStamp(98, n2);
    AcceptStamp ass3 = new AcceptStamp(43, n1);
    AcceptStamp ass4 = new AcceptStamp(43, n3);
    AcceptStamp ass5 = (AcceptStamp)ass3.clone();
    AcceptStamp ass6 = new AcceptStamp(43, n2);
    
    assert(ass1.equals(ass1));
    assert(ass1.equals(ass3));
    assert(ass1.equals(ass4));
    assert(ass1.equals(ass5));
    assert(!ass1.equals(ass2));
    assert(!ass3.equals(ass2));
    assert(!ass4.equals(ass2));
    assert(!ass5.equals(ass2));
    assert(ass1.hashCode() == ass1.hashCode());
    assert(ass1.hashCode() == ass3.hashCode());
    assert(ass1.hashCode() == ass4.hashCode());
    assert(ass1.hashCode() == ass5.hashCode());
    
    assert(ass1.leq(ass1));
    assert(ass1.leq(ass2));
    assert(ass1.leq(ass3));
    assert(ass1.leq(ass4));
    assert(ass1.leq(ass6));
    assert(!ass6.leq(ass1));
    assert(!ass2.leq(ass1));
    
    // Simple testing for this class
    AcceptStamp as1 = new AcceptStamp(100, new NodeId(190));
    AcceptStamp as2 = new AcceptStamp(190, new NodeId(200));
    
    assert(as1.toString().equals("(100, \"190\")"));
    assert(as1.getLocalClock() == 100);
    assert(as1.getNodeId().equals(new NodeId(190)));
    assert(as2.toString().equals("(190, \"200\")"));
    assert(as2.getLocalClock() == 190);
    assert(as2.getNodeId().equals(new NodeId(200)));
    
  }
  
  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(AcceptStampUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   */
  public static void main(String s[]) {
    String name = "AcceptStampUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
