package code;
//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;

import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;

public class AcceptVVUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   */
  public AcceptVVUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
  }

  protected void tearDown() throws Exception{
    super.tearDown();
  }

  /* 
   * TBD: Insert functions called testX for some X
   */
  public void testBasic(){
    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptVV vv3 = null;
    AcceptVV resultTestVV = null;
    AcceptStamp[] as = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;

    as = new AcceptStamp[3];
    as[0] = new AcceptStamp(100, new NodeId(200));
    as[1] = new AcceptStamp(200, new NodeId(300));
    as[2] = new AcceptStamp(300, new NodeId(400));
    as3 = new AcceptStamp[3];
    as3[0] = new AcceptStamp(100, new NodeId(200));
    as3[2] = new AcceptStamp(200, new NodeId(300));
    as3[1] = new AcceptStamp(300, new NodeId(400));

    vv1 = new AcceptVV(as);
    as[2] = new AcceptStamp(400, new NodeId(500));
    vv2 = new AcceptVV(as);
    vv3 = new AcceptVV(as3);
    AcceptVV vv4 = (AcceptVV)vv3.clone();
    assert(vv1.equals(vv1));
    assert(!vv1.equals(vv2)); // Careful to copy as rather than keep reference to it!
    assert(vv1.equals(vv3)); // Careful -- insensitive to order and copies 
    assert(vv3.equals(vv4));
    assert(vv1.hashCode() == vv1.hashCode());
    assert(vv1.hashCode() == vv3.hashCode());
    assert(vv3.hashCode() == vv4.hashCode());

    //
    // FIXME to follow testing conventions -- 
    //   (1) assert field values rather than print things out
    //   (2) Exit with 0 status and message on success and negative on failure
    //
    // vv1 = (<"400", 300> <"300", 200> <"200", 100> )
    assert(vv1.equals(vv1));
    assert(vv1.getMaxTimeStamp() == 300);
    assert(vv1.getMinTimeStamp() == 100);
    // vv2 = (<"500", 400> <"300", 200> <"200", 100> )
    assert(!vv1.equals(vv2));
    assert(vv2.getMaxTimeStamp() == 400);
    assert(vv2.getMinTimeStamp() == 100);

    // Test includes(vv)
    assert(vv1.includes(vv1));
    assert(vv2.includes(vv2));
    assert(!vv1.includes(vv2));
    assert(!vv2.includes(vv1));
    // vv2 = (<"400", 400> <"300", 200> <"200", 100> )
    as[2] = new AcceptStamp(400, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(vv2.getMaxTimeStamp() == 400);
    assert(vv2.getMinTimeStamp() == 100);
    assert(!vv1.includes(vv2));
    assert(vv2.includes(vv1));
    // vv2 = (<"500", 600> <"400", 300> <"300", 200> <"200", 100> )
    as2 = new AcceptStamp[4];
    as2[0] = as[0];
    as2[1] = as[1];
    as2[2] = new AcceptStamp(300, new NodeId(400));
    as2[3] = new AcceptStamp(600, new NodeId(500));
    vv2 = new AcceptVV(as2);
    assert(!vv1.includes(vv2));
    assert(vv2.includes(vv1));

    // Test includes(AcceptStamp)

    // vv1 = (<"400", 300> <"300", 200> <"200", 100> )
    // vv2 = (<"500", 600> <"400", 300> <"300", 200> <"200", 100> )
    as2[0] = new AcceptStamp(100, new NodeId(400));
    as2[1] = new AcceptStamp(300, new NodeId(400));
    as2[2] = new AcceptStamp(700, new NodeId(400));
    as2[3] = new AcceptStamp(100, new NodeId(500));
    as[0] = new AcceptStamp(100, new NodeId(600));
    assert(vv1.includes(as2[0]));
    assert(vv2.includes(as2[0]));
    assert(vv1.includes(as2[1]));
    assert(vv2.includes(as2[1]));
    assert(!vv1.includes(as2[2]));
    assert(!vv2.includes(as2[2]));
    assert(!vv1.includes(as2[3]));
    assert(vv2.includes(as2[3]));
    assert(!vv1.includes(as[0]));
    assert(!vv2.includes(as[0]));

    AcceptStamp[] cps = new AcceptStamp[2];
    
    cps = new AcceptStamp[2];
    cps[0] = new AcceptStamp(99, new NodeId(0));
    cps[1] = new AcceptStamp(-1, new NodeId(1));
    
    AcceptVV cpStartVV = new AcceptVV(cps);
  
    AcceptStamp ACCEPT_BEGINNING_OF_TIME = new AcceptStamp(AcceptStamp.BEFORE_TIME_BEGAN, new NodeId(NodeId.WILDCARD_NODE_ID));
    assert cpStartVV.includes(ACCEPT_BEGINNING_OF_TIME);
    
    // Test includesAnyPartOf

    // vv1 = (<"400", 300> <"300", 200> <"200", 100> )
    // vv2 = (<"500", 600> <"400", 300> <"300", 200> <"200", 100> )
    assert(vv1.includesAnyPartOf(vv1));
    assert(vv2.includesAnyPartOf(vv2));
    assert(vv1.includesAnyPartOf(vv2));
    assert(vv2.includesAnyPartOf(vv1));

    // vv2 = (<"500", 200> <"400", 150> <"300", 100> <"200", 50> )
    as2[0] = new AcceptStamp(50, new NodeId(200));
    as2[1] = new AcceptStamp(100, new NodeId(300));
    as2[2] = new AcceptStamp(150, new NodeId(400));
    as2[3] = new AcceptStamp(200, new NodeId(500));
    vv2 = new AcceptVV(as2);
    assert(vv1.includesAnyPartOf(vv2));
    assert(vv2.includesAnyPartOf(vv1));

    // vv2 = (<"400", 150> <"300", 100> <"200", 50> )
    as[0] = new AcceptStamp(50, new NodeId(200));
    as[1] = new AcceptStamp(100, new NodeId(300));
    as[2] = new AcceptStamp(150, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(vv1.includesAnyPartOf(vv2));
    assert(!vv2.includesAnyPartOf(vv1));

    // vv2 = (<"400", 150> <"300", 100> <"200", 100> )
    as[0] = new AcceptStamp(100, new NodeId(200));
    as[1] = new AcceptStamp(100, new NodeId(300));
    as[2] = new AcceptStamp(150, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(vv1.includesAnyPartOf(vv2));
    assert(vv2.includesAnyPartOf(vv1));

    // vv2 = (<"400", 150> <"300", 300> <"200", 50> )
    as[0] = new AcceptStamp(50, new NodeId(200));
    as[1] = new AcceptStamp(300, new NodeId(300));
    as[2] = new AcceptStamp(150, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(vv1.includesAnyPartOf(vv2));
    assert(vv2.includesAnyPartOf(vv1));

    // Iterator functions implicitly tested by "toString()"

    // Test whether the exception is thrown correctly
    try{
      vv1.getStampByServer(new NodeId(700));
      assert(false);
    }catch(NoSuchEntryException e){
      // NOTE: This exception should be thrown
    }

    // Test the newer methods: new constructor, cloneMinVV, cloneMaxVV

    // vv1 = (<"400", 300> <"300", 200> <"200", 100> )
    // vv2 = (<"400", 150> <"300", 300> <"200", 50> )
    // resultTestVV = (<"400", 150> <"300", 200> <"200", 50> )
    as[0] = new AcceptStamp(50, new NodeId(200));
    as[1] = new AcceptStamp(200, new NodeId(300));
    as[2] = new AcceptStamp(150, new NodeId(400));
    resultTestVV = new AcceptVV(as);
    assert(vv1.equals(vv1.cloneMinVV(vv1)));
    assert(vv2.equals(vv2.cloneMinVV(vv2)));
    assert(resultTestVV.equals(vv1.cloneMinVV(vv2)));
    assert(resultTestVV.equals(vv2.cloneMinVV(vv1)));

    // resultTestVV = (<"400", 300> <"300", 300> <"200", 100> )
    as[0] = new AcceptStamp(100, new NodeId(200));
    as[1] = new AcceptStamp(300, new NodeId(300));
    as[2] = new AcceptStamp(300, new NodeId(400));
    resultTestVV = new AcceptVV(as);
    assert(vv1.equals(vv1.cloneMaxVV(vv1)));
    assert(vv2.equals(vv2.cloneMaxVV(vv2)));
    assert(resultTestVV.equals(vv1.cloneMaxVV(vv2)));
    assert(resultTestVV.equals(vv2.cloneMaxVV(vv1)));

    // vv2 = (<"500", 200> <"400", 150> <"300", 100> <"200", 50> )
    // resultTestVV = (<"500", 200> <"400", 150> <"300", 100> <"200", 50> )
    vv2 = new AcceptVV(as2);
    as3 = new AcceptStamp[4];
    as3[0] = new AcceptStamp(50, new NodeId(200));
    as3[1] = new AcceptStamp(100, new NodeId(300));
    as3[2] = new AcceptStamp(150, new NodeId(400));
    as3[3] = new AcceptStamp(200, new NodeId(500));
    resultTestVV = new AcceptVV(as3);
    assert(resultTestVV.equals(vv2.cloneMinVV(vv1)));
    assert(resultTestVV.equals(vv1.cloneMinVV(vv2)));

    // resultTestVV = (<"500", 200> <"400", 30> <"300", 200> <"200", 100>)
    as3[0] = new AcceptStamp(100, new NodeId(200));
    as3[1] = new AcceptStamp(200, new NodeId(300));
    as3[2] = new AcceptStamp(300, new NodeId(400));
    as3[3] = new AcceptStamp(200, new NodeId(500));
    resultTestVV = new AcceptVV(as3);
    assert(resultTestVV.equals(vv2.cloneMaxVV(vv1)));
    assert(resultTestVV.equals(vv1.cloneMaxVV(vv2)));

    // Test greaterThan
    assert(!vv1.greaterThan(vv1));

    // Case 1: They are equal
    as[0] = new AcceptStamp(100, new NodeId(200));
    as[1] = new AcceptStamp(200, new NodeId(300));
    as[2] = new AcceptStamp(300, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(!vv2.greaterThan(vv1));

    // Case 2: vv2 has one larger value
    as[2] = new AcceptStamp(400, new NodeId(400));
    vv2 = new AcceptVV(as);
    assert(vv2.greaterThan(vv1));
    assert(!vv1.greaterThan(vv2));

    // Case 3: vv2 has one extra entry
    as2[0] = new AcceptStamp(100, new NodeId(200));
    as2[1] = new AcceptStamp(200, new NodeId(300));
    as2[2] = new AcceptStamp(300, new NodeId(400));
    as2[3] = new AcceptStamp(400, new NodeId(500));
    vv2 = new AcceptVV(as2);
    assert(vv2.greaterThan(vv1));
    assert(!vv1.greaterThan(vv2));
  

    //
    // test dropNegatives
    //
    // case 1 vv2 equals vv1 if drops -1
    as2[0] = new AcceptStamp(100, new NodeId(200));
    as2[1] = new AcceptStamp(-1, new NodeId(300));
    as2[2] = new AcceptStamp(300, new NodeId(400));
    as2[3] = new AcceptStamp(-1, new NodeId(500));
    vv2 = new AcceptVV(as2);
    
    as2 = new AcceptStamp[2];
    as2[0] = new AcceptStamp(100, new NodeId(200));
    
    as2[1] = new AcceptStamp(300, new NodeId(400));
    
    vv1 = new AcceptVV(as2);
    assert(vv1.equalsIgnoreNegatives(vv2));
    assert(vv1.equals(vv2.dropNegatives()));

    //case 2 vv1 has negatives for all components
    //       vv2 has no components.
    //       make sure that vv1 = vv2 after drop negatives
    as2 = new AcceptStamp[4];
    as2[0] = new AcceptStamp(-1, new NodeId(200));
    as2[1] = new AcceptStamp(-1, new NodeId(300));
    as2[2] = new AcceptStamp(-1, new NodeId(400));
    as2[3] = new AcceptStamp(-1, new NodeId(500));

    vv1 = new AcceptVV(as2);
    as2 = new AcceptStamp[0];
    vv2 = new AcceptVV(as2);
    assert(vv1.equalsIgnoreNegatives(vv2));
    

    //
    //test getDiff
    //

    as2 = new AcceptStamp[5];
    as2[0] = new AcceptStamp(-1, new NodeId(200));  
    as2[1] = new AcceptStamp(1, new NodeId(300));
    as2[2] = new AcceptStamp(1, new NodeId(400));
    as2[3] = new AcceptStamp(2, new NodeId(500));
    as2[4] = new AcceptStamp(2, new NodeId(600));
    vv1 = new AcceptVV(as2);

    as2 = new AcceptStamp[5];    
    as2[0] = new AcceptStamp(1, new NodeId(200));
    as2[1] = new AcceptStamp(-1, new NodeId(300));
    as2[2] = new AcceptStamp(1, new NodeId(400));
    as2[3] = new AcceptStamp(1, new NodeId(500));
    as2[4] = new AcceptStamp(2, new NodeId(700));

    vv2 = new AcceptVV(as2);

    as2 = new AcceptStamp[5];    
    as2[0] = new AcceptStamp(1, new NodeId(200));
    as2[1] = new AcceptStamp(-1, new NodeId(300));
    as2[2] = new AcceptStamp(1, new NodeId(500));
    as2[3] = new AcceptStamp(-1, new NodeId(600));
    as2[4] = new AcceptStamp(2, new NodeId(700));

    vv3 = new AcceptVV(as2);

    assert((vv2.getDiff(vv1)).equals(vv3)) : "" + vv2.getDiff(vv1) 
       + " vv3= " + vv3;
    
    as2 = new AcceptStamp[5];    
    as2[0] = new AcceptStamp(-1, new NodeId(200));
    as2[1] = new AcceptStamp(1, new NodeId(300));
    as2[2] = new AcceptStamp(2, new NodeId(500));
    as2[3] = new AcceptStamp(2, new NodeId(600));
    as2[4] = new AcceptStamp(-1, new NodeId(700));

    vv3 = new AcceptVV(as2);    
    assert((vv1.getDiff(vv2)).equals(vv3));
    
    
    
  }
  
 /** 
 *  Test the copy constructor 
 **/ 
  public void
  testCopyConstructor(){
    AcceptVV avv1 = null;
    AcceptVV avv2 = null;
    AcceptStamp[] as1 = null;
    CounterVV cvv1 = null;

    // Test 1
    as1 = new AcceptStamp[3];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    avv1 = new AcceptVV(as1);
    avv2 = new AcceptVV(avv1);
    assert(avv1 != avv2);
    assert(avv1.equals(avv2));
    assert(avv2.equals(avv1));

    // Test 2
    cvv1 = new CounterVV(avv1);
    avv2 = new AcceptVV(cvv1);
    assert(avv1 != avv2);
    assert(avv1.equals(avv2));
    assert(avv2.equals(avv1));

    // Test 3
    as1 = new AcceptStamp[5];
    as1[0] = new AcceptStamp(10, new NodeId(100));
    as1[1] = new AcceptStamp(20, new NodeId(200));
    as1[2] = new AcceptStamp(30, new NodeId(300));
    as1[3] = new AcceptStamp(20, new NodeId(400));
    as1[4] = new AcceptStamp(10, new NodeId(500));
    cvv1 = new CounterVV(as1);
    avv2 = new AcceptVV(cvv1);
    avv1 = new AcceptVV(as1);
    assert(avv1 != avv2);
    assert(avv1.equals(avv2));
    assert(avv2.equals(avv1));

  }

 /** 
 *  Test the serialization code 
 **/ 
  public void 
  test14(){
    //test serialization code
    AcceptStamp[] as1 = null;
    
    AcceptVV vv1 = null;
    AcceptVV vv2 = null;

    ByteArrayOutputStream baos = null;
    ByteArrayInputStream bais = null;
    ObjectOutputStream oos = null;
    ObjectInputStream ois = null;

    // Test 1
    // Try a normal vv
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      
      as1 = new AcceptStamp[2];
      as1[0] = new AcceptStamp(190, new NodeId(200));
      as1[1] = new AcceptStamp(180, new NodeId(300));
      vv1 = new AcceptVV(as1);
      //System.out.println("test " + vv1);
      oos.writeObject(vv1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        vv2 = (AcceptVV)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("read vv2: " + vv2);
      assert(vv1 != vv2);
      assert(vv2.equalsIgnoreNegatives(vv1));
      assert(vv1.equalsIgnoreNegatives(vv2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
    
    // Test 2
    // Try an empty vv
    try{
      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      
      
      as1 = new AcceptStamp[0];
      vv1 = new AcceptVV(as1);
      //System.out.println("test " + vv1);

      oos.writeObject(vv1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();
      
      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        vv2 = (AcceptVV)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      //System.out.println("read vv2: " + vv2);
      assert(vv1 != vv2);
      assert(vv2.equalsIgnoreNegatives(vv1));
      assert(vv1.equalsIgnoreNegatives(vv2));
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }

    // Test 3
    // Try a slightly more complicated invalidate
    try{

      baos = new ByteArrayOutputStream();
      oos = new ObjectOutputStream(baos);
      
      as1 = new AcceptStamp[2];
      as1[0] = new AcceptStamp(-1, new NodeId(200));
      as1[1] = new AcceptStamp(-1, new NodeId(300));
      vv1 = new AcceptVV(as1);
      //System.out.println("test " + vv1);
      oos.writeObject(vv1);
      oos.flush();
      oos.close();
      baos.flush();
      baos.close();

      bais = new ByteArrayInputStream(baos.toByteArray());
      ois = new ObjectInputStream(bais);
      try{
        vv2 = (AcceptVV)(ois.readObject());
      }catch(ClassNotFoundException ce){
        ce.printStackTrace();
        assert false;
      }
      assert(vv1 != vv2);
      assert(vv2.equalsIgnoreNegatives(vv1));
      assert(vv1.equalsIgnoreNegatives(vv2));
      //System.out.println("read vv2: " + vv2);
    }catch(IOException e){
      e.printStackTrace();
      System.out.println("" + e);
      assert(false);
    }
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(AcceptVVUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "AcceptVVUnit";
    System.err.print(name + " self test begins...");
    TestRunner tr = new TestRunner();
    tr.doRun(suite());
    System.err.println(name + " self test succeeds");
  }

}
