package code;

 /** 
 *  Unit test for AllPreciseSetUnit
 
 **/ 

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class AllPreciseSetsUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  protected static boolean verbose = false; // Start/end of test
  protected static boolean vverbose = false; // Test internals
  // private Process rmiregistry;
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public AllPreciseSetsUnit (final String s) {
    super (s);
  }


  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    /*
    //
    // Start the registry
    //
    rmiregistry = Runtime.getRuntime().exec("rmiregistry");
    Env.dprintln(verbose, "rmiregistry started");
    Thread.sleep(2000);
    */
  }

  protected void tearDown() throws Exception{
    /*
    rmiregistry.destroy();
    */
    super.tearDown();
    
  }



 /** 
 *  Test basic functions
 
 **/ 
  public void testBasics(){
    Env.verifyAssertEnabled();
    //System.out.println("Testing AllPreciseSets...");
    
    //Config.readConfig("ufs.config");
    makePractiConfig();
    AcceptVV dumVV = AcceptVV.makeVVAllNegatives();
    PreciseSet ps = null;
    PreciseSet newPS = null;
    PreciseSet newPS2 = null;
    PreciseSet newChildPS = null;
    AllPreciseSets aps = null;
    
    //test 1  -- findExactMatch findBestMatch
    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");

    aps = new AllPreciseSets(ps);
    assert aps.findBestMatch("/dog") == ps;
    assert aps.findBestMatch("/") == ps;
    assert aps.findBestMatch("/apple") == newPS;
    assert aps.findBestMatch("/apple/dog") == newPS;
    
    assert aps.findBestMatch("/apple/*") == newPS;
    assert aps.findBestMatch("/cherry") == newPS2;
    assert aps.findBestMatch("/apple/banana") == newChildPS;
    assert aps.findBestMatch("/apple/banana/a") == newChildPS;
    assert aps.findBestMatch("/apple/banana/*") == newChildPS;

    assert aps.findExactMatch("/dog") == null;
    
    assert aps.findExactMatch("/") == ps;
    assert aps.findExactMatch("/apple") == newPS;
    assert aps.findExactMatch("/apple/dog") == null;
    assert aps.findExactMatch("/cherry") == newPS2;
    assert aps.findExactMatch("/apple/banana") == newChildPS;
    assert aps.findExactMatch("/apple/banana/a") == null;

    //test 2 getLpVV
    IncommingConnection ic1 = null;
    IncommingConnection ic2 = null;
    IncommingConnection ic3 = null;
    IncommingConnection ic4 = null;

    SubscriptionSet ss1 = null;
    SubscriptionSet ss2 = null;
    SubscriptionSet ss3 = null;

    Vector vec1 = null;
    Vector vec2 = null;

    AcceptStamp[] as1 = null;
    AcceptStamp[] as2 = null;
    AcceptStamp[] as3 = null;
    AcceptStamp[] as4 = null;
    AcceptStamp[] as5 = null;
    AcceptStamp[] as6 = null;
    AcceptStamp[] as7 = null;
    AcceptStamp[] as8 = null;
    AcceptStamp[] as14 = null;

    AcceptVV vv1 = null;
    AcceptVV vv2 = null;
    AcceptVV vv3 = null;
    AcceptVV vv4 = null;
    AcceptVV vv5 = null;
    AcceptVV vv6 = null;
    AcceptVV vv7 = null;
    AcceptVV vv8 = null;
    AcceptVV vv14 = null;
    as1 = new AcceptStamp[4];
    as1[0] = new AcceptStamp(1, new NodeId(200));
    as1[1] = new AcceptStamp(1, new NodeId(300));
    as1[2] = new AcceptStamp(1, new NodeId(400));
    as1[3] = new AcceptStamp(1, new NodeId(500));

    as2 = new AcceptStamp[4];
    as2[0] = new AcceptStamp(2, new NodeId(200));
    as2[1] = new AcceptStamp(2, new NodeId(300));
    as2[2] = new AcceptStamp(2, new NodeId(400));
    as2[3] = new AcceptStamp(2, new NodeId(500));

    as3 = new AcceptStamp[4];
    as3[0] = new AcceptStamp(3, new NodeId(200));
    as3[1] = new AcceptStamp(3, new NodeId(300));
    as3[2] = new AcceptStamp(3, new NodeId(400));
    as3[3] = new AcceptStamp(3, new NodeId(500));

    as4 = new AcceptStamp[4];
    as4[0] = new AcceptStamp(4, new NodeId(200));
    as4[1] = new AcceptStamp(4, new NodeId(300));
    as4[2] = new AcceptStamp(4, new NodeId(400));
    as4[3] = new AcceptStamp(4, new NodeId(500));

    as5 = new AcceptStamp[4];
    as5[0] = new AcceptStamp(5, new NodeId(200));
    as5[1] = new AcceptStamp(5, new NodeId(300));
    as5[2] = new AcceptStamp(5, new NodeId(400));
    as5[3] = new AcceptStamp(5, new NodeId(500));

    as6 = new AcceptStamp[4];
    as6[0] = new AcceptStamp(6, new NodeId(200));
    as6[1] = new AcceptStamp(6, new NodeId(300));
    as6[2] = new AcceptStamp(6, new NodeId(400));
    as6[3] = new AcceptStamp(6, new NodeId(500));

    as7 = new AcceptStamp[4];
    as7[0] = new AcceptStamp(7, new NodeId(200));
    as7[1] = new AcceptStamp(7, new NodeId(300));
    as7[2] = new AcceptStamp(7, new NodeId(400));
    as7[3] = new AcceptStamp(7, new NodeId(500));

    as8 = new AcceptStamp[4];
    as8[0] = new AcceptStamp(8, new NodeId(200));
    as8[1] = new AcceptStamp(8, new NodeId(300));
    as8[2] = new AcceptStamp(8, new NodeId(400));
    as8[3] = new AcceptStamp(8, new NodeId(500));
    
    as14 = new AcceptStamp[4];
    as14[0] = new AcceptStamp(1, new NodeId(200));
    as14[1] = new AcceptStamp(2, new NodeId(300));
    as14[2] = new AcceptStamp(3, new NodeId(400));
    as14[3] = new AcceptStamp(4, new NodeId(500));

    vv1 = new AcceptVV(as1);
    vv2 = new AcceptVV(as2);
    vv3 = new AcceptVV(as3);
    vv4 = new AcceptVV(as4);
    vv5 = new AcceptVV(as5);
    vv6 = new AcceptVV(as6);
    vv7 = new AcceptVV(as7);
    vv8 = new AcceptVV(as8);
    vv14 = new AcceptVV(as14);

    ps = new PreciseSet("", "", vv1, vv2);
    newPS = new PreciseSet("apple", "/apple", vv3, vv4);
    newPS2 = new PreciseSet("cherry", "/cherry", vv5, vv6);
    newChildPS = new PreciseSet("banana", "/apple/banana", vv7, vv8);
    
    ps.children.put("apple", newPS);
    ps.children.put("cherry", newPS2);
    newPS.children.put("banana", newChildPS);
      
    assert(ps.getChild("apple") == newPS);
    assert(ps.getChild("cherry") == newPS2);
    assert(ps.getChild("apple").getChild("banana") == newChildPS);

    aps = new AllPreciseSets(ps);
    assert aps.getLpVV("/apple/banana").equalsIgnoreNegatives(vv7);
    assert aps.getLpVV("/apple/banana/a").equalsIgnoreNegatives(vv8);
    
    assert aps.getLpVV("/").equalsIgnoreNegatives(vv1);
    assert aps.getLpVV("/dog/bog").equalsIgnoreNegatives(vv2);
    assert aps.getLpVV("/cherry").equalsIgnoreNegatives(vv5);
    assert aps.getLpVV("/apple/a").equalsIgnoreNegatives(vv4);

    try{
      assert aps.split("/apple", "dog") == newPS.getChild("dog");
      aps.split("/apple/egg", "gripe");
      assert false;
    }catch(NoMatchPreciseSetException e){
    }
    try{
      assert aps.split("/cherry", "dog") == newPS2.getChild("dog");
    }catch(NoMatchPreciseSetException e){
      assert false;
    }
    assert ! aps.join("/water");
    assert aps.join("/cherry");
    
    //test 3 getMinLpVV
    ss1 = SubscriptionSet.makeSubscriptionSet(":/");
    ss2 = SubscriptionSet.makeSubscriptionSet("/*");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv1);
    assert aps.getMinLpVV(ss2).equalsIgnoreNegatives(vv2);
    ss1 = SubscriptionSet.makeSubscriptionSet("/dog");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv2);
    ss1 = SubscriptionSet.makeSubscriptionSet("/dog:/:");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv1);
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv5);
    
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry/*");
    
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv6);
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry/*:/cherry");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv5);
    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv7);
    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana/d/d/d");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv8);
    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana/d/d/d:/apple/*:/cherry:/cherry/*");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv4);

    LPVVRecord lr1 = null;
    LPVVRecord lr2 = null;
    
    //test 4 getMatchingLpvvs updateLpVV

    ss1 = SubscriptionSet.makeSubscriptionSet("");
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector(); 
    lr1 = new LPVVRecord("", vv1, null);
    vec2.add(lr1);
    assert vec1.equals(vec2);
    vec1 = aps.getMatchingLpvvs(ss1, vv1);
    assert vec1.size() == 0;
    vec1 = aps.getMatchingLpvvs(ss1, vv14);
    assert vec1.size() == 0;
    
    ss1 = SubscriptionSet.makeSubscriptionSet("/*");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv2);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("", vv1, vv2);
    vec2.add(lr1);
    assert vec1.equals(vec2);
    vec1 = aps.getMatchingLpvvs(ss1, vv14);
    assert vec1.equals(vec2);

    ss1 = SubscriptionSet.makeSubscriptionSet("/dog");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv2);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/dog", vv2, vv2);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    ss1 = SubscriptionSet.makeSubscriptionSet("/dog:");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv1);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("", vv1, null);
    vec2.add(lr1);

    lr1 = new LPVVRecord("/dog", vv2, vv2);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    vec1 = aps.getMatchingLpvvs(ss1, vv14);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/dog", vv2, vv2);
    vec2.add(lr1);
    assert vec1.equals(vec2);
    
    
    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv5);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/cherry", vv5, null);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    vec1 = aps.getMatchingLpvvs(ss1, vv14);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/cherry", vv5, null);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry/*");
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/cherry", vv5, vv6);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv6);
    
    vec1 = aps.getMatchingLpvvs(ss1, vv5);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/cherry", vv5, vv6);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    vec1 = aps.getMatchingLpvvs(ss1, vv6);
    vec2 = new Vector();
    assert vec1.equals(vec2);

    ss1 = SubscriptionSet.makeSubscriptionSet("/cherry/*:/cherry");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv5);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/cherry", vv5, vv6);
    assert vec1.contains(lr1);
    lr1 = new LPVVRecord("/cherry", vv5, null);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.contains(lr1);
    assert vec1.size()==2;

    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv7);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/apple/banana", vv7, null);
    vec2.add(lr1);

    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);

    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/banana/d/d/d");
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv8);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
    vec2 = new Vector();
    lr1 = new LPVVRecord("/apple/banana/d/d/d", vv8, vv8);
    vec2.add(lr1);
    //System.out.println(toStringLPVVRecordVector(vec1));
    assert vec1.equals(vec2);
    ss1 = SubscriptionSet.makeSubscriptionSet("/apple/*:/cherry:/apple/banana/d/d/d:/cherry/*");
//    System.out.println(ss1.getFullPaths().size());
    assert aps.getMinLpVV(ss1).equalsIgnoreNegatives(vv4);
    vec1 = aps.getMatchingLpvvs(ss1, dumVV);
//    System.out.println(toStringLPVVRecordVector(vec1));
//    lr1 = new LPVVRecord("/apple/banana/d/d/d", vv8, vv8);
//    assert vec1.contains(lr1);
    lr1 = new LPVVRecord("/apple", vv3, vv4);
    assert vec1.contains(lr1);
    lr1 = new LPVVRecord("/cherry", vv5, null);
    assert vec1.contains(lr1);
    lr1 = new LPVVRecord("/cherry", vv5, vv6);
    assert vec1.contains(lr1);
    assert vec1.size()==3;

    ps = new PreciseSet("", "");
    ps.split(SubscriptionSet.makeSubscriptionSet("/apple/banana:/cherry"));
    newPS = ps.getChild("apple");
    newPS2 = ps.getChild("cherry");
    newChildPS = newPS.getChild("banana");

    vec1 = new Vector();
    lr1 = new LPVVRecord("/apple/banana/d/d/d", vv8, vv8);
    vec1.add(lr1);
    lr1 = new LPVVRecord("", vv1, vv2);
    vec1.add(lr1);
    aps = new AllPreciseSets(ps);
    aps.updateLpVV(vec1);
    assert ps.getMyLpVV().equalsIgnoreNegatives(vv1);
    assert ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    assert newPS.getMyLpVV().equalsIgnoreNegatives(vv2);
    assert newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    assert newPS2.getMyLpVV().equalsIgnoreNegatives(vv2);
    assert newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    assert newChildPS.getMyLpVV().equalsIgnoreNegatives(vv2);
    assert newChildPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    
    vec2 = new Vector();
    lr1 = new LPVVRecord("/apple", vv3, vv4);
    vec2.add(lr1);
    lr1 = new LPVVRecord("/cherry", vv5, null);
    vec2.add(lr1);
    lr1 = new LPVVRecord("/cherry", vv5, vv6);
    vec2.add(lr1);
    
    aps.updateLpVV(vec2);
    assert ps.getMyLpVV().equalsIgnoreNegatives(vv1);
    assert ps.getOtherChildrenLpVV().equalsIgnoreNegatives(vv2);
    assert newPS.getMyLpVV().equalsIgnoreNegatives(vv3);
    assert newPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv4);
    assert newPS2.getMyLpVV().equalsIgnoreNegatives(vv5);
    assert newPS2.getOtherChildrenLpVV().equalsIgnoreNegatives(vv6);
    assert newChildPS.getMyLpVV().equalsIgnoreNegatives(vv4);
    assert newChildPS.getOtherChildrenLpVV().equalsIgnoreNegatives(vv4);

    //System.out.println("...Finished");

  }

  private static void makePractiConfig(){
    Config.createEmptyConfig();
    long NODE_0_ID = 0;
    long NODE_1_ID = 1;
    long NODE_2_ID = 2;
    long NODE_3_ID = 3;
    long NODE_4_ID = 4;
    String NODE_0_IP = "localhost";
    String NODE_1_IP = "localhost";
    String NODE_2_IP = "localhost";
    String NODE_3_IP = "localhost";
    String NODE_4_IP = "localhost";
    Config.addOneNodeConfig(new NodeId(NODE_0_ID),
                            NODE_0_IP,
                            9988,
                            9989,
                            9991,
                            9992,
                            9990,
                            "test" + File.separatorChar + "local-" + 
			    NODE_0_ID + ".db",
                            "/*",
                            -1L,
                            NODE_0_IP,
                            9993,
                            9994,
                            -1,
  			    Config.CACHE_SIZE_BYTES_DEFAULT,
			    Config.MAX_LOG_DISK_SIZE_BYTES,
			    Config.MAX_LOG_MEM_SIZE_BYTES);
 
   Config.addOneNodeConfig(new NodeId(NODE_1_ID),
			   NODE_1_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_1_ID+".db",
			   "/*",
			   -1L,
			   NODE_1_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   Config.addOneNodeConfig(new NodeId(NODE_2_ID),
			   NODE_2_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_2_ID+".db",
			   "/*",
			   -1L,
			   NODE_2_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);

   Config.addOneNodeConfig(new NodeId(NODE_3_ID),
			   NODE_3_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_3_ID+".db",
			   "/*",
			   -1L,
			   NODE_3_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
    
   
   
   
   Config.addOneNodeConfig(new NodeId(NODE_4_ID),
			   NODE_4_IP,
			   9888,
			   9889,
			   9891,
			   9892,
                            9890,
                           "test" + File.separatorChar + "local-" + 
			   NODE_4_ID+".db",
			   "/*",
			   -1L,
			   NODE_4_IP,
			   9893,
			   9894,
                            -1,
			   Config.CACHE_SIZE_BYTES_DEFAULT,
			   Config.MAX_LOG_DISK_SIZE_BYTES,
			   Config.MAX_LOG_MEM_SIZE_BYTES);
   //Config.writeToFile(configPath);
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(AllPreciseSetsUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java AllPreciseSetsUnit foo" runs
   *   AllPreciseSetsUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "AllPreciseSetsUnit";
    System.err.print(name + " self test begins...");
    //
    // Default: run all tests
    //
    TestSuite ste = new TestSuite();
    Test test;
    boolean doAllTests = true;

    if(s.length > 0){
      int ii;
      for(ii = 0; ii < s.length; ii++){
        if(s[ii].equals("-verbose")){
          verbose = true;
        }
        else if(s[ii].equals("-vverbose")){
          verbose = true;
        }
        else{
          doAllTests = false;
          ste.addTest(new AllPreciseSetsUnit("test" + s[ii]));
        }
        
      }
    }
    if(doAllTests){
      test = suite();
    }
    else{
      test = ste;
    }
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.err.println(name + " self test succeeds");
    System.exit(0); 
  }

}
