package code;

/* AttachJoinUnithelper.java
 * 
 * Helper for AttachJoinUnit -- when invoked by that code, start
 * a Process to do the job for alpha or beta.
 * 
 * (C) Copyright 2006 -- See the file COPYRIGHT for additional details
 */


import java.util.*;
import java.io.*;
import code.security.SecureURANode;
import code.security.holesync.filter.Filter;
import code.security.holesync.filter.SubscriptionSetFilter;

public class AttachJoinUnitHelper {
  private static boolean verbose = false;
  private static boolean vverbose = false;


 /** 
 *  Write the specified PRACTI files. Then wait until reading done. Then write 
 *  more stuff. Then die. When restarted, read the old stuff and write some  
 *  different stuff. 
 **/ 
  public static void main(String s[]) {
    
    if(s.length !=1){
      System.err.println("illegal argument for AttachJoinUnitHelper " + s.length);
      System.exit(-1);

    }else{
      long myNodeId = new Long(s[0]).longValue();
      if(myNodeId == AttachJoinUnit.ALPHA_ID){
	System.out.println("doAlpha");
	doAlpha();
      }else if(myNodeId == AttachJoinUnit.BETA_ID){
	System.out.println("doBeta");
	doBeta(new NodeId(myNodeId));
      }else if(myNodeId == AttachJoinUnit.GAMMA_ID){
	int bcID = 3;
	BarrierClient bc = new BarrierClient("127.0.0.1", AttachJoinUnit.BARRIER_PORT, bcID);
	bc.sendBarrierRequest(0, bcID); // 1 We are up and running 
	if(verbose){
	  System.out.println(" 1 All nodes up and running.");
	}
	
	bc.sendBarrierRequest(0, bcID); // 2 subscription set up done
	if(verbose){
	  System.out.println(" 2 all subscription set up");
	}
	bc.sendBarrierRequest(0, bcID); // 3 helpers can die now
	if(verbose){
	  System.out.println(" 3 helpers can die now.");
	}
	}else{
	System.err.println("illegal nodeId " + myNodeId + " for AttachJoinUnitHelper");
	System.exit(-1);
      }

    }
    
    System.exit(0);
  }
  
 /** 
 *  Beta: 
 *    write /b, /c  
 **/ 
  private static void doBeta(NodeId myNodeId){
        
    NodeId alphaNodeId = new NodeId(AttachJoinUnit.ALPHA_ID);
    //AcceptStamp finalStamp = new AcceptStamp(5, alphaNodeId);
    String tag = "BETA";
    
    int bcID = 2;
    
    
    assert myNodeId.equals(new NodeId(AttachJoinUnit.BETA_ID));

    BarrierClient c = new BarrierClient("127.0.0.1", AttachJoinUnit.BARRIER_PORT, bcID);

    if(vverbose){
      System.out.println(tag + " ID: " + myNodeId.toString());
    }
    URANode node = null;
    if(AttachJoinUnit.useSecure){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
        
      node = new SecureURANode(AttachJoinUnit.CONFIG_PATH, myNodeId,
          Controller.NULL_CONTROLLER,
          true,//cleanDB
          true, 
          new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);//noSynLog
    }else{
      node = new URANode(AttachJoinUnit.CONFIG_PATH, myNodeId,
          Controller.NULL_CONTROLLER,
          true,//cleanDB
          true);//noSynLog
    }

    
    node.getCore().setMaxAccumulateTime(2000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from " + tag + ": " + myNodeId);
    } 
    

    if(verbose){
      System.out.println("AttachJoinUnithelper " + tag + " constructor done");
    }
    
    try{
      c.sendBarrierRequest(0, bcID); // 1 We are up and running 
      if(verbose){
	System.out.println(" 1 All nodes up and running.");
      }

      c.sendBarrierRequest(0, bcID); // 2 subscription set up done
      if(verbose){
	System.out.println(" 2 all subscription set up");
      }
      
      ObjId[] obj = new ObjId[2];
      obj[0] = new ObjId("/b");
      obj[1] = new ObjId("/c");
      
      
      byte firstWriteByte = 32;
      byte lastWriteByte = 42;
    
      byte b1[] = new byte[1];
      b1[0] = firstWriteByte;

      byte b2[] = new byte[1];
      b2[0]= lastWriteByte;
      
      Random r = new Random();
      for(int i = 0; i < AttachJoinUnit.TOTALWRITES; i++){
	try{
	  int writeObj = 0;
	  if(AttachJoinUnit.withThirdObj){
	    writeObj = r.nextInt(2);
	  }
	  li.write(obj[writeObj], 0, b1.length, b1, false);
	
	}catch(Exception e){
	  assert false: "Alpha write fail";
	}
      }

      if(verbose){
	System.out.println("Alpha wrote " + AttachJoinUnit.TOTALWRITES );
      }
      
      
      c.sendBarrierRequest(0, bcID);  // 3 finish
      if(verbose){
	System.out.println(" 3 finish up. ");
      }

    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();
      if(verbose){
	System.out.println(" cleaningup beta");
      }
    }
  }
  
 /** 
 *  Alpha: 
 *    write /a, subscribe from beta for /b 
 **/ 
  private static void doAlpha(){
    BarrierClient c = new BarrierClient("127.0.0.1", AttachJoinUnit.BARRIER_PORT, 1);
    NodeId myNodeId = new NodeId(AttachJoinUnit.ALPHA_ID);
    NodeId betaNodeId = new NodeId(AttachJoinUnit.BETA_ID);
      
    if(vverbose){
      System.out.println("ALPHA ID: " + myNodeId.toString());
    }
    assert(myNodeId.equals(new NodeId(AttachJoinUnit.ALPHA_ID)));
    URANode node = null;
    if(AttachJoinUnit.useSecure){
      SubscriptionSetFilter ssf = new SubscriptionSetFilter(SubscriptionSet.makeSubscriptionSet("/*"));
      LinkedList<Filter> f = new LinkedList<Filter>();
      f.add(ssf);
        
      node = new SecureURANode(AttachJoinUnit.CONFIG_PATH, myNodeId,
          Controller.NULL_CONTROLLER,
          true,//cleanDB
          true, 
          new code.security.liveness.TrustedServerTraceLivenessFilter(null), f);//noSynLog
    }else{
      node = new URANode(AttachJoinUnit.CONFIG_PATH, myNodeId,
          Controller.NULL_CONTROLLER,
          true,//cleanDB
          true);//noSynLog
    }

    
    node.getCore().setMaxAccumulateTime(4000);
    LocalInterface li = node.getLocalInterface();
    RMIClient ci = node.getRMIClientInterface();
    if(verbose){
      System.out.println("HELLO from Alpha: " + myNodeId);
    } 
    if(verbose){
      System.out.println("Attach Unithelper alpha constructor done");
    }

    try{
      c.sendBarrierRequest(0, 1); // 1 We are up and running and Alpha has written; helpers are up
      if(verbose){
	System.out.println(" 1 All nodes up and running.");
      }

      SubscriptionSet ss = SubscriptionSet.makeSubscriptionSet("/b");
      
      //
      // me, alpha, subscribes from Beta for "/b"
      //
      try{
	ci.subscribeInval(betaNodeId, myNodeId, 
			  ss,
			  AcceptVV.makeVVAllNegatives(), false);
	if(vverbose){
	  System.out.println(" Alpha subscribes from beta for /b done.");
	}
      }
      catch(Exception e){
	System.err.println("Exception on subscribe: " + e.toString());
	e.printStackTrace();
	assert(false);
      }
      

      if(vverbose){
	System.out.println("ALPHA::subscribe of subscribeId= " + ss
			   + " from Beta done.");
      }
      
      c.sendBarrierRequest(0, 1); // 2 subscription set up done
      if(verbose){
	System.out.println(" 2 beta and gamma subscribe to alpha");
      }
      
      ObjId[] obj = new ObjId[2];
      obj[0] = new ObjId("/a");
      obj[1] = new ObjId("/c");
      
      
      byte firstWriteByte = 32;
      byte lastWriteByte = 42;
    
      byte b1[] = new byte[1];
      b1[0] = firstWriteByte;

      byte b2[] = new byte[1];
      b2[0]= lastWriteByte;
      
      Random r = new Random();
      //Random r = new Random();
      for(int i = 0; i < AttachJoinUnit.TOTALWRITES; i++){
	try{
	  
	  int writeObj =0;
	  if(AttachJoinUnit.withThirdObj){
	    writeObj= r.nextInt(2);
	  }
	  li.write(obj[writeObj], 0, b1.length, b1, false);
	  
	}catch(Exception e){
	  assert false: "Alpha write fail";
	}
      }

      if(verbose){
	System.out.println("Alpha has updated objects");
      }
      

      c.sendBarrierRequest(0, 1);  // 3 finish
      if(verbose){
	System.out.println(" 3 finish.");
      }

    }finally{
      //
      // Make sure we release all of the ports and mem so that next
      // unit test can run.
      //
      node.shutdown();
      node = null;
      System.gc();
      if(verbose){
	System.out.println(" cleaningup alpha");
      }
    }
  }





}

//---------------------------------------------------------------------------
/*$Log: AttachJoinUnitHelper.java,v $
/*Revision 1.3  2007/08/05 04:43:54  zjiandan
/*SocketServer shutdown quietly
/*
/*Revision 1.2  2007/07/04 21:47:48  zjiandan
/*fix unittests
/**/
//---------------------------------------------------------------------------
