package code;

import java.net.*;
import java.io.*;
import java.util.Random;

public class BarrierClient{
  
  private int nextBarrierNumber;
  private int serverPort;
  private int serverId;
  private String serverHost;
  private static final boolean verbose = false;

  public BarrierClient(String host, int port, int id){
    serverPort = port;
    serverId = id;
    serverHost = host;
    nextBarrierNumber = 0;
  }

  public void sendBarrierRequest(long interval, long stream){
    try{
      if(verbose){
	System.out.println("sendBarrierRequest(" + interval + ", " + stream + ") called" );
      }
      Env.inform("Run " + nextBarrierNumber + " lasted for " + interval);
      BarrierMsg bMsg = new BarrierMsg(serverId, nextBarrierNumber, interval, null, stream);
      Socket s = new Socket(serverHost, serverPort);
      ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
      oos.writeObject(bMsg);
      oos.flush();
//      System.out.println("Waiting for next run to start ...");
      ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
      Integer newBarrierN = (Integer) ois.readObject();
      nextBarrierNumber = newBarrierN.intValue();
//      System.out.println("Start run " + nextBarrierNumber);
      oos.close();
      ois.close();
      s.close();
    } catch (Exception e){
      e.printStackTrace();
    } 
  }

  public static void main(String[] argv){
    int port = (new Integer(argv[0])).intValue();
    String host = argv[1];
    int id = (new Integer(argv[2])).intValue();
    int rounds = (new Integer(argv[3])).intValue();
    BarrierClient bc = new BarrierClient(host, port, id);
    
    Random r = new Random();

    for(int i=0; i<rounds; i++){
      long bt = System.currentTimeMillis();
      try{
        long l = (1 + r.nextInt(9)) * 1000L;
        Thread.sleep(l);
      } catch (Exception e){
        e.printStackTrace();
      }
      long et = System.currentTimeMillis();
      bc.sendBarrierRequest(et-bt, 0);
    }
  }
}


